/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.providers;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.packet.ScoreboardManager;
import net.william278.velocitab.sorting.SortingManager;
import net.william278.velocitab.tab.PlayerTabList;

public interface ScoreboardProvider {
    public Velocitab getPlugin();

    public Optional<ScoreboardManager> getScoreboardManager();

    public void setScoreboardManager(ScoreboardManager var1);

    public PlayerTabList getTabList();

    public void setTabList(PlayerTabList var1);

    public SortingManager getSortingManager();

    public void setSortingManager(SortingManager var1);

    default public void prepareScoreboard() {
        if (this.getPlugin().getSettings().isSendScoreboardPackets()) {
            ScoreboardManager scoreboardManager = new ScoreboardManager(this.getPlugin());
            this.setScoreboardManager(scoreboardManager);
            scoreboardManager.registerPacket();
        }
        PlayerTabList tabList = new PlayerTabList(this.getPlugin());
        this.setTabList(tabList);
        this.getPlugin().getServer().getEventManager().register((Object)this, (Object)tabList);
        this.getPlugin().getServer().getScheduler().buildTask((Object)this, tabList::load).delay(1L, TimeUnit.SECONDS).schedule();
        SortingManager sortingManager = new SortingManager(this.getPlugin());
        this.setSortingManager(sortingManager);
    }

    default public void disableScoreboardManager() {
        if (this.getScoreboardManager().isPresent() && this.getPlugin().getSettings().isSendScoreboardPackets()) {
            this.getScoreboardManager().get().close();
            this.getScoreboardManager().get().unregisterPacket();
        }
        this.getTabList().close();
    }
}

