/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.config;

import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.commons.lang3.StringUtils;
import net.william278.velocitab.libraries.commons.lang3.function.TriFunction;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.tab.Nametag;
import org.slf4j.event.Level;

public enum Placeholder {
    PLAYERS_ONLINE((plugin, player) -> Integer.toString(plugin.getServer().getPlayerCount())),
    MAX_PLAYERS_ONLINE((plugin, player) -> Integer.toString(plugin.getServer().getConfiguration().getShowMaxPlayers())),
    LOCAL_PLAYERS_ONLINE((plugin, player) -> player.getPlayer().getCurrentServer().map(ServerConnection::getServer).map(RegisteredServer::getPlayersConnected).map(players -> Integer.toString(players.size())).orElse("")),
    GROUP_PLAYERS_ONLINE_((param, plugin, player) -> plugin.getTabGroups().getGroup((String)param).map(group -> Integer.toString(group.getPlayers((Velocitab)plugin).size())).orElse("Group " + param + " not found")),
    GROUP_PLAYERS_ONLINE((plugin, player) -> Integer.toString(player.getGroup().getPlayers((Velocitab)plugin).size())),
    CURRENT_DATE((plugin, player) -> DateTimeFormatter.ofPattern("dd MMM yyyy").format(LocalDateTime.now())),
    CURRENT_TIME((plugin, player) -> DateTimeFormatter.ofPattern("HH:mm:ss").format(LocalDateTime.now())),
    USERNAME((plugin, player) -> player.getCustomName().orElse(player.getPlayer().getUsername())),
    USERNAME_LOWER((plugin, player) -> player.getCustomName().orElse(player.getPlayer().getUsername()).toLowerCase()),
    SERVER((plugin, player) -> player.getServerDisplayName((Velocitab)plugin)),
    PING((plugin, player) -> Long.toString(player.getPlayer().getPing())),
    PREFIX((plugin, player) -> player.getRole().getPrefix().orElse(Placeholder.getPlaceholderFallback(plugin, "%luckperms_prefix%"))),
    SUFFIX((plugin, player) -> player.getRole().getSuffix().orElse(Placeholder.getPlaceholderFallback(plugin, "%luckperms_suffix%"))),
    ROLE((plugin, player) -> player.getRole().getName().orElse(Placeholder.getPlaceholderFallback(plugin, "%luckperms_primary_group_name%"))),
    ROLE_DISPLAY_NAME((plugin, player) -> player.getRole().getDisplayName().orElse(Placeholder.getPlaceholderFallback(plugin, "%luckperms_primary_group_name%"))),
    ROLE_WEIGHT((plugin, player) -> player.getRoleWeightString()),
    SERVER_GROUP((plugin, player) -> player.getGroup().name()),
    SERVER_GROUP_INDEX((plugin, player) -> Integer.toString(player.getServerGroupPosition((Velocitab)plugin))),
    DEBUG_TEAM_NAME((plugin, player) -> plugin.getFormatter().escape(player.getLastTeamName().orElse(""))),
    LUCKPERMS_META_((param, plugin, player) -> plugin.getLuckPermsHook().map(hook -> hook.getMeta(player.getPlayer(), (String)param)).orElse(Placeholder.getPlaceholderFallback(plugin, "%luckperms_meta_" + param + "%")));

    private final TriFunction<String, Velocitab, TabPlayer, String> replacer;
    private final boolean parameterised;
    private final Pattern pattern;
    private static final Pattern checkPlaceholders;
    private static final String DELIMITER = ":::";

    private Placeholder(BiFunction<Velocitab, TabPlayer, String> replacer) {
        this.parameterised = false;
        this.replacer = (text, player, plugin) -> (String)replacer.apply((Velocitab)player, (TabPlayer)plugin);
        this.pattern = Pattern.compile("%" + this.name().toLowerCase() + "%");
    }

    private Placeholder(TriFunction<String, Velocitab, TabPlayer, String> parameterisedReplacer) {
        this.parameterised = true;
        this.replacer = parameterisedReplacer;
        this.pattern = Pattern.compile("%" + this.name().toLowerCase() + "[^%]+%", 2);
    }

    public static CompletableFuture<Nametag> replace(@NotNull Nametag nametag, @NotNull Velocitab plugin, @NotNull TabPlayer player) {
        return ((CompletableFuture)Placeholder.replace(nametag.prefix() + DELIMITER + nametag.suffix(), plugin, player).thenApply(s -> s.split(DELIMITER, 2))).thenApply(v -> new Nametag(v[0], ((String[])v).length > 1 ? v[1] : ""));
    }

    @NotNull
    private static String getPlaceholderFallback(@NotNull Velocitab plugin, @NotNull String fallback) {
        if (plugin.getPAPIProxyBridgeHook().isPresent() && plugin.getSettings().isFallbackToPapiIfPlaceholderBlank()) {
            return fallback;
        }
        return "";
    }

    public static CompletableFuture<String> replace(@NotNull String format, @NotNull Velocitab plugin, @NotNull TabPlayer player) {
        if (format.equals(DELIMITER)) {
            return CompletableFuture.completedFuture("");
        }
        for (Placeholder placeholder : Placeholder.values()) {
            Matcher matcher = placeholder.pattern.matcher(format);
            format = placeholder.parameterised ? matcher.replaceAll(matchResult -> Matcher.quoteReplacement(placeholder.replacer.apply(StringUtils.chop(matchResult.group().replace("%" + placeholder.name().toLowerCase(), "")), plugin, player))) : matcher.replaceAll(matchResult -> Matcher.quoteReplacement(placeholder.replacer.apply(null, plugin, player)));
        }
        String replaced = format;
        if (!checkPlaceholders.matcher(replaced).find()) {
            return CompletableFuture.completedFuture(replaced);
        }
        return plugin.getPAPIProxyBridgeHook().map(hook -> hook.formatPlaceholders(replaced, player.getPlayer()).exceptionally(e -> {
            plugin.log(Level.ERROR, "An error occurred whilst parsing placeholders: " + e.getMessage(), new Throwable[0]);
            return replaced;
        })).orElse(CompletableFuture.completedFuture(replaced)).exceptionally(e -> {
            plugin.log(Level.ERROR, "An error occurred whilst parsing placeholders: " + e.getMessage(), new Throwable[0]);
            return replaced;
        });
    }

    static {
        checkPlaceholders = Pattern.compile("%.*?%");
    }
}

