/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.packet;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.proxy.protocol.packet.UpsertPlayerInfoPacket;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.List;
import java.util.Optional;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.player.TabPlayer;

public class PlayerChannelHandler
extends ChannelDuplexHandler {
    private final Velocitab plugin;
    private final Player player;

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof UpsertPlayerInfoPacket)) {
            super.write(ctx, msg, promise);
            return;
        }
        UpsertPlayerInfoPacket minecraftPacket = (UpsertPlayerInfoPacket)msg;
        Optional<TabPlayer> tabPlayer = this.plugin.getTabList().getTabPlayer(this.player);
        if (tabPlayer.isEmpty()) {
            super.write(ctx, msg, promise);
            return;
        }
        if (this.plugin.getSettings().isRemoveSpectatorEffect() && minecraftPacket.containsAction(UpsertPlayerInfoPacket.Action.UPDATE_GAME_MODE)) {
            this.forceGameMode(minecraftPacket.getEntries());
        }
        if (minecraftPacket.containsAction(UpsertPlayerInfoPacket.Action.ADD_PLAYER)) {
            minecraftPacket.getEntries().stream().filter(entry -> entry.getProfile() != null && !entry.getProfile().getId().equals(entry.getProfileId())).forEach(entry -> entry.setListed(false));
        }
        if (!minecraftPacket.containsAction(UpsertPlayerInfoPacket.Action.ADD_PLAYER) && !minecraftPacket.containsAction(UpsertPlayerInfoPacket.Action.UPDATE_LISTED)) {
            super.write(ctx, msg, promise);
            return;
        }
        if (minecraftPacket.getEntries().stream().allMatch(entry -> entry.getProfile() != null && entry.getProfile().getName().startsWith("CIT"))) {
            super.write(ctx, msg, promise);
            return;
        }
        this.plugin.getPacketEventManager().handleEntry(minecraftPacket, this.player);
        super.write(ctx, msg, promise);
    }

    private void forceGameMode(@NotNull List<UpsertPlayerInfoPacket.Entry> entries) {
        entries.stream().filter(entry -> entry.getProfileId() != null && entry.getGameMode() == 3 && !entry.getProfileId().equals(this.player.getUniqueId())).forEach(entry -> entry.setGameMode(0));
    }

    public PlayerChannelHandler(Velocitab plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }
}

