/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.player;

import java.util.Objects;
import java.util.Optional;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.annotations.Nullable;

public class Role
implements Comparable<Role> {
    public static final int DEFAULT_WEIGHT = 0;
    public static final Role DEFAULT_ROLE = new Role(0, null, null, null, null);
    private final int weight;
    @Nullable
    private final String name;
    @Nullable
    private final String displayName;
    @Nullable
    private final String prefix;
    @Nullable
    private final String suffix;

    @Override
    public int compareTo(@NotNull Role o) {
        return Double.compare(this.weight, o.weight);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public Optional<String> getDisplayName() {
        return Optional.ofNullable(this.displayName).or(this::getName);
    }

    public Optional<String> getPrefix() {
        return Optional.ofNullable(this.prefix);
    }

    public Optional<String> getSuffix() {
        return Optional.ofNullable(this.suffix);
    }

    @NotNull
    protected String getWeightString() {
        return Integer.toString(this.weight);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Role role = (Role)obj;
        return this.weight == role.weight && Objects.equals(this.name, role.name) && Objects.equals(this.displayName, role.displayName) && Objects.equals(this.prefix, role.prefix) && Objects.equals(this.suffix, role.suffix);
    }

    public Role(int weight, @Nullable String name, @Nullable String displayName, @Nullable String prefix, @Nullable String suffix) {
        this.weight = weight;
        this.name = name;
        this.displayName = displayName;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public int getWeight() {
        return this.weight;
    }
}

