/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.tab;

import com.google.common.collect.Maps;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.player.TabList;
import com.velocitypowered.api.proxy.player.TabListEntry;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.scheduler.ScheduledTask;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.api.PlayerAddedToTabEvent;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.config.Placeholder;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.annotations.Nullable;
import net.william278.velocitab.player.Role;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.tab.GroupTasks;
import net.william278.velocitab.tab.TabListListener;
import net.william278.velocitab.tab.VanishTabList;
import org.slf4j.event.Level;

public class PlayerTabList {
    private final Velocitab plugin;
    private final VanishTabList vanishTabList;
    private final Map<UUID, TabPlayer> players;
    private final Map<Group, GroupTasks> groupTasks;

    public PlayerTabList(@NotNull Velocitab plugin) {
        this.plugin = plugin;
        this.vanishTabList = new VanishTabList(plugin, this);
        this.players = Maps.newConcurrentMap();
        this.groupTasks = Maps.newConcurrentMap();
        this.reloadUpdate();
        this.registerListener();
    }

    private void registerListener() {
        this.plugin.getServer().getEventManager().register((Object)this.plugin, (Object)new TabListListener(this.plugin, this));
    }

    public Optional<TabPlayer> getTabPlayer(@NotNull Player player) {
        return Optional.ofNullable(this.players.get(player.getUniqueId()));
    }

    public Optional<TabPlayer> getTabPlayer(@NotNull UUID uuid) {
        return Optional.ofNullable(this.players.get(uuid));
    }

    public void load() {
        this.plugin.getServer().getAllPlayers().forEach(p -> {
            Optional server = p.getCurrentServer();
            if (server.isEmpty()) {
                return;
            }
            String serverName = ((ServerConnection)server.get()).getServerInfo().getName();
            Group group = this.getGroup(serverName);
            boolean isDefault = group.registeredServers(this.plugin).stream().noneMatch(s -> s.getServerInfo().getName().equals(serverName));
            if (isDefault && !this.plugin.getSettings().isFallbackEnabled()) {
                return;
            }
            this.joinPlayer((Player)p, group);
        });
    }

    public void close() {
        this.groupTasks.values().forEach(GroupTasks::cancel);
        this.plugin.getServer().getAllPlayers().forEach(p -> {
            Optional server = p.getCurrentServer();
            if (server.isEmpty()) {
                return;
            }
            TabPlayer tabPlayer = this.players.get(p.getUniqueId());
            if (tabPlayer == null) {
                return;
            }
            Set<RegisteredServer> serversInGroup = tabPlayer.getGroup().registeredServers(this.plugin);
            if (serversInGroup.isEmpty()) {
                return;
            }
            serversInGroup.remove(((ServerConnection)server.get()).getServer());
            serversInGroup.forEach(s -> s.getPlayersConnected().forEach(t -> t.getTabList().removeEntry(p.getUniqueId())));
        });
    }

    protected void joinPlayer(@NotNull Player joined, @NotNull Group group) {
        TabPlayer tabPlayer = this.getTabPlayer(joined).orElseGet(() -> this.createTabPlayer(joined, group));
        tabPlayer.setGroup(group);
        this.players.putIfAbsent(joined.getUniqueId(), tabPlayer);
        String serverName = this.getServerName(joined);
        tabPlayer.setLastServer(serverName);
        boolean isVanished = this.plugin.getVanishManager().isVanished(joined.getUsername());
        ((CompletableFuture)tabPlayer.getDisplayName(this.plugin).thenAccept(d -> {
            joined.getTabList().getEntry(joined.getUniqueId()).ifPresentOrElse(e -> e.setDisplayName(d), () -> joined.getTabList().addEntry(this.createEntry(tabPlayer, joined.getTabList(), (Component)d)));
            ((CompletableFuture)tabPlayer.sendHeaderAndFooter(this).thenAccept(v -> tabPlayer.setLoaded(true))).exceptionally(throwable -> {
                this.plugin.log(Level.ERROR, String.format("Failed to send header and footer for %s (UUID: %s)", joined.getUsername(), joined.getUniqueId()), (Throwable)throwable);
                return null;
            });
            Set serversInGroup = group.registeredServers(this.plugin).stream().map(server -> server.getServerInfo().getName()).collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
            serversInGroup.remove(serverName);
            this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> {
                TabList tabList = joined.getTabList();
                Set<TabPlayer> tabPlayers = group.getTabPlayers(this.plugin);
                for (TabPlayer player : tabPlayers) {
                    if (group.onlyListPlayersInSameServer() && !serverName.equals(this.getServerName(player.getPlayer()))) continue;
                    if (!isVanished || this.plugin.getVanishManager().canSee(player.getPlayer().getUsername(), joined.getUsername())) {
                        this.addPlayerToTabList(player, tabPlayer, (Component)d);
                    } else {
                        player.getPlayer().getTabList().removeEntry(joined.getUniqueId());
                    }
                    if (this.plugin.getVanishManager().isVanished(player.getPlayer().getUsername()) && !this.plugin.getVanishManager().canSee(joined.getUsername(), player.getPlayer().getUsername()) && player.getPlayer() != joined) {
                        tabList.removeEntry(player.getPlayer().getUniqueId());
                    } else {
                        tabList.getEntry(player.getPlayer().getUniqueId()).ifPresentOrElse(entry -> ((CompletableFuture)player.getDisplayName(this.plugin).thenAccept(arg_0 -> ((TabListEntry)entry).setDisplayName(arg_0))).exceptionally(throwable -> {
                            this.plugin.log(Level.ERROR, String.format("Failed to set display name for %s (UUID: %s)", player.getPlayer().getUsername(), player.getPlayer().getUniqueId()), (Throwable)throwable);
                            return null;
                        }), () -> this.createEntry(player, tabList).thenAccept(arg_0 -> ((TabList)tabList).addEntry(arg_0)));
                    }
                    player.sendHeaderAndFooter(this);
                }
                this.plugin.getScoreboardManager().ifPresent(s -> {
                    s.resendAllTeams(tabPlayer);
                    tabPlayer.getTeamName(this.plugin).thenAccept(t -> s.updateRole(tabPlayer, (String)t, false));
                });
                this.fixDuplicateEntries(joined);
                this.plugin.getServer().getEventManager().fireAndForget((Object)new PlayerAddedToTabEvent(tabPlayer, group));
            }).delay(300L, TimeUnit.MILLISECONDS).schedule();
        })).exceptionally(throwable -> {
            this.plugin.log(Level.ERROR, String.format("Failed to set display name for %s (UUID: %s)", joined.getUsername(), joined.getUniqueId()), (Throwable)throwable);
            return null;
        });
    }

    @NotNull
    private String getServerName(@NotNull Player player) {
        return player.getCurrentServer().map(serverConnection -> serverConnection.getServerInfo().getName()).orElse("");
    }

    private void fixDuplicateEntries(@NotNull Player target) {
        try {
            Field entriesField = target.getTabList().getClass().getDeclaredField("entries");
            entriesField.setAccessible(true);
            Map entries = (Map)entriesField.get(target.getTabList());
            entries.entrySet().stream().filter(entry -> ((TabListEntry)entry.getValue()).getProfile() != null).filter(entry -> ((TabListEntry)entry.getValue()).getProfile().getId().equals(target.getUniqueId())).filter(entry -> !((UUID)entry.getKey()).equals(target.getUniqueId())).forEach(entry -> target.getTabList().removeEntry((UUID)entry.getKey()));
        }
        catch (Throwable error) {
            this.plugin.log(Level.ERROR, "Failed to fix duplicate entries", error);
        }
    }

    protected void removePlayer(@NotNull Player target) {
        this.removePlayer(target, null);
    }

    protected void removePlayer(@NotNull Player target, @Nullable RegisteredServer server) {
        UUID uuid = target.getUniqueId();
        this.plugin.getServer().getAllPlayers().forEach(player -> player.getTabList().removeEntry(uuid));
        Set currentServerPlayers = Optional.ofNullable(server).map(RegisteredServer::getPlayersConnected).map(HashSet::new).orElseGet(HashSet::new);
        currentServerPlayers.add(target);
        this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> this.getPlayers().values().stream().filter(p -> currentServerPlayers.isEmpty() || !currentServerPlayers.contains(p.getPlayer())).forEach(player -> {
            player.getPlayer().getTabList().removeEntry(uuid);
            player.sendHeaderAndFooter(this);
        })).delay(500L, TimeUnit.MILLISECONDS).schedule();
        this.plugin.getScoreboardManager().ifPresent(manager -> manager.resetCache(target));
        this.getPlayers().remove(uuid);
    }

    @NotNull
    protected CompletableFuture<TabListEntry> createEntry(@NotNull TabPlayer player, @NotNull TabList tabList) {
        return player.getDisplayName(this.plugin).thenApply(name -> this.createEntry(player, tabList, (Component)name));
    }

    protected TabListEntry createEntry(@NotNull TabPlayer player, @NotNull TabList tabList, @NotNull Component displayName) {
        return TabListEntry.builder().profile(player.getPlayer().getGameProfile()).displayName(displayName).latency(Math.max((int)player.getPlayer().getPing(), 0)).tabList(tabList).build();
    }

    private void addPlayerToTabList(@NotNull TabPlayer player, @NotNull TabPlayer newPlayer, @NotNull Component displayName) {
        if (newPlayer.getPlayer().getUniqueId().equals(player.getPlayer().getUniqueId())) {
            return;
        }
        this.plugin.getPacketEventManager().getVelocitabEntries().add(newPlayer.getPlayer().getUniqueId());
        this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> this.plugin.getPacketEventManager().getVelocitabEntries().remove(newPlayer.getPlayer().getUniqueId())).delay(500L, TimeUnit.MILLISECONDS).schedule();
        player.getPlayer().getTabList().getEntries().stream().filter(e -> e.getProfile().getId().equals(newPlayer.getPlayer().getUniqueId())).findFirst().ifPresentOrElse(entry -> entry.setDisplayName(displayName), () -> player.getPlayer().getTabList().addEntry(this.createEntry(newPlayer, player.getPlayer().getTabList(), displayName)));
    }

    @NotNull
    public TabPlayer createTabPlayer(@NotNull Player player, @NotNull Group group) {
        return new TabPlayer(this.plugin, player, this.plugin.getLuckPermsHook().map(hook -> hook.getPlayerRole(player)).orElse(Role.DEFAULT_ROLE), group);
    }

    public void updatePlayer(@NotNull TabPlayer tabPlayer, boolean force) {
        if (!tabPlayer.getPlayer().isActive()) {
            this.removeOfflinePlayer(tabPlayer.getPlayer());
            return;
        }
        tabPlayer.getTeamName(this.plugin).thenAccept(teamName -> {
            if (teamName.isBlank()) {
                return;
            }
            this.plugin.getScoreboardManager().ifPresent(manager -> manager.updateRole(tabPlayer, (String)teamName, force));
        });
    }

    public void updatePlayerDisplayName(@NotNull TabPlayer tabPlayer) {
        Component lastDisplayName = tabPlayer.getLastDisplayName();
        tabPlayer.getDisplayName(this.plugin).thenAccept(displayName -> {
            if (displayName == null || displayName.equals(lastDisplayName)) {
                return;
            }
            boolean isVanished = this.plugin.getVanishManager().isVanished(tabPlayer.getPlayer().getUsername());
            Set<TabPlayer> players = tabPlayer.getGroup().getTabPlayers(this.plugin, tabPlayer);
            players.forEach(player -> {
                if (isVanished && !this.plugin.getVanishManager().canSee(player.getPlayer().getUsername(), tabPlayer.getPlayer().getUsername())) {
                    return;
                }
                player.getPlayer().getTabList().getEntries().stream().filter(e -> e.getProfile().getId().equals(tabPlayer.getPlayer().getUniqueId())).findFirst().ifPresent(entry -> entry.setDisplayName(displayName));
            });
        });
    }

    public void updateDisplayNames() {
        this.players.values().forEach(this::updatePlayerDisplayName);
    }

    public CompletableFuture<Component> getHeader(@NotNull TabPlayer player) {
        String header = player.getGroup().getHeader(player.getHeaderIndex());
        return Placeholder.replace(header, this.plugin, player).thenApply(replaced -> this.plugin.getFormatter().format((String)replaced, player, this.plugin));
    }

    public CompletableFuture<Component> getFooter(@NotNull TabPlayer player) {
        String footer = player.getGroup().getFooter(player.getFooterIndex());
        return Placeholder.replace(footer, this.plugin, player).thenApply(replaced -> this.plugin.getFormatter().format((String)replaced, player, this.plugin));
    }

    private void updatePeriodically(@NotNull Group group) {
        this.cancelTasks(group);
        ScheduledTask headerFooterTask = null;
        ScheduledTask updateTask = null;
        if (group.headerFooterUpdateRate() > 0) {
            headerFooterTask = this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> this.updateGroupPlayers(group, false, true)).delay(1L, TimeUnit.SECONDS).repeat((long)Math.max(200, group.headerFooterUpdateRate()), TimeUnit.MILLISECONDS).schedule();
        }
        if (group.placeholderUpdateRate() > 0) {
            updateTask = this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> this.updateGroupPlayers(group, true, false)).delay(1L, TimeUnit.SECONDS).repeat((long)Math.max(200, group.placeholderUpdateRate()), TimeUnit.MILLISECONDS).schedule();
        }
        ScheduledTask latencyTask = this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> this.updateLatency(group)).delay(1L, TimeUnit.SECONDS).repeat(3L, TimeUnit.SECONDS).schedule();
        this.groupTasks.put(group, new GroupTasks(headerFooterTask, updateTask, latencyTask));
    }

    private void updateLatency(@NotNull Group group) {
        Set<TabPlayer> groupPlayers = group.getTabPlayers(this.plugin);
        if (groupPlayers.isEmpty()) {
            return;
        }
        groupPlayers.stream().filter(player -> player.getPlayer().isActive()).forEach(player -> {
            int latency = (int)player.getPlayer().getPing();
            Set<TabPlayer> players = group.getTabPlayers(this.plugin, (TabPlayer)player);
            players.forEach(p -> p.getPlayer().getTabList().getEntries().stream().filter(e -> e.getProfile().getId().equals(player.getPlayer().getUniqueId())).findFirst().ifPresent(entry -> entry.setLatency(Math.max(latency, 0))));
        });
    }

    private void updateGroupPlayers(@NotNull Group group, boolean all, boolean incrementIndexes) {
        Set<TabPlayer> groupPlayers = group.getTabPlayers(this.plugin);
        if (groupPlayers.isEmpty()) {
            return;
        }
        groupPlayers.stream().filter(player -> player.getPlayer().isActive()).forEach(player -> {
            if (incrementIndexes) {
                player.incrementIndexes();
            }
            if (all) {
                this.updatePlayer((TabPlayer)player, false);
            }
            player.sendHeaderAndFooter(this);
        });
        if (all) {
            this.updateDisplayNames();
        }
    }

    private void cancelTasks(@NotNull Group group) {
        GroupTasks tasks = this.groupTasks.get(group);
        if (tasks != null) {
            tasks.cancel();
            this.groupTasks.remove(group);
        }
    }

    public void reloadUpdate() {
        this.plugin.getTabGroups().getGroups().forEach(this::updatePeriodically);
        if (this.players.isEmpty()) {
            return;
        }
        this.players.values().forEach(player -> {
            Optional server = player.getPlayer().getCurrentServer();
            if (server.isEmpty()) {
                return;
            }
            String serverName = ((ServerConnection)server.get()).getServerInfo().getName();
            Group group = this.getGroup(serverName);
            player.setGroup(group);
            this.updatePlayer((TabPlayer)player, true);
            player.sendHeaderAndFooter(this);
        });
        this.updateDisplayNames();
    }

    @NotNull
    public Group getGroup(@NotNull String serverName) {
        return this.plugin.getTabGroups().getGroupFromServer(serverName, this.plugin);
    }

    public void removeOfflinePlayer(@NotNull Player player) {
        this.players.remove(player.getUniqueId());
    }

    public VanishTabList getVanishTabList() {
        return this.vanishTabList;
    }

    public Map<UUID, TabPlayer> getPlayers() {
        return this.players;
    }
}

