/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.config;

import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import it.unimi.dsi.fastutil.Pair;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.Formatter;
import net.william278.velocitab.hook.miniconditions.MiniConditionManager;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.annotations.Nullable;
import net.william278.velocitab.libraries.commons.lang3.StringUtils;
import net.william278.velocitab.libraries.commons.lang3.function.TriFunction;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.tab.Nametag;
import org.slf4j.event.Level;

public enum Placeholder {
    PLAYERS_ONLINE((plugin, player) -> Integer.toString(plugin.getServer().getPlayerCount())),
    MAX_PLAYERS_ONLINE((plugin, player) -> Integer.toString(plugin.getServer().getConfiguration().getShowMaxPlayers())),
    LOCAL_PLAYERS_ONLINE((plugin, player) -> player.getPlayer().getCurrentServer().map(ServerConnection::getServer).map(RegisteredServer::getPlayersConnected).map(players -> Integer.toString(players.size())).orElse("")),
    GROUP_PLAYERS_ONLINE((param, plugin, player) -> {
        if (param.isEmpty()) {
            return Integer.toString(player.getGroup().getPlayers((Velocitab)plugin).size());
        }
        return plugin.getTabGroups().getGroup((String)param).map(group -> Integer.toString(group.getPlayers((Velocitab)plugin).size())).orElse("Group " + param + " not found");
    }),
    CURRENT_DATE_DAY((plugin, player) -> DateTimeFormatter.ofPattern("dd").format(LocalDateTime.now())),
    CURRENT_DATE_WEEKDAY((param, plugin, player) -> {
        if (param.isEmpty()) {
            return DateTimeFormatter.ofPattern("EEEE").format(LocalDateTime.now());
        }
        String countryCode = param.toUpperCase();
        Locale locale = Locale.forLanguageTag(countryCode);
        return DateTimeFormatter.ofPattern("EEEE").withLocale(locale).format(LocalDateTime.now());
    }),
    CURRENT_DATE_MONTH((plugin, player) -> DateTimeFormatter.ofPattern("MM").format(LocalDateTime.now())),
    CURRENT_DATE_YEAR((plugin, player) -> DateTimeFormatter.ofPattern("yyyy").format(LocalDateTime.now())),
    CURRENT_DATE((param, plugin, player) -> {
        if (param.isEmpty()) {
            return DateTimeFormatter.ofPattern("dd/MM/yyyy").format(LocalDateTime.now());
        }
        String countryCode = param.toUpperCase();
        Locale locale = Locale.forLanguageTag(countryCode);
        return DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withLocale(locale).format(LocalDateTime.now());
    }),
    CURRENT_TIME_HOUR((plugin, player) -> DateTimeFormatter.ofPattern("HH").format(LocalDateTime.now())),
    CURRENT_TIME_MINUTE((plugin, player) -> DateTimeFormatter.ofPattern("mm").format(LocalDateTime.now())),
    CURRENT_TIME_SECOND((plugin, player) -> DateTimeFormatter.ofPattern("ss").format(LocalDateTime.now())),
    CURRENT_TIME((param, plugin, player) -> {
        if (param.isEmpty()) {
            return DateTimeFormatter.ofPattern("HH:mm:ss").format(LocalTime.now());
        }
        String countryCode = param.toUpperCase();
        Locale locale = Locale.forLanguageTag(countryCode);
        return DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT).withLocale(locale).format(LocalTime.now());
    }),
    USERNAME((plugin, player) -> player.getCustomName().orElse(player.getPlayer().getUsername())),
    USERNAME_LOWER((plugin, player) -> player.getCustomName().orElse(player.getPlayer().getUsername()).toLowerCase()),
    SERVER((plugin, player) -> player.getServerDisplayName((Velocitab)plugin)),
    PING((plugin, player) -> Long.toString(player.getPlayer().getPing())),
    PREFIX((plugin, player) -> player.getRole().getPrefix().orElse(Placeholder.getPlaceholderFallback(plugin, "%luckperms_prefix%"))),
    SUFFIX((plugin, player) -> player.getRole().getSuffix().orElse(Placeholder.getPlaceholderFallback(plugin, "%luckperms_suffix%"))),
    ROLE((plugin, player) -> player.getRole().getName().orElse(Placeholder.getPlaceholderFallback(plugin, "%luckperms_primary_group_name%"))),
    ROLE_DISPLAY_NAME((plugin, player) -> player.getRole().getDisplayName().orElse(Placeholder.getPlaceholderFallback(plugin, "%luckperms_primary_group_name%"))),
    ROLE_WEIGHT((plugin, player) -> player.getRoleWeightString()),
    SERVER_GROUP((plugin, player) -> player.getGroup().name()),
    SERVER_GROUP_INDEX((plugin, player) -> Integer.toString(player.getServerGroupPosition((Velocitab)plugin))),
    DEBUG_TEAM_NAME((plugin, player) -> plugin.getFormatter().escape(player.getLastTeamName().orElse(""))),
    LUCKPERMS_META((param, plugin, player) -> plugin.getLuckPermsHook().map(hook -> hook.getMeta(player.getPlayer(), (String)param)).orElse(Placeholder.getPlaceholderFallback(plugin, "%luckperms_meta_" + param + "%")));

    private static final Pattern VELOCITAB_PATTERN;
    private static final Pattern TEST;
    private static final Pattern CONDITION_REPLACER;
    private static final Pattern PLACEHOLDER_PATTERN;
    private static final String DELIMITER = ":::";
    private static final Map<String, String> SYMBOL_SUBSTITUTES;
    private static final Map<String, String> SYMBOL_SUBSTITUTES_2;
    private final TriFunction<String, Velocitab, TabPlayer, String> replacer;
    private final boolean parameterised;
    private final Pattern pattern;

    private Placeholder(BiFunction<Velocitab, TabPlayer, String> replacer) {
        this.parameterised = false;
        this.replacer = (text, player, plugin) -> (String)replacer.apply((Velocitab)player, (TabPlayer)plugin);
        this.pattern = Pattern.compile("%" + this.name().toLowerCase() + "%");
    }

    private Placeholder(TriFunction<String, Velocitab, TabPlayer, String> parameterisedReplacer) {
        this.parameterised = true;
        this.replacer = parameterisedReplacer;
        this.pattern = Pattern.compile("%" + this.name().toLowerCase() + "[^%]*%", 2);
    }

    public static CompletableFuture<Nametag> replace(@NotNull Nametag nametag, @NotNull Velocitab plugin, @NotNull TabPlayer player) {
        return ((CompletableFuture)Placeholder.replace(nametag.prefix() + DELIMITER + nametag.suffix(), plugin, player).thenApply(s -> s.split(DELIMITER, 2))).thenApply(v -> new Nametag(v[0], ((String[])v).length > 1 ? v[1] : ""));
    }

    @NotNull
    private static String getPlaceholderFallback(@NotNull Velocitab plugin, @NotNull String fallback) {
        if (plugin.getPAPIProxyBridgeHook().isPresent() && plugin.getSettings().isFallbackToPapiIfPlaceholderBlank()) {
            return fallback;
        }
        return "";
    }

    @NotNull
    public static String replaceInternal(@NotNull String format, @NotNull Velocitab plugin, @Nullable TabPlayer player) {
        Pair<Boolean, String> result = Placeholder.processRelationalPlaceholders(format, plugin);
        format = (String)result.right();
        format = Placeholder.replacePlaceholders(format, plugin, player);
        return format;
    }

    /*
     * WARNING - void declaration
     */
    private static Pair<Boolean, String> processRelationalPlaceholders(@NotNull String format, @NotNull Velocitab plugin) {
        boolean foundRelational = false;
        if (plugin.getFormatter().equals((Object)Formatter.MINIMESSAGE) && format.contains("<vel")) {
            Matcher conditionReplacer = CONDITION_REPLACER.matcher(format);
            while (conditionReplacer.find()) {
                String search;
                String condition = search = conditionReplacer.group().split(":")[1];
                for (Map.Entry<String, String> entry : MiniConditionManager.REPLACE.entrySet()) {
                    condition = condition.replace(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<String, String> entry : MiniConditionManager.REPLACE_2.entrySet()) {
                    condition = condition.replace(entry.getValue(), entry.getKey());
                }
                format = format.replace(search, condition);
            }
            Matcher testMatcher = TEST.matcher(format);
            while (testMatcher.find()) {
                if (testMatcher.group().startsWith("<velocitab_rel")) {
                    Matcher second = TEST.matcher(testMatcher.group().substring(1));
                    while (second.find()) {
                        Object s = second.group();
                        for (Map.Entry<String, String> entry : SYMBOL_SUBSTITUTES.entrySet()) {
                            s = ((String)s).replace(entry.getKey(), entry.getValue());
                        }
                        format = format.replace(second.group(), (CharSequence)s);
                    }
                    continue;
                }
                String s = testMatcher.group();
                for (Map.Entry<String, String> entry : SYMBOL_SUBSTITUTES.entrySet()) {
                    s = s.replace(entry.getKey(), entry.getValue());
                }
                format = format.replace(testMatcher.group(), s);
            }
            Matcher velocitabRelationalMatcher = VELOCITAB_PATTERN.matcher(format);
            while (velocitabRelationalMatcher.find()) {
                void var7_15;
                String relationalPlaceholder;
                foundRelational = true;
                String string = relationalPlaceholder = velocitabRelationalMatcher.group().substring(1, velocitabRelationalMatcher.group().length() - 1);
                for (Map.Entry<String, String> entry : SYMBOL_SUBSTITUTES_2.entrySet()) {
                    String string2 = var7_15.replace(entry.getKey(), entry.getValue());
                }
                format = format.replace(relationalPlaceholder, (CharSequence)var7_15);
            }
            for (Map.Entry<String, String> entry : SYMBOL_SUBSTITUTES.entrySet()) {
                format = format.replace(entry.getValue(), entry.getKey());
            }
        }
        return Pair.of((Object)foundRelational, (Object)format);
    }

    @NotNull
    private static String replacePlaceholders(@NotNull String format, @NotNull Velocitab plugin, @Nullable TabPlayer player) {
        for (Placeholder placeholder : Placeholder.values()) {
            Matcher matcher = placeholder.pattern.matcher(format);
            format = placeholder.parameterised ? matcher.replaceAll(matchResult -> Matcher.quoteReplacement(placeholder.replacer.apply(StringUtils.chop(matchResult.group().replace("%" + placeholder.name().toLowerCase(), "").replaceFirst("_", "")), plugin, player))) : matcher.replaceAll(matchResult -> Matcher.quoteReplacement(placeholder.replacer.apply(null, plugin, player)));
        }
        return format;
    }

    public static CompletableFuture<String> replace(@NotNull String format, @NotNull Velocitab plugin, @NotNull TabPlayer player) {
        if (format.equals(DELIMITER)) {
            return CompletableFuture.completedFuture("");
        }
        String replaced = Placeholder.replaceInternal(format, plugin, player);
        if (!PLACEHOLDER_PATTERN.matcher(replaced).find()) {
            return CompletableFuture.completedFuture(replaced);
        }
        return plugin.getPAPIProxyBridgeHook().map(hook -> hook.formatPlaceholders(replaced, player.getPlayer()).exceptionally(e -> {
            plugin.log(Level.ERROR, "An error occurred whilst parsing placeholders: " + e.getMessage(), new Throwable[0]);
            return replaced;
        })).orElse(CompletableFuture.completedFuture(replaced)).exceptionally(e -> {
            plugin.log(Level.ERROR, "An error occurred whilst parsing placeholders: " + e.getMessage(), new Throwable[0]);
            return replaced;
        });
    }

    static {
        VELOCITAB_PATTERN = Pattern.compile("<velocitab_.*?>");
        TEST = Pattern.compile("<.*?>");
        CONDITION_REPLACER = Pattern.compile("<velocitab_rel_condition:[^:]*:");
        PLACEHOLDER_PATTERN = Pattern.compile("%.*?%");
        SYMBOL_SUBSTITUTES = Map.of("<", "*LESS*", ">", "*GREATER*");
        SYMBOL_SUBSTITUTES_2 = Map.of("*LESS*", "*LESS2*", "*GREATER*", "*GREATER2*");
    }
}

