/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.commons.jexl3.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.william278.velocitab.libraries.commons.jexl3.JexlArithmetic;
import net.william278.velocitab.libraries.commons.jexl3.JexlContext;
import net.william278.velocitab.libraries.commons.jexl3.JexlEngine;
import net.william278.velocitab.libraries.commons.jexl3.JexlException;
import net.william278.velocitab.libraries.commons.jexl3.JexlOperator;
import net.william278.velocitab.libraries.commons.jexl3.JexlOptions;
import net.william278.velocitab.libraries.commons.jexl3.internal.Debugger;
import net.william278.velocitab.libraries.commons.jexl3.internal.Engine;
import net.william278.velocitab.libraries.commons.jexl3.internal.FqcnResolver;
import net.william278.velocitab.libraries.commons.jexl3.internal.Frame;
import net.william278.velocitab.libraries.commons.jexl3.internal.LexicalFrame;
import net.william278.velocitab.libraries.commons.jexl3.internal.LexicalScope;
import net.william278.velocitab.libraries.commons.jexl3.internal.Operators;
import net.william278.velocitab.libraries.commons.jexl3.internal.Scope;
import net.william278.velocitab.libraries.commons.jexl3.introspection.JexlMethod;
import net.william278.velocitab.libraries.commons.jexl3.introspection.JexlPropertyGet;
import net.william278.velocitab.libraries.commons.jexl3.introspection.JexlPropertySet;
import net.william278.velocitab.libraries.commons.jexl3.introspection.JexlUberspect;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTArrayAccess;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTAssignment;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTFunctionNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTIdentifier;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTIdentifierAccess;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTMethodNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTNullpNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTReference;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTTernaryNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTVar;
import net.william278.velocitab.libraries.commons.jexl3.parser.JexlNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ParserVisitor;
import net.william278.velocitab.libraries.commons.logging.Log;

public abstract class InterpreterBase
extends ParserVisitor {
    protected static final Object[] EMPTY_PARAMS = new Object[0];
    protected final Engine jexl;
    protected final Log logger;
    protected final JexlUberspect uberspect;
    protected final JexlArithmetic arithmetic;
    protected final JexlContext context;
    protected final JexlOptions options;
    protected final boolean cache;
    protected final AtomicBoolean cancelled;
    protected final JexlContext.NamespaceResolver ns;
    protected final JexlContext.ClassNameResolver fqcnSolver;
    protected final Operators operators;
    protected final Map<String, Object> functions;
    protected Map<String, Object> functors;

    protected static String stringifyPropertyValue(JexlNode node) {
        return node != null ? new Debugger().depth(1).data(node) : "???";
    }

    protected InterpreterBase(Engine engine, JexlOptions opts, JexlContext aContext) {
        this.jexl = engine;
        this.logger = this.jexl.logger;
        this.uberspect = this.jexl.uberspect;
        this.context = aContext != null ? aContext : JexlEngine.EMPTY_CONTEXT;
        this.cache = engine.cache != null;
        JexlArithmetic jexla = this.jexl.arithmetic;
        this.options = opts == null ? engine.evalOptions(aContext) : opts;
        this.arithmetic = jexla.options(this.options);
        if (this.arithmetic != jexla && !this.arithmetic.getClass().equals(jexla.getClass()) && this.logger.isWarnEnabled()) {
            this.logger.warn("expected arithmetic to be " + jexla.getClass().getSimpleName() + ", got " + this.arithmetic.getClass().getSimpleName());
        }
        this.ns = this.context instanceof JexlContext.NamespaceResolver ? (JexlContext.NamespaceResolver)((Object)this.context) : JexlEngine.EMPTY_NS;
        AtomicBoolean acancel = null;
        if (this.context instanceof JexlContext.CancellationHandle) {
            acancel = ((JexlContext.CancellationHandle)((Object)this.context)).getCancellation();
        }
        this.cancelled = acancel != null ? acancel : new AtomicBoolean();
        this.functions = this.options.getNamespaces();
        this.functors = null;
        this.operators = new Operators(this);
        Collection<String> imports = this.options.getImports();
        this.fqcnSolver = imports.isEmpty() ? engine.classNameSolver : new FqcnResolver(engine.classNameSolver).importPackages(imports);
    }

    protected InterpreterBase(InterpreterBase ii, JexlArithmetic jexla) {
        this.jexl = ii.jexl;
        this.logger = ii.logger;
        this.uberspect = ii.uberspect;
        this.arithmetic = jexla;
        this.context = ii.context;
        this.options = ii.options.copy();
        this.cache = ii.cache;
        this.ns = ii.ns;
        this.operators = ii.operators;
        this.cancelled = ii.cancelled;
        this.functions = ii.functions;
        this.functors = ii.functors;
        this.fqcnSolver = ii.fqcnSolver;
    }

    protected Object annotationError(JexlNode node, String annotation, Throwable cause) {
        if (this.isStrictEngine()) {
            throw new JexlException.Annotation(node, annotation, cause);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(JexlException.annotationError(node, annotation), cause);
        }
        return null;
    }

    protected Object[] callArguments(Object target, boolean narrow, Object[] args) {
        Object[] nargv = new Object[args.length + 1];
        if (narrow) {
            nargv[0] = this.functionArgument(true, target);
            for (int a = 1; a <= args.length; ++a) {
                nargv[a] = this.functionArgument(true, args[a - 1]);
            }
        } else {
            nargv[0] = target;
            System.arraycopy(args, 0, nargv, 1, args.length);
        }
        return nargv;
    }

    protected boolean cancel() {
        return this.cancelled.compareAndSet(false, true);
    }

    protected void cancelCheck(JexlNode node) {
        if (this.isCancelled()) {
            throw new JexlException.Cancel(node);
        }
    }

    protected void closeIfSupported(Object closeable) {
        JexlMethod mclose;
        if (closeable != null && (mclose = this.uberspect.getMethod(closeable, "close", EMPTY_PARAMS)) != null) {
            try {
                mclose.invoke(closeable, EMPTY_PARAMS);
            }
            catch (Exception xignore) {
                this.logger.warn(xignore);
            }
        }
    }

    protected void closeIfSupported(Queue<Object> closeables) {
        for (Object e : closeables) {
            this.closeIfSupported(e);
        }
    }

    protected Object constVariable(JexlNode node, String var) {
        return this.variableError(node, var, JexlException.VariableIssue.CONST);
    }

    protected boolean defineVariable(ASTVar var, LexicalFrame frame) {
        int symbol = var.getSymbol();
        if (symbol < 0) {
            return false;
        }
        if (var.isRedefined()) {
            return false;
        }
        return frame.defineSymbol(symbol, var.isCaptured());
    }

    protected JexlNode findNullOperand(JexlNode node, Object left, Object right) {
        if (left == null) {
            return node.jjtGetChild(0);
        }
        if (right == null) {
            return node.jjtGetChild(1);
        }
        return node;
    }

    @Deprecated
    protected JexlNode findNullOperand(RuntimeException xrt, JexlNode node, Object left, Object right) {
        return this.findNullOperand(node, left, right);
    }

    protected Object functionArgument(boolean narrow, Object arg) {
        return narrow && arg instanceof Number ? this.arithmetic.narrow((Number)arg) : arg;
    }

    protected Object[] functionArguments(Object target, boolean narrow, Object[] args) {
        if (target == null || target == this.context) {
            if (narrow) {
                this.arithmetic.narrowArguments(args);
            }
            return args;
        }
        Object[] nargv = new Object[args.length + 1];
        if (narrow) {
            nargv[0] = this.functionArgument(true, target);
            for (int a = 1; a <= args.length; ++a) {
                nargv[a] = this.functionArgument(true, args[a - 1]);
            }
        } else {
            nargv[0] = target;
            System.arraycopy(args, 0, nargv, 1, args.length);
        }
        return nargv;
    }

    protected Object getAttribute(Object object, Object attribute, JexlNode node) {
        boolean safe;
        if (object == null) {
            throw new JexlException(node, "object is null");
        }
        this.cancelCheck(node);
        JexlOperator operator = node != null && node.jjtGetParent() instanceof ASTArrayAccess ? JexlOperator.ARRAY_GET : JexlOperator.PROPERTY_GET;
        Object result = this.operators.tryOverload(node, operator, object, attribute);
        if (result != JexlEngine.TRY_FAILED) {
            return result;
        }
        Exception xcause = null;
        try {
            Object value;
            JexlPropertyGet vg;
            Object cached;
            if (node != null && this.cache && (cached = node.jjtGetValue()) instanceof JexlPropertyGet && !(vg = (JexlPropertyGet)cached).tryFailed(value = vg.tryInvoke(object, attribute))) {
                return value;
            }
            List<JexlUberspect.PropertyResolver> resolvers = this.uberspect.getResolvers(operator, object);
            vg = this.uberspect.getPropertyGet(resolvers, object, attribute);
            if (vg != null) {
                value = vg.invoke(object);
                if (node != null && this.cache && vg.isCacheable()) {
                    node.jjtSetValue(vg);
                }
                return value;
            }
        }
        catch (Exception xany) {
            xcause = xany;
        }
        if (node == null) {
            String error = "unable to get object property, class: " + object.getClass().getName() + ", property: " + attribute;
            throw new UnsupportedOperationException(error, xcause);
        }
        boolean bl = safe = node instanceof ASTIdentifierAccess && ((ASTIdentifierAccess)node).isSafe();
        if (safe) {
            return null;
        }
        String attrStr = Objects.toString(attribute, null);
        return this.unsolvableProperty(node, attrStr, true, xcause);
    }

    protected Object getVariable(Frame frame, LexicalScope block, ASTIdentifier identifier) {
        Object value;
        int symbol = identifier.getSymbol();
        String name = identifier.getName();
        if ((this.options.isLexicalShade() || identifier.isLexical()) && identifier.isShaded()) {
            return this.undefinedVariable(identifier, name);
        }
        if (symbol >= 0 && frame.has(symbol) && (value = frame.get(symbol)) != Scope.UNDEFINED) {
            if (value == null && this.isStrictOperand(identifier)) {
                return this.unsolvableVariable(identifier, name, false);
            }
            return value;
        }
        value = this.context.get(name);
        if (value == null) {
            if (!this.context.has(name)) {
                boolean ignore;
                boolean bl = ignore = identifier.jjtGetParent() instanceof ASTReference || this.isSafe() && (symbol >= 0 || identifier.jjtGetParent() instanceof ASTAssignment);
                if (!ignore) {
                    return this.undefinedVariable(identifier, name);
                }
            } else if (this.isStrictOperand(identifier)) {
                return this.unsolvableVariable(identifier, name, false);
            }
        }
        return value;
    }

    protected JexlException invocationException(JexlNode node, String methodName, Throwable xany) {
        Throwable cause = xany.getCause();
        if (cause instanceof JexlException) {
            return (JexlException)cause;
        }
        if (cause instanceof InterruptedException) {
            return new JexlException.Cancel(node);
        }
        return new JexlException(node, methodName, xany);
    }

    protected boolean isCancellable() {
        return this.options.isCancellable();
    }

    protected boolean isCancelled() {
        return this.cancelled.get() | Thread.currentThread().isInterrupted();
    }

    protected boolean isSafe() {
        return this.options.isSafe();
    }

    protected boolean isSilent() {
        return this.options.isSilent();
    }

    protected boolean isStrictEngine() {
        return this.options.isStrict();
    }

    protected boolean isStrictOperand(JexlNode node) {
        return node.jjtGetParent().isStrictOperator(this.arithmetic);
    }

    protected boolean isTernaryProtected(JexlNode startNode) {
        JexlNode node = startNode;
        for (JexlNode walk = node.jjtGetParent(); walk != null; walk = walk.jjtGetParent()) {
            if (walk instanceof ASTTernaryNode || walk instanceof ASTNullpNode) {
                return node == walk.jjtGetChild(0);
            }
            if (!(walk instanceof ASTReference) && !(walk instanceof ASTArrayAccess)) break;
            node = walk;
        }
        return false;
    }

    protected boolean isVariableDefined(Frame frame, LexicalScope block, String name) {
        if (frame != null && block != null) {
            int symbol;
            Integer ref = frame.getScope().getSymbol(name);
            int n = symbol = ref != null ? ref : -1;
            if (symbol >= 0 && block.hasSymbol(symbol)) {
                Object value = frame.get(symbol);
                return value != Scope.UNDEFINED && value != Scope.UNDECLARED;
            }
        }
        return this.context.has(name);
    }

    protected Object operatorError(JexlNode node, JexlOperator operator, Throwable cause) {
        if (this.isStrictEngine()) {
            throw new JexlException.Operator(node, operator.getOperatorSymbol(), cause);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(JexlException.operatorError(node, operator.getOperatorSymbol()), cause);
        }
        return null;
    }

    protected Object redefinedVariable(JexlNode node, String var) {
        return this.variableError(node, var, JexlException.VariableIssue.REDEFINED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object resolveNamespace(String prefix, JexlNode node) {
        Object namespace;
        InterpreterBase interpreterBase = this;
        synchronized (interpreterBase) {
            if (this.functors != null && (namespace = this.functors.get(prefix)) != null) {
                return namespace;
            }
        }
        namespace = this.ns.resolveNamespace(prefix);
        if (namespace == null) {
            namespace = this.functions.get(prefix);
            if (namespace == null) {
                namespace = this.jexl.getNamespace(prefix);
            }
            if (prefix != null && namespace == null) {
                throw new JexlException(node, "no such function namespace " + prefix, null);
            }
        }
        Object functor = null;
        if (namespace instanceof Class || namespace instanceof String) {
            Object eval;
            Object cached;
            ASTIdentifier nsNode = (ASTIdentifier)node.jjtGetChild(0);
            boolean cacheable = this.cache && prefix != null;
            Object object = cached = cacheable ? nsNode.jjtGetValue() : null;
            if (cached instanceof Class) {
                return cached;
            }
            if (cached instanceof JexlContext.NamespaceFunctor && JexlEngine.TRY_FAILED != (eval = ((JexlContext.NamespaceFunctor)cached).createFunctor(this.context))) {
                functor = eval;
                namespace = cached;
            }
            if (functor == null) {
                for (int tried = 0; tried < 2; ++tried) {
                    JexlMethod ctor;
                    boolean withContext = tried == 0;
                    JexlMethod jexlMethod = ctor = withContext ? this.uberspect.getConstructor(namespace, this.context) : this.uberspect.getConstructor(namespace, new Object[0]);
                    if (ctor == null) continue;
                    try {
                        Object object2 = functor = withContext ? ctor.invoke(namespace, this.context) : ctor.invoke(namespace, new Object[0]);
                        if (functor == null) continue;
                        Class<?> ns = namespace;
                        namespace = context -> withContext ? ctor.tryInvoke(null, ns, context) : ctor.tryInvoke(null, ns, new Object[0]);
                        if (!cacheable || !ctor.isCacheable()) break;
                        nsNode.jjtSetValue(namespace);
                        break;
                    }
                    catch (Exception xinst) {
                        throw new JexlException(node, "unable to instantiate namespace " + prefix, (Throwable)xinst);
                    }
                }
                if (functor == null) {
                    try {
                        if (namespace instanceof String) {
                            namespace = this.uberspect.getClassLoader().loadClass((String)namespace);
                        }
                        if (cacheable) {
                            nsNode.jjtSetValue(namespace);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new JexlException(node, "no such class namespace " + prefix, (Throwable)e);
                    }
                }
            }
        }
        if (functor == null && namespace instanceof JexlContext.NamespaceFunctor) {
            functor = ((JexlContext.NamespaceFunctor)namespace).createFunctor(this.context);
        }
        if (functor != null) {
            InterpreterBase interpreterBase2 = this;
            synchronized (interpreterBase2) {
                if (this.functors == null) {
                    this.functors = new HashMap<String, Object>();
                }
                this.functors.put(prefix, functor);
            }
            return functor;
        }
        return namespace;
    }

    protected void setAttribute(Object object, Object attribute, Object value, JexlNode node) {
        this.cancelCheck(node);
        JexlOperator operator = node != null && node.jjtGetParent() instanceof ASTArrayAccess ? JexlOperator.ARRAY_SET : JexlOperator.PROPERTY_SET;
        Object result = this.operators.tryOverload(node, operator, object, attribute, value);
        if (result != JexlEngine.TRY_FAILED) {
            return;
        }
        Exception xcause = null;
        try {
            Object[] narrow;
            Object eval;
            JexlPropertySet setter;
            Object cached;
            if (node != null && this.cache && (cached = node.jjtGetValue()) instanceof JexlPropertySet && !(setter = (JexlPropertySet)cached).tryFailed(eval = setter.tryInvoke(object, attribute, value))) {
                return;
            }
            List<JexlUberspect.PropertyResolver> resolvers = this.uberspect.getResolvers(operator, object);
            JexlPropertySet vs = this.uberspect.getPropertySet(resolvers, object, attribute, value);
            if (vs == null && this.arithmetic.narrowArguments(narrow = new Object[]{value})) {
                vs = this.uberspect.getPropertySet(resolvers, object, attribute, narrow[0]);
            }
            if (vs != null) {
                vs.invoke(object, value);
                if (node != null && this.cache && vs.isCacheable()) {
                    node.jjtSetValue(vs);
                }
                return;
            }
        }
        catch (Exception xany) {
            xcause = xany;
        }
        if (node == null) {
            String error = "unable to set object property, class: " + object.getClass().getName() + ", property: " + attribute + ", argument: " + value.getClass().getSimpleName();
            throw new UnsupportedOperationException(error, xcause);
        }
        String attrStr = Objects.toString(attribute, null);
        this.unsolvableProperty(node, attrStr, true, xcause);
    }

    protected void setContextVariable(JexlNode node, String name, Object value) {
        boolean lexical = this.options.isLexicalShade();
        if (!lexical && node instanceof ASTIdentifier) {
            lexical = ((ASTIdentifier)node).isLexical();
        }
        if (lexical && !this.context.has(name)) {
            throw new JexlException.Variable(node, name, true);
        }
        try {
            this.context.set(name, value);
        }
        catch (UnsupportedOperationException xsupport) {
            throw new JexlException(node, "context is readonly", (Throwable)xsupport);
        }
    }

    protected String stringifyProperty(JexlNode node) {
        if (node instanceof ASTArrayAccess) {
            return "[" + InterpreterBase.stringifyPropertyValue(node.jjtGetChild(0)) + "]";
        }
        if (node instanceof ASTMethodNode) {
            return InterpreterBase.stringifyPropertyValue(node.jjtGetChild(0));
        }
        if (node instanceof ASTFunctionNode) {
            return InterpreterBase.stringifyPropertyValue(node.jjtGetChild(0));
        }
        if (node instanceof ASTIdentifier) {
            return ((ASTIdentifier)node).getName();
        }
        if (node instanceof ASTReference) {
            return this.stringifyProperty(node.jjtGetChild(0));
        }
        return InterpreterBase.stringifyPropertyValue(node);
    }

    protected Object undefinedVariable(JexlNode node, String var) {
        return this.variableError(node, var, JexlException.VariableIssue.UNDEFINED);
    }

    protected Object unsolvableMethod(JexlNode node, String method) {
        return this.unsolvableMethod(node, method, null);
    }

    protected Object unsolvableMethod(JexlNode node, String method, Object[] args) {
        if (this.isStrictEngine()) {
            throw new JexlException.Method(node, method, args);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(JexlException.methodError(node, method, args));
        }
        return null;
    }

    protected Object unsolvableProperty(JexlNode node, String property, boolean undef, Throwable cause) {
        if (this.isStrictEngine() && !this.isTernaryProtected(node)) {
            throw new JexlException.Property(node, property, undef, cause);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(JexlException.propertyError(node, property, undef));
        }
        return null;
    }

    protected Object unsolvableVariable(JexlNode node, String var, boolean undef) {
        return this.variableError(node, var, undef ? JexlException.VariableIssue.UNDEFINED : JexlException.VariableIssue.NULLVALUE);
    }

    protected Object variableError(JexlNode node, String var, JexlException.VariableIssue issue) {
        if (this.isStrictEngine() && !this.isTernaryProtected(node)) {
            throw new JexlException.Variable(node, var, issue);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(JexlException.variableError(node, var, issue));
        }
        return null;
    }

    protected static class Funcall
    implements JexlNode.Funcall {
        protected final boolean narrow;
        protected final JexlMethod me;

        protected Funcall(JexlMethod jme, boolean flag) {
            this.me = jme;
            this.narrow = flag;
        }

        protected Object tryInvoke(InterpreterBase ii, String name, Object target, Object[] args) {
            return this.me.tryInvoke(name, target, ii.functionArguments(null, this.narrow, args));
        }
    }

    protected static class ContextualCtor
    extends Funcall {
        protected ContextualCtor(JexlMethod jme, boolean flag) {
            super(jme, flag);
        }

        @Override
        protected Object tryInvoke(InterpreterBase ii, String name, Object target, Object[] args) {
            return this.me.tryInvoke(name, target, ii.callArguments(ii.context, this.narrow, args));
        }
    }

    protected static class ContextFuncall
    extends Funcall {
        protected ContextFuncall(JexlMethod jme, boolean flag) {
            super(jme, flag);
        }

        @Override
        protected Object tryInvoke(InterpreterBase ii, String name, Object target, Object[] args) {
            return this.me.tryInvoke(name, ii.context, ii.functionArguments(target, this.narrow, args));
        }
    }

    protected class CallDispatcher {
        final JexlNode node;
        final boolean cacheable;
        boolean narrow;
        JexlMethod vm;
        Object target;
        Object[] argv;
        Funcall funcall;

        CallDispatcher(JexlNode anode, boolean acacheable) {
            this.node = anode;
            this.cacheable = acacheable;
        }

        protected Object eval(String methodName) throws Exception {
            if (this.vm != null) {
                Object eval = this.vm.invoke(this.target, this.argv);
                if (this.funcall != null) {
                    this.node.jjtSetValue(this.funcall);
                }
                return eval;
            }
            return InterpreterBase.this.unsolvableMethod(this.node, methodName, this.argv);
        }

        protected boolean isArithmeticMethod(String methodName, Object[] arguments) {
            this.vm = InterpreterBase.this.uberspect.getMethod(InterpreterBase.this.arithmetic, methodName, arguments);
            if (this.vm != null) {
                this.argv = arguments;
                this.target = InterpreterBase.this.arithmetic;
                if (this.cacheable && this.vm.isCacheable()) {
                    this.funcall = new ArithmeticFuncall(this.vm, this.narrow);
                }
                return true;
            }
            return false;
        }

        protected boolean isContextMethod(String methodName, Object[] arguments) {
            this.vm = InterpreterBase.this.uberspect.getMethod(InterpreterBase.this.context, methodName, arguments);
            if (this.vm != null) {
                this.argv = arguments;
                this.target = InterpreterBase.this.context;
                if (this.cacheable && this.vm.isCacheable()) {
                    this.funcall = new ContextFuncall(this.vm, this.narrow);
                }
                return true;
            }
            return false;
        }

        protected boolean isTargetMethod(Object ntarget, String methodName, Object[] arguments) {
            this.vm = InterpreterBase.this.uberspect.getMethod(ntarget, methodName, arguments);
            if (this.vm != null) {
                this.argv = arguments;
                this.target = ntarget;
                if (this.cacheable && this.vm.isCacheable()) {
                    this.funcall = new Funcall(this.vm, this.narrow);
                }
                return true;
            }
            return false;
        }

        protected Object tryEval(Object ntarget, String methodName, Object[] arguments) {
            Object cached;
            if (methodName != null && this.cacheable && ntarget != null && (cached = this.node.jjtGetValue()) instanceof Funcall) {
                return ((Funcall)cached).tryInvoke(InterpreterBase.this, methodName, ntarget, arguments);
            }
            return JexlEngine.TRY_FAILED;
        }
    }

    protected static class ArithmeticFuncall
    extends Funcall {
        protected ArithmeticFuncall(JexlMethod jme, boolean flag) {
            super(jme, flag);
        }

        @Override
        protected Object tryInvoke(InterpreterBase ii, String name, Object target, Object[] args) {
            return this.me.tryInvoke(name, ii.arithmetic, ii.functionArguments(target, this.narrow, args));
        }
    }
}

