/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.commons.jexl3.internal;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.william278.velocitab.libraries.commons.jexl3.JexlCache;

public class SoftCache<K, V>
implements JexlCache<K, V> {
    protected static final float LOAD_FACTOR = 0.75f;
    protected final int capacity;
    protected volatile SoftReference<Map<K, V>> reference;

    public static <K, V> Map<K, V> createSynchronizedLinkedHashMap(final int capacity) {
        return Collections.synchronizedMap(new LinkedHashMap<K, V>(capacity, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return super.size() > capacity;
            }
        });
    }

    public SoftCache(int theSize) {
        this.capacity = theSize;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public void clear() {
        SoftReference<Map<K, V>> ref = this.reference;
        if (ref != null) {
            this.reference = null;
            Map<K, V> map = ref.get();
            if (map != null) {
                map.clear();
            }
        }
    }

    protected <KT, VT> Map<KT, VT> createMap(int cacheSize) {
        return SoftCache.createSynchronizedLinkedHashMap(cacheSize);
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        SoftReference<Map<K, V>> ref = this.reference;
        Map<K, V> map = ref != null ? ref.get() : null;
        return map == null ? Collections.emptyList() : map.entrySet();
    }

    @Override
    public V get(K key) {
        SoftReference<Map<K, V>> ref = this.reference;
        Map<K, V> map = ref != null ? ref.get() : null;
        return map != null ? (V)map.get(key) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V script) {
        Map<Object, Object> map;
        SoftReference<Map<K, V>> ref = this.reference;
        Map<K, V> map2 = map = ref != null ? ref.get() : null;
        if (map == null) {
            SoftCache softCache = this;
            synchronized (softCache) {
                ref = this.reference;
                Map<K, V> map3 = map = ref != null ? ref.get() : null;
                if (map == null) {
                    map = this.createMap(this.capacity);
                    this.reference = new SoftReference<Map<K, V>>(map);
                }
            }
        }
        return map.put(key, script);
    }

    @Override
    public int size() {
        SoftReference<Map<K, V>> ref = this.reference;
        Map<K, V> map = ref != null ? ref.get() : null;
        return map != null ? map.size() : 0;
    }
}

