/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.player;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.velocitypowered.api.proxy.Player;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.config.Placeholder;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.annotations.Nullable;
import net.william278.velocitab.libraries.commons.lang3.ObjectUtils;
import net.william278.velocitab.packet.UpdateTeamsPacket;
import net.william278.velocitab.player.Role;
import net.william278.velocitab.tab.Nametag;
import net.william278.velocitab.tab.PlayerTabList;

public final class TabPlayer
implements Comparable<TabPlayer> {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("%([^%]+)%");
    private static final String PLACEHOLDER_DELIMITER = "<-DELIMITER->";
    private final Velocitab plugin;
    private final Player player;
    private Role role;
    private int headerIndex = 0;
    private int footerIndex = 0;
    private final Map<UUID, Component> relationalDisplayNames;
    private final Map<UUID, Component[]> relationalNametags;
    private final Map<String, String> cachedPlaceholders;
    private String lastDisplayName;
    private Component lastHeader;
    private Component lastFooter;
    private String teamName;
    @Nullable
    private UpdateTeamsPacket.TeamColor teamColor;
    @Nullable
    private String customName;
    @Nullable
    private String lastServer;
    @NotNull
    private Group group;
    private boolean loaded;

    public TabPlayer(@NotNull Velocitab plugin, @NotNull Player player, @NotNull Role role, @NotNull Group group) {
        this.plugin = plugin;
        this.player = player;
        this.role = role;
        this.group = group;
        this.relationalDisplayNames = Maps.newConcurrentMap();
        this.relationalNametags = Maps.newConcurrentMap();
        this.cachedPlaceholders = Maps.newConcurrentMap();
    }

    @NotNull
    public String getRoleWeightString() {
        return this.getRole().getWeightString();
    }

    @NotNull
    public String getServerName() {
        return this.player.getCurrentServer().map(serverConnection -> serverConnection.getServerInfo().getName()).orElse(ObjectUtils.firstNonNull(this.lastServer, "unknown"));
    }

    public int getServerGroupPosition(@NotNull Velocitab plugin) {
        return plugin.getTabGroups().getPosition(this.group);
    }

    @NotNull
    public String getServerDisplayName(@NotNull Velocitab plugin) {
        return plugin.getSettings().getServerDisplayName(this.getServerName());
    }

    @NotNull
    public CompletableFuture<String> getDisplayName(@NotNull Velocitab plugin) {
        String format = this.formatGroup();
        return Placeholder.replace(format, plugin, this).thenApply(d -> this.cacheDisplayName((String)d, format));
    }

    @NotNull
    private String formatGroup() {
        HashSet placeholders = Sets.newHashSet();
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(this.group.format());
        while (matcher.find()) {
            placeholders.add("%" + matcher.group(1) + "%");
        }
        return String.join((CharSequence)PLACEHOLDER_DELIMITER, placeholders);
    }

    @NotNull
    private String cacheDisplayName(@NotNull String placeholders, @NotNull String keys) {
        String displayName = this.group.format();
        String[] placeholderArray = placeholders.split(PLACEHOLDER_DELIMITER);
        String[] keyArray = keys.split(PLACEHOLDER_DELIMITER);
        for (int i = 0; i < placeholderArray.length; ++i) {
            String placeholder = keyArray[i];
            String value = placeholderArray[i];
            this.cachedPlaceholders.put(placeholder, value);
            displayName = displayName.replace(placeholder, value);
        }
        this.lastDisplayName = displayName = Placeholder.replaceInternal(displayName, this.plugin, this);
        return this.lastDisplayName;
    }

    @NotNull
    public CompletableFuture<Nametag> getNametag(@NotNull Velocitab plugin) {
        return Placeholder.replace(this.group.nametag(), plugin, this);
    }

    @NotNull
    public CompletableFuture<String> getTeamName(@NotNull Velocitab plugin) {
        return plugin.getSortingManager().getTeamName(this).thenApply(teamName -> {
            this.teamName = teamName;
            return this.teamName;
        });
    }

    public Optional<String> getLastTeamName() {
        return Optional.ofNullable(this.teamName);
    }

    public CompletableFuture<Void> sendHeaderAndFooter(@NotNull PlayerTabList tabList) {
        return tabList.getHeader(this).thenCompose(header -> tabList.getFooter(this).thenAccept(footer -> {
            boolean disabled = this.plugin.getSettings().isDisableHeaderFooterIfEmpty();
            if (disabled) {
                if (!Component.empty().equals(header) && !header.equals(this.lastHeader) || !Component.empty().equals(footer) && !footer.equals(this.lastFooter)) {
                    this.lastHeader = header;
                    this.lastFooter = footer;
                    this.player.sendPlayerListHeaderAndFooter(header, footer);
                }
            } else if (!header.equals(this.lastHeader) || !footer.equals(this.lastFooter)) {
                this.lastHeader = header;
                this.lastFooter = footer;
                this.player.sendPlayerListHeaderAndFooter(header, footer);
            }
        }));
    }

    public void incrementIndexes() {
        this.incrementHeaderIndex();
        this.incrementFooterIndex();
    }

    public void incrementHeaderIndex() {
        ++this.headerIndex;
        if (this.headerIndex >= this.group.headers().size()) {
            this.headerIndex = 0;
        }
    }

    public void incrementFooterIndex() {
        ++this.footerIndex;
        if (this.footerIndex >= this.group.footers().size()) {
            this.footerIndex = 0;
        }
    }

    public void setRelationalDisplayName(@NotNull UUID target, @NotNull Component displayName) {
        this.relationalDisplayNames.put(target, displayName);
    }

    public void unsetRelationalDisplayName(@NotNull UUID target) {
        this.relationalDisplayNames.remove(target);
    }

    public Optional<Component> getRelationalDisplayName(@NotNull UUID target) {
        return Optional.ofNullable(this.relationalDisplayNames.get(target));
    }

    public void setRelationalNametag(@NotNull UUID target, @NotNull Component prefix, @NotNull Component suffix) {
        this.relationalNametags.put(target, new Component[]{prefix, suffix});
    }

    public void unsetRelationalNametag(@NotNull UUID target) {
        this.relationalNametags.remove(target);
    }

    public Optional<Component[]> getRelationalNametag(@NotNull UUID target) {
        return Optional.ofNullable(this.relationalNametags.get(target));
    }

    public void clearCachedData() {
        this.loaded = false;
        this.relationalDisplayNames.clear();
        this.relationalNametags.clear();
        this.lastHeader = null;
        this.lastFooter = null;
        this.role = Role.DEFAULT_ROLE;
    }

    public Optional<String> getCustomName() {
        return Optional.ofNullable(this.customName);
    }

    @Override
    public int compareTo(@NotNull TabPlayer o) {
        int roleDifference = this.role.compareTo(o.role);
        if (roleDifference == 0) {
            return this.player.getUsername().compareTo(o.player.getUsername());
        }
        return roleDifference;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TabPlayer)) return false;
        TabPlayer other = (TabPlayer)obj;
        if (!this.player.getUniqueId().equals(other.player.getUniqueId())) return false;
        return true;
    }

    public Optional<String> getCachedPlaceholderValue(@NotNull String placeholder) {
        return Optional.ofNullable(this.cachedPlaceholders.get(placeholder));
    }

    @Generated
    public Velocitab getPlugin() {
        return this.plugin;
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public Role getRole() {
        return this.role;
    }

    @Generated
    public int getHeaderIndex() {
        return this.headerIndex;
    }

    @Generated
    public int getFooterIndex() {
        return this.footerIndex;
    }

    @Generated
    public Map<UUID, Component> getRelationalDisplayNames() {
        return this.relationalDisplayNames;
    }

    @Generated
    public Map<UUID, Component[]> getRelationalNametags() {
        return this.relationalNametags;
    }

    @Generated
    public Map<String, String> getCachedPlaceholders() {
        return this.cachedPlaceholders;
    }

    @Generated
    public String getLastDisplayName() {
        return this.lastDisplayName;
    }

    @Generated
    public Component getLastHeader() {
        return this.lastHeader;
    }

    @Generated
    public Component getLastFooter() {
        return this.lastFooter;
    }

    @Generated
    public String getTeamName() {
        return this.teamName;
    }

    @Nullable
    @Generated
    public UpdateTeamsPacket.TeamColor getTeamColor() {
        return this.teamColor;
    }

    @Nullable
    @Generated
    public String getLastServer() {
        return this.lastServer;
    }

    @NotNull
    @Generated
    public Group getGroup() {
        return this.group;
    }

    @Generated
    public boolean isLoaded() {
        return this.loaded;
    }

    @Generated
    public String toString() {
        return "TabPlayer(plugin=" + this.getPlugin() + ", player=" + this.getPlayer() + ", role=" + this.getRole() + ", headerIndex=" + this.getHeaderIndex() + ", footerIndex=" + this.getFooterIndex() + ", relationalDisplayNames=" + this.getRelationalDisplayNames() + ", relationalNametags=" + this.getRelationalNametags() + ", cachedPlaceholders=" + this.getCachedPlaceholders() + ", lastDisplayName=" + this.getLastDisplayName() + ", lastHeader=" + this.getLastHeader() + ", lastFooter=" + this.getLastFooter() + ", teamName=" + this.getTeamName() + ", teamColor=" + this.getTeamColor() + ", customName=" + this.getCustomName() + ", lastServer=" + this.getLastServer() + ", group=" + this.getGroup() + ", loaded=" + this.isLoaded() + ")";
    }

    @Generated
    public void setRole(Role role) {
        this.role = role;
    }

    @Generated
    public void setTeamColor(@Nullable UpdateTeamsPacket.TeamColor teamColor) {
        this.teamColor = teamColor;
    }

    @Generated
    public void setCustomName(@Nullable String customName) {
        this.customName = customName;
    }

    @Generated
    public void setLastServer(@Nullable String lastServer) {
        this.lastServer = lastServer;
    }

    @Generated
    public void setGroup(@NotNull Group group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        this.group = group;
    }

    @Generated
    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }
}

