/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.desertwell.about.AboutMenu;
import net.william278.velocitab.player.TabPlayer;

public final class VelocitabCommand {
    private static final TextColor MAIN_COLOR = TextColor.color((int)64410);
    private static final TextColor ERROR_COLOR = TextColor.color((int)16744030);
    private final AboutMenu aboutMenu;
    private final Velocitab plugin;

    public VelocitabCommand(@NotNull Velocitab plugin) {
        this.plugin = plugin;
        this.aboutMenu = AboutMenu.builder().title((Component)Component.text((String)"Velocitab")).description((Component)Component.text((String)((String)plugin.getDescription().getDescription().orElseThrow()))).version(plugin.getVersion()).credits("Authors", AboutMenu.Credit.of("William278").description("Click to visit website").url("https://william278.net"), AboutMenu.Credit.of("AlexDev03").description("Click to visit GitHub").url("https://github.com/alexdev03")).credits("Contributors", AboutMenu.Credit.of("Ironboundred").description("Code"), AboutMenu.Credit.of("Emibergo02").description("Code"), AboutMenu.Credit.of("FreeMonoid").description("Code"), AboutMenu.Credit.of("4drian3d").description("Code")).buttons(AboutMenu.Link.of("https://william278.net/docs/velocitab").text("Docs").icon("\u26cf"), AboutMenu.Link.of("https://discord.gg/tVYhJfyDWG").text("Discord").icon("\u2b50").color(TextColor.color((int)6779893)), AboutMenu.Link.of("https://modrinth.com/plugin/velocitab").text("Modrinth").icon("\u25ce").color(TextColor.color((int)5804355))).build();
    }

    @NotNull
    public BrigadierCommand command() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"velocitab").executes(ctx -> {
            this.sendAboutInfo((CommandSource)ctx.getSource());
            return 1;
        })).then(LiteralArgumentBuilder.literal((String)"about").executes(ctx -> {
            this.sendAboutInfo((CommandSource)ctx.getSource());
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"name").requires(src -> this.hasPermission((CommandSource)src, "name"))).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).requires(src -> src instanceof Player)).executes(ctx -> {
            Player player = (Player)ctx.getSource();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            Optional<TabPlayer> tabPlayer = this.plugin.getTabList().getTabPlayer(player);
            if (tabPlayer.isEmpty()) {
                ((CommandSource)ctx.getSource()).sendMessage((Component)Component.text((String)"You can't update your TAB name from an untracked server!", (TextColor)ERROR_COLOR));
                return 1;
            }
            tabPlayer.get().setCustomName(name);
            this.plugin.getTabList().updatePlayerDisplayName(tabPlayer.get());
            ((CommandSource)ctx.getSource()).sendMessage((Component)Component.text((String)"Your TAB name has been updated!", (TextColor)MAIN_COLOR));
            return 1;
        }))).requires(src -> src instanceof Player)).executes(ctx -> {
            Player player = (Player)ctx.getSource();
            Optional<TabPlayer> tabPlayer = this.plugin.getTabList().getTabPlayer(player);
            if (tabPlayer.isEmpty()) {
                ((CommandSource)ctx.getSource()).sendMessage((Component)Component.text((String)"You can't reset your TAB name from an untracked server!", (TextColor)ERROR_COLOR));
                return 1;
            }
            String customName = tabPlayer.get().getCustomName().orElse("");
            if (customName.isEmpty() || customName.equals(player.getUsername())) {
                ((CommandSource)ctx.getSource()).sendMessage((Component)Component.text((String)"You aren't using a custom name in TAB!", (TextColor)ERROR_COLOR));
                return 1;
            }
            tabPlayer.get().setCustomName(null);
            this.plugin.getTabList().updatePlayerDisplayName(tabPlayer.get());
            player.sendMessage((Component)Component.text((String)"Your name has been reset!", (TextColor)MAIN_COLOR));
            return 1;
        }))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"reload").requires(src -> this.hasPermission((CommandSource)src, "reload"))).executes(ctx -> {
            this.plugin.loadConfigs();
            this.plugin.getTabList().reloadUpdate();
            ((CommandSource)ctx.getSource()).sendMessage((Component)Component.text((String)"Velocitab has been reloaded!", (TextColor)MAIN_COLOR));
            return 1;
        }))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"update").requires(src -> this.hasPermission((CommandSource)src, "update"))).executes(ctx -> {
            this.plugin.getUpdateChecker().check().thenAccept(checked -> {
                if (checked.isUpToDate()) {
                    ((CommandSource)ctx.getSource()).sendMessage((Component)Component.text((String)"Velocitab is up to date! (Running v%s)".formatted(this.plugin.getVersion()), (TextColor)MAIN_COLOR));
                    return;
                }
                ((CommandSource)ctx.getSource()).sendMessage((Component)Component.text((String)"An update for Velocitab is available. Please update to %s".formatted(checked.getLatestVersion()), (TextColor)MAIN_COLOR));
            });
            return 1;
        }));
        return new BrigadierCommand(builder);
    }

    private boolean hasPermission(@NotNull CommandSource source, @NotNull String command) {
        return source.hasPermission(String.join((CharSequence)".", "velocitab", "command", command));
    }

    private void sendAboutInfo(@NotNull CommandSource source) {
        source.sendMessage((Component)this.aboutMenu.toComponent());
    }
}

