/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.config;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.ConfigValidator;
import net.william278.velocitab.config.Formatter;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.config.ServerUrl;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.configlib.Comment;
import net.william278.velocitab.libraries.configlib.Configuration;

@Configuration
public class Settings
implements ConfigValidator {
    public static final String CONFIG_HEADER = "\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503       Velocitab Config       \u2503\n\u2503    Developed by William278   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information: https://william278.net/project/velocitab\n\u2517\u2578 Documentation: https://william278.net/docs/velocitab";
    @Comment(value={"Check for updates on startup"})
    private boolean checkForUpdates = true;
    @Comment(value={"Whether to remove nametag from players' heads if the nametag associated with their server group is empty."})
    private boolean removeNametags = false;
    @Comment(value={"Whether to disable header and footer if they are empty and let backend servers handle them."})
    private boolean disableHeaderFooterIfEmpty = true;
    @Comment(value={"Which text formatter to use (MINIMESSAGE, MINEDOWN or LEGACY)"})
    private Formatter formatter = Formatter.MINIMESSAGE;
    @Comment(value={"All servers which are not in other groups will be put in the fallback group.\n\"false\" will exclude them from Velocitab."})
    private boolean fallbackEnabled = true;
    @Comment(value={"The formats to use for the fallback group."})
    private String fallbackGroup = "default";
    @Comment(value={"Whether to show all players from all groups in the TAB list."})
    private boolean showAllPlayersFromAllGroups = false;
    @Comment(value={"Define custom names to be shown in the TAB list for specific server names.\nIf no custom display name is provided for a server, its original name will be used."})
    private Map<String, String> serverDisplayNames = Map.of("very-long-server-name", "VLSN");
    @Comment(value={"Whether to enable the PAPIProxyBridge hook for PAPI support"})
    private boolean enablePapiHook = true;
    @Comment(value={"How long in seconds to cache PAPI placeholders for, in milliseconds. (0 to disable)"})
    private long papiCacheTime = 30000L;
    @Comment(value={"If you are using MINIMESSAGE formatting, enable this to support MiniPlaceholders in formatting."})
    private boolean enableMiniPlaceholdersHook = true;
    @Comment(value={"Whether to send scoreboard teams packets. Required for player list sorting and nametag formatting.\nTurn this off if you're using scoreboard teams on backend servers."})
    private boolean sendScoreboardPackets = true;
    @Comment(value={"If built-in placeholders return a blank string, fallback to Placeholder API equivalents.\nFor example, if %prefix% returns a blank string, use %luckperms_prefix%. Requires PAPIProxyBridge."})
    private boolean fallbackToPapiIfPlaceholderBlank = false;
    @Comment(value={"Whether to sort players in the TAB list."})
    private boolean sortPlayers = true;
    @Comment(value={"Remove gamemode spectator effect for other players in the TAB list."})
    private boolean removeSpectatorEffect = true;
    @Comment(value={"Whether to enable the Plugin Message API (allows backend plugins to perform certain operations)"})
    private boolean enablePluginMessageApi = true;
    @Comment(value={"Whether to force sending tab list packets to all players, even if a packet for that action has already been sent. This could fix issues with some mods."})
    private boolean forceSendingTabListPackets = false;
    @Comment(value={"A list of links that will be sent to display on player pause menus (Minecraft 1.21+ clients only).", "\u2022 Labels can be fully custom or built-in (one of 'bug_report', 'community_guidelines', 'support', 'status',", "  'feedback', 'community', 'website', 'forums', 'news', or 'announcements').", "\u2022 If you supply a url with a 'bug_report' label, it will be shown if the player is disconnected.", "\u2022 Specify a set of server groups each URL should be sent on. Use '*' to show a URL to all groups."})
    private List<ServerUrl> serverLinks = List.of(new ServerUrl("<#00fb9a>About Velocitab</#00fb9a>", "https://william278.net/project/velocitab"));

    @NotNull
    public String getServerDisplayName(@NotNull String serverName) {
        return this.serverDisplayNames.getOrDefault(serverName, serverName);
    }

    @NotNull
    public List<ServerUrl> getUrlsForGroup(@NotNull Group group) {
        return this.serverLinks.stream().filter(link -> link.groups().contains("*") || link.groups().contains(group.name())).toList();
    }

    @Override
    public void validateConfig(@NotNull Velocitab plugin) {
        if (this.papiCacheTime < 0L) {
            throw new IllegalStateException("PAPI cache time must be greater than or equal to 0");
        }
        this.serverLinks.forEach(ServerUrl::validate);
    }

    @Generated
    public boolean isCheckForUpdates() {
        return this.checkForUpdates;
    }

    @Generated
    public boolean isRemoveNametags() {
        return this.removeNametags;
    }

    @Generated
    public boolean isDisableHeaderFooterIfEmpty() {
        return this.disableHeaderFooterIfEmpty;
    }

    @Generated
    public Formatter getFormatter() {
        return this.formatter;
    }

    @Generated
    public boolean isFallbackEnabled() {
        return this.fallbackEnabled;
    }

    @Generated
    public String getFallbackGroup() {
        return this.fallbackGroup;
    }

    @Generated
    public boolean isShowAllPlayersFromAllGroups() {
        return this.showAllPlayersFromAllGroups;
    }

    @Generated
    public Map<String, String> getServerDisplayNames() {
        return this.serverDisplayNames;
    }

    @Generated
    public boolean isEnablePapiHook() {
        return this.enablePapiHook;
    }

    @Generated
    public long getPapiCacheTime() {
        return this.papiCacheTime;
    }

    @Generated
    public boolean isEnableMiniPlaceholdersHook() {
        return this.enableMiniPlaceholdersHook;
    }

    @Generated
    public boolean isSendScoreboardPackets() {
        return this.sendScoreboardPackets;
    }

    @Generated
    public boolean isFallbackToPapiIfPlaceholderBlank() {
        return this.fallbackToPapiIfPlaceholderBlank;
    }

    @Generated
    public boolean isSortPlayers() {
        return this.sortPlayers;
    }

    @Generated
    public boolean isRemoveSpectatorEffect() {
        return this.removeSpectatorEffect;
    }

    @Generated
    public boolean isEnablePluginMessageApi() {
        return this.enablePluginMessageApi;
    }

    @Generated
    public boolean isForceSendingTabListPackets() {
        return this.forceSendingTabListPackets;
    }

    @Generated
    public List<ServerUrl> getServerLinks() {
        return this.serverLinks;
    }

    @Generated
    private Settings() {
    }
}

