/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.commons.jexl3.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.william278.velocitab.libraries.commons.jexl3.JexlArithmetic;
import net.william278.velocitab.libraries.commons.jexl3.internal.introspection.ClassMisc;

public class ArrayBuilder
implements JexlArithmetic.ArrayBuilder {
    private static final int PRIMITIVE_SIZE = 8;
    private static final Map<Class<?>, Class<?>> BOXING_CLASSES = new IdentityHashMap(8);
    protected Class<?> commonClass;
    protected boolean isNumber = true;
    protected boolean unboxing = true;
    protected final Object[] untyped;
    protected int added;
    protected final boolean extended;

    protected static Class<?> unboxingClass(Class<?> parm) {
        return BOXING_CLASSES.getOrDefault(parm, parm);
    }

    public ArrayBuilder(int size) {
        this(size, false);
    }

    public ArrayBuilder(int size, boolean extended) {
        this.untyped = new Object[size];
        this.extended = extended;
    }

    @Override
    public void add(Object value) {
        if (!Object.class.equals(this.commonClass)) {
            if (value == null) {
                this.isNumber = false;
                this.unboxing = false;
            } else {
                Class<?> eclass = value.getClass();
                if (this.commonClass == null) {
                    this.commonClass = eclass;
                    this.isNumber = this.isNumber && Number.class.isAssignableFrom(this.commonClass);
                } else if (!this.commonClass.isAssignableFrom(eclass)) {
                    if (this.isNumber && Number.class.isAssignableFrom(eclass)) {
                        this.commonClass = Number.class;
                    } else {
                        this.isNumber = false;
                        this.commonClass = this.getCommonSuperClass(this.commonClass, eclass);
                    }
                }
            }
        }
        if (this.added >= this.untyped.length) {
            throw new IllegalArgumentException("add() over size");
        }
        this.untyped[this.added++] = value;
    }

    @Override
    public Object create(boolean e) {
        if (this.untyped == null) {
            return new Object[0];
        }
        int size = this.added;
        if (this.extended || e) {
            List<?> list = this.newList(this.commonClass, size);
            list.addAll(Arrays.asList(this.untyped).subList(0, size));
            return list;
        }
        if (this.commonClass == null || Object.class.equals(this.commonClass)) {
            return this.untyped.clone();
        }
        if (this.unboxing) {
            this.commonClass = ArrayBuilder.unboxingClass(this.commonClass);
        }
        Object typed = Array.newInstance(this.commonClass, size);
        for (int i = 0; i < size; ++i) {
            Array.set(typed, i, this.untyped[i]);
        }
        return typed;
    }

    protected Class<?> getCommonSuperClass(Class<?> baseClass, Class<?> other) {
        return ClassMisc.getCommonSuperClass(baseClass, other);
    }

    protected <T> List<T> newList(Class<? extends T> clazz, int size) {
        return new ArrayList(size);
    }

    static {
        BOXING_CLASSES.put(Boolean.class, Boolean.TYPE);
        BOXING_CLASSES.put(Byte.class, Byte.TYPE);
        BOXING_CLASSES.put(Character.class, Character.TYPE);
        BOXING_CLASSES.put(Double.class, Double.TYPE);
        BOXING_CLASSES.put(Float.class, Float.TYPE);
        BOXING_CLASSES.put(Integer.class, Integer.TYPE);
        BOXING_CLASSES.put(Long.class, Long.TYPE);
        BOXING_CLASSES.put(Short.class, Short.TYPE);
    }
}

