/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.config;

import java.util.function.Function;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.annotations.Nullable;
import net.william278.velocitab.libraries.minedown.adventure.MineDown;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.util.QuadFunction;
import net.william278.velocitab.util.SerializationUtil;

public enum Formatter {
    MINEDOWN((text, player, viewer, plugin) -> new MineDown((String)text).toComponent(), MineDown::escape, "MineDown", text -> new MineDown((String)text).toComponent(), text -> {
        throw new UnsupportedOperationException("MineDown does not support serialization");
    }),
    MINIMESSAGE((text, player, viewer, plugin) -> plugin.getMiniPlaceholdersHook().filter(hook -> player != null).map(hook -> hook.format((String)text, (Audience)player.getPlayer(), (Audience)(viewer == null ? null : viewer.getPlayer()))).orElse(MiniMessage.miniMessage().deserialize(text)), text -> MiniMessage.miniMessage().escapeTags(text), "MiniMessage", text -> MiniMessage.miniMessage().deserialize(text), arg_0 -> ((MiniMessage)MiniMessage.miniMessage()).serialize(arg_0)),
    LEGACY((text, player, viewer, plugin) -> SerializationUtil.LEGACY_SERIALIZER.deserialize(text), Function.identity(), "Legacy Text", arg_0 -> ((LegacyComponentSerializer)SerializationUtil.LEGACY_SERIALIZER).deserialize(arg_0), arg_0 -> ((LegacyComponentSerializer)SerializationUtil.LEGACY_SERIALIZER).serialize(arg_0));

    private final String name;
    private final QuadFunction<String, TabPlayer, TabPlayer, Velocitab, Component> formatter;
    private final Function<String, String> escaper;
    private final Function<String, Component> emptyFormatter;
    private final Function<Component, String> serializer;

    private Formatter(@NotNull QuadFunction<String, TabPlayer, TabPlayer, Velocitab, Component> formatter, @NotNull Function<String, String> escaper, @NotNull String name, Function<String, Component> emptyFormatter, Function<Component, String> serializer) {
        this.formatter = formatter;
        this.escaper = escaper;
        this.name = name;
        this.emptyFormatter = emptyFormatter;
        this.serializer = serializer;
    }

    @NotNull
    public Component format(@NotNull String text, @NotNull TabPlayer player, @Nullable TabPlayer tabPlayer, @NotNull Velocitab plugin) {
        return this.formatter.apply(text, player, tabPlayer, plugin);
    }

    @NotNull
    public Component format(@NotNull String text, @NotNull TabPlayer player, @NotNull Velocitab plugin) {
        return this.formatter.apply(text, player, null, plugin);
    }

    @NotNull
    public String formatLegacySymbols(@NotNull String text, @NotNull TabPlayer player, @NotNull Velocitab plugin) {
        return LegacyComponentSerializer.legacySection().serialize(this.format(text, player, plugin));
    }

    @NotNull
    public Component deserialize(@NotNull String text) {
        return this.emptyFormatter.apply(text);
    }

    @NotNull
    public String escape(@NotNull String text) {
        return this.escaper.apply(text);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String serialize(@NotNull Component component) {
        return this.serializer.apply(component);
    }
}

