/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.packet;

import com.velocitypowered.api.event.AwaitingEventExecutor;
import com.velocitypowered.api.event.EventHandler;
import com.velocitypowered.api.event.EventTask;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultChannelPipeline;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.packet.PlayerChannelHandler;

public class PacketEventManager {
    private static final String KEY = "velocitab";
    private final Velocitab plugin;

    public PacketEventManager(@NotNull Velocitab plugin) {
        this.plugin = plugin;
        this.loadPlayers();
        this.loadListeners();
    }

    private void loadPlayers() {
        this.plugin.getServer().getAllPlayers().forEach(this::injectPlayer);
    }

    private void loadListeners() {
        this.plugin.getServer().getEventManager().register((Object)this.plugin, PostLoginEvent.class, (EventHandler)((AwaitingEventExecutor)postLoginEvent -> EventTask.withContinuation(continuation -> {
            this.injectPlayer(postLoginEvent.getPlayer());
            continuation.resume();
        })));
        this.plugin.getServer().getEventManager().register((Object)this.plugin, DisconnectEvent.class, (EventHandler)((AwaitingEventExecutor)disconnectEvent -> disconnectEvent.getLoginStatus() == DisconnectEvent.LoginStatus.CONFLICTING_LOGIN ? null : EventTask.async(() -> this.removePlayer(disconnectEvent.getPlayer()))));
    }

    public void injectPlayer(@NotNull Player player) {
        PlayerChannelHandler handler = new PlayerChannelHandler(this.plugin, player);
        ConnectedPlayer connectedPlayer = (ConnectedPlayer)player;
        this.removePlayer(player);
        connectedPlayer.getConnection().getChannel().pipeline().addBefore("handler", KEY, (ChannelHandler)handler);
    }

    public void removePlayer(@NotNull Player player) {
        ConnectedPlayer connectedPlayer = (ConnectedPlayer)player;
        Channel channel = connectedPlayer.getConnection().getChannel();
        ChannelHandler handler = channel.pipeline().get(KEY);
        if (handler == null) {
            return;
        }
        ChannelPipeline channelPipeline = channel.pipeline();
        if (channelPipeline instanceof DefaultChannelPipeline) {
            DefaultChannelPipeline defaultChannelPipeline = (DefaultChannelPipeline)channelPipeline;
            defaultChannelPipeline.removeIfExists(KEY);
            return;
        }
        this.plugin.getLogger().warn("Failed to remove player {} from Velocitab packet handler {}", (Object)player.getUsername(), (Object)channel.pipeline().getClass().getName());
    }
}

