/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.tab;

import com.google.common.collect.Maps;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.player.TabList;
import com.velocitypowered.api.proxy.player.TabListEntry;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.packet.UpsertPlayerInfoPacket;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.api.PlayerAddedToTabEvent;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.config.Placeholder;
import net.william278.velocitab.config.ServerUrl;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.annotations.Nullable;
import net.william278.velocitab.packet.ScoreboardManager;
import net.william278.velocitab.player.Role;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.tab.TabListListener;
import net.william278.velocitab.tab.TaskManager;
import net.william278.velocitab.tab.VanishTabList;
import org.slf4j.event.Level;

public class PlayerTabList {
    private final Velocitab plugin;
    private final VanishTabList vanishTabList;
    private final Map<UUID, TabPlayer> players;
    private final TaskManager taskManager;

    public PlayerTabList(@NotNull Velocitab plugin) {
        this.plugin = plugin;
        this.vanishTabList = new VanishTabList(plugin, this);
        this.players = Maps.newConcurrentMap();
        this.taskManager = new TaskManager(plugin);
        this.reloadUpdate();
        this.registerListener();
        this.ensureDisplayNameTask();
    }

    private void registerListener() {
        this.plugin.getServer().getEventManager().register((Object)this.plugin, (Object)new TabListListener(this.plugin, this));
    }

    public Optional<TabPlayer> getTabPlayer(@NotNull Player player) {
        return Optional.ofNullable(this.players.get(player.getUniqueId()));
    }

    public Optional<TabPlayer> getTabPlayer(@NotNull UUID uuid) {
        return Optional.ofNullable(this.players.get(uuid));
    }

    public void load() {
        this.plugin.getServer().getAllPlayers().forEach(p -> {
            Optional server = p.getCurrentServer();
            if (server.isEmpty()) {
                return;
            }
            String serverName = ((ServerConnection)server.get()).getServerInfo().getName();
            @NotNull Optional<Group> group = this.getGroup(serverName);
            if (group.isEmpty()) {
                return;
            }
            this.joinPlayer((Player)p, group.get());
        });
    }

    public void close() {
        this.taskManager.cancelAllTasks();
        this.plugin.getServer().getAllPlayers().forEach(p -> {
            Optional server = p.getCurrentServer();
            if (server.isEmpty()) {
                return;
            }
            TabPlayer tabPlayer = this.players.get(p.getUniqueId());
            if (tabPlayer == null) {
                return;
            }
            Set<RegisteredServer> serversInGroup = tabPlayer.getGroup().registeredServers(this.plugin);
            if (serversInGroup.isEmpty()) {
                return;
            }
            serversInGroup.remove(((ServerConnection)server.get()).getServer());
            serversInGroup.forEach(s -> s.getPlayersConnected().forEach(t -> t.getTabList().removeEntry(p.getUniqueId())));
        });
    }

    protected void clearCachedData(@NotNull Player player) {
        this.players.values().forEach(p -> {
            p.unsetRelationalDisplayName(player.getUniqueId());
            p.unsetRelationalNametag(player.getUniqueId());
            p.unsetTabListOrder(player.getUniqueId());
        });
    }

    protected void joinPlayer(@NotNull Player joined, @NotNull Group group) {
        Optional<TabPlayer> tabPlayerOptional = this.getTabPlayer(joined);
        if (tabPlayerOptional.isPresent()) {
            tabPlayerOptional.get().clearCachedData();
            tabPlayerOptional.get().setGroup(group);
            tabPlayerOptional.get().setRole(this.plugin.getLuckPermsHook().map(hook -> hook.getPlayerRole(joined)).orElse(Role.DEFAULT_ROLE));
        }
        TabPlayer tabPlayer = tabPlayerOptional.orElseGet(() -> this.createTabPlayer(joined, group));
        String serverName = this.getServerName(joined);
        tabPlayer.setLastServer(serverName);
        this.sendPlayerServerLinks(tabPlayer);
        ((CompletableFuture)tabPlayer.getDisplayName(this.plugin).thenAccept(d -> {
            if (d == null) {
                this.plugin.log(Level.ERROR, "Failed to get display name for " + joined.getUsername(), new Throwable[0]);
                return;
            }
            this.handleDisplayLoad(tabPlayer);
        })).exceptionally(throwable -> {
            this.plugin.log(Level.ERROR, String.format("Failed to set display name for %s (UUID: %s)", joined.getUsername(), joined.getUniqueId()), (Throwable)throwable);
            return null;
        });
    }

    private void handleDisplayLoad(@NotNull TabPlayer tabPlayer) {
        Player joined = tabPlayer.getPlayer();
        Group group = tabPlayer.getGroup();
        boolean isVanished = this.plugin.getVanishManager().isVanished(joined.getUsername());
        this.players.putIfAbsent(joined.getUniqueId(), tabPlayer);
        ((CompletableFuture)tabPlayer.sendHeaderAndFooter(this).thenAccept(v -> tabPlayer.setLoaded(true))).exceptionally(throwable -> {
            this.plugin.log(Level.ERROR, String.format("Failed to send header and footer for %s (UUID: %s)", joined.getUsername(), joined.getUniqueId()), (Throwable)throwable);
            return null;
        });
        Set<TabPlayer> tabPlayers = group.getTabPlayers(this.plugin, tabPlayer);
        this.updateTabListOnJoin(tabPlayer, group, tabPlayers, isVanished);
    }

    private void updateTabListOnJoin(@NotNull TabPlayer tabPlayer, @NotNull Group group, @NotNull Set<TabPlayer> tabPlayers, boolean isJoinedVanished) {
        Player joined = tabPlayer.getPlayer();
        String serverName = this.getServerName(joined);
        Set uuids = tabPlayers.stream().map(p -> p.getPlayer().getUniqueId()).collect(Collectors.toSet());
        List.copyOf(tabPlayer.getPlayer().getTabList().getEntries()).forEach(entry -> {
            if (!uuids.contains(entry.getProfile().getId())) {
                tabPlayer.getPlayer().getTabList().removeEntry(entry.getProfile().getId());
            }
        });
        for (TabPlayer iteratedPlayer : tabPlayers) {
            Player player = iteratedPlayer.getPlayer();
            String username = player.getUsername();
            boolean isPlayerVanished = this.plugin.getVanishManager().isVanished(username);
            if (group.onlyListPlayersInSameServer() && !serverName.equals(this.getServerName(player))) continue;
            this.checkVisibilityAndUpdateName(iteratedPlayer, tabPlayer, isJoinedVanished);
            if (iteratedPlayer != tabPlayer) {
                this.checkVisibilityAndUpdateName(tabPlayer, iteratedPlayer, isPlayerVanished);
            }
            iteratedPlayer.sendHeaderAndFooter(this);
        }
        ScoreboardManager scoreboardManager = this.plugin.getScoreboardManager();
        scoreboardManager.resendAllTeams(tabPlayer);
        this.updateSorting(tabPlayer, false);
        this.fixDuplicateEntries(joined);
        this.plugin.getServer().getEventManager().fireAndForget((Object)new PlayerAddedToTabEvent(tabPlayer, group));
    }

    private void checkVisibilityAndUpdateName(@NotNull TabPlayer observedPlayer, @NotNull TabPlayer observableTabPlayer, boolean isObservablePlayerVanished) {
        UUID observableUUID = observableTabPlayer.getPlayer().getUniqueId();
        String observedUsername = observedPlayer.getPlayer().getUsername();
        String observableUsername = observableTabPlayer.getPlayer().getUsername();
        TabList observableTabPlayerTabList = observableTabPlayer.getPlayer().getTabList();
        if (isObservablePlayerVanished && !this.plugin.getVanishManager().canSee(observableUsername, observedUsername) && !observableUUID.equals(observedPlayer.getPlayer().getUniqueId())) {
            observableTabPlayerTabList.removeEntry(observedPlayer.getPlayer().getUniqueId());
        } else {
            this.updateDisplayName(observedPlayer, observableTabPlayer);
        }
    }

    @NotNull
    private String getServerName(@NotNull Player player) {
        return player.getCurrentServer().map(serverConnection -> serverConnection.getServerInfo().getName()).orElse("");
    }

    @NotNull
    public Component getRelationalPlaceholder(@NotNull TabPlayer player, @NotNull TabPlayer viewer, @NotNull Component single, @NotNull String toParse) {
        if (this.plugin.getMiniPlaceholdersHook().isEmpty()) {
            return single;
        }
        return this.plugin.getFormatter().format(toParse, player, viewer, this.plugin);
    }

    @NotNull
    public Component getRelationalPlaceholder(@NotNull TabPlayer player, @NotNull TabPlayer viewer, @NotNull String toParse) {
        Component single = this.plugin.getFormatter().format(toParse, player, viewer, this.plugin);
        return this.getRelationalPlaceholder(player, viewer, single, toParse);
    }

    private void fixDuplicateEntries(@NotNull Player target) {
        try {
            Field entriesField = target.getTabList().getClass().getDeclaredField("entries");
            entriesField.setAccessible(true);
            Map entries = (Map)entriesField.get(target.getTabList());
            entries.entrySet().stream().filter(entry -> ((TabListEntry)entry.getValue()).getProfile() != null).filter(entry -> ((TabListEntry)entry.getValue()).getProfile().getId().equals(target.getUniqueId())).filter(entry -> !((UUID)entry.getKey()).equals(target.getUniqueId())).forEach(entry -> target.getTabList().removeEntry((UUID)entry.getKey()));
        }
        catch (Throwable error) {
            this.plugin.log(Level.ERROR, "Failed to fix duplicate entries for class " + target.getTabList().getClass().getName(), error);
        }
    }

    protected void removePlayer(@NotNull Player target) {
        this.removePlayer(target, null);
    }

    protected void removeTabListUUID(@NotNull UUID uuid) {
        this.getPlayers().forEach((key, value) -> value.getPlayer().getTabList().getEntry(uuid).ifPresent(entry -> value.getPlayer().getTabList().removeEntry(uuid)));
    }

    protected void removePlayer(@NotNull Player target, @Nullable RegisteredServer server) {
        UUID uuid = target.getUniqueId();
        this.plugin.getServer().getAllPlayers().forEach(player -> player.getTabList().removeEntry(uuid));
        Set currentServerPlayers = Optional.ofNullable(server).map(RegisteredServer::getPlayersConnected).map(HashSet::new).orElseGet(HashSet::new);
        currentServerPlayers.add(target);
        this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> this.getPlayers().values().stream().filter(p -> currentServerPlayers.isEmpty() || !currentServerPlayers.contains(p.getPlayer())).forEach(player -> {
            player.getPlayer().getTabList().removeEntry(uuid);
            player.sendHeaderAndFooter(this);
            this.updatePlayerDisplayName((TabPlayer)player);
        })).delay(250L, TimeUnit.MILLISECONDS).schedule();
        this.plugin.getScoreboardManager().resetCache(target);
        this.getPlayers().remove(uuid);
    }

    @NotNull
    protected TabListEntry createEntry(@NotNull TabPlayer player, @NotNull TabList tabList, @NotNull Component displayName) {
        return TabListEntry.builder().profile(player.getPlayer().getGameProfile()).displayName(displayName).latency(Math.max((int)player.getPlayer().getPing(), 0)).tabList(tabList).build();
    }

    @NotNull
    protected TabListEntry createEntry(@NotNull TabPlayer player, @NotNull TabList tabList, @NotNull TabPlayer viewer) {
        if (!viewer.getPlayer().getTabList().equals(tabList)) {
            throw new IllegalArgumentException("TabList of viewer is not the same as the TabList of the entry");
        }
        Component single = this.plugin.getFormatter().format(player.getLastDisplayName(), player, viewer, this.plugin);
        Component displayName = this.getRelationalPlaceholder(player, viewer, single, player.getGroup().format());
        player.setRelationalDisplayName(viewer.getPlayer().getUniqueId(), displayName);
        return TabListEntry.builder().profile(player.getPlayer().getGameProfile()).displayName(displayName).latency(Math.max((int)player.getPlayer().getPing(), 0)).tabList(tabList).build();
    }

    protected void updateDisplayName(@NotNull TabPlayer player, @NotNull TabPlayer viewer) {
        Component displayName = this.getRelationalPlaceholder(player, viewer, player.getLastDisplayName());
        this.updateDisplayName(player, viewer, displayName);
    }

    protected void updateDisplayName(@NotNull TabPlayer player, @NotNull TabPlayer viewer, @NotNull Component displayName) {
        Optional<Component> cached = player.getRelationalDisplayName(viewer.getPlayer().getUniqueId());
        if (cached.isPresent() && cached.get().equals(displayName)) {
            if (viewer.getPlayer().getTabList().getEntry(player.getPlayer().getUniqueId()).flatMap(TabListEntry::getDisplayNameComponent).map(displayName::equals).orElse(false).booleanValue()) {
                return;
            }
        }
        player.setRelationalDisplayName(viewer.getPlayer().getUniqueId(), displayName);
        viewer.getPlayer().getTabList().getEntry(player.getPlayer().getUniqueId()).ifPresentOrElse(entry -> entry.setDisplayName(displayName), () -> viewer.getPlayer().getTabList().addEntry(this.createEntry(player, viewer.getPlayer().getTabList(), displayName)));
    }

    @NotNull
    public TabPlayer createTabPlayer(@NotNull Player player, @NotNull Group group) {
        return new TabPlayer(this.plugin, player, this.plugin.getLuckPermsHook().map(hook -> hook.getPlayerRole(player)).orElse(Role.DEFAULT_ROLE), group);
    }

    public void updatePlayer(@NotNull TabPlayer tabPlayer, boolean force) {
        if (!tabPlayer.getPlayer().isActive()) {
            this.removeOfflinePlayer(tabPlayer.getPlayer());
            return;
        }
        this.updateSorting(tabPlayer, force);
    }

    private void updateSorting(@NotNull TabPlayer tabPlayer, boolean force) {
        tabPlayer.getTeamName(this.plugin).thenAccept(teamName -> {
            if (teamName.isBlank()) {
                return;
            }
            this.plugin.getScoreboardManager().updateRole(tabPlayer, (String)teamName, force).thenAccept(v -> {
                int order = this.plugin.getScoreboardManager().getPosition((String)teamName);
                if (order == -1) {
                    this.plugin.log(Level.ERROR, "Failed to get position for " + tabPlayer.getPlayer().getUsername(), new Throwable[0]);
                    return;
                }
                tabPlayer.setListOrder(order);
                Set<TabPlayer> players = tabPlayer.getGroup().getTabPlayers(this.plugin, tabPlayer);
                players.forEach(p -> this.recalculateSortingForPlayer((TabPlayer)p, players));
            });
        });
    }

    public void sendPlayerServerLinks(@NotNull TabPlayer player) {
        if (player.getPlayer().getProtocolVersion().lessThan((Object)ProtocolVersion.MINECRAFT_1_21)) {
            return;
        }
        List<ServerUrl> urls = this.plugin.getSettings().getUrlsForGroup(player.getGroup());
        ServerUrl.resolve(this.plugin, player, urls).thenAccept(arg_0 -> ((Player)player.getPlayer()).setServerLinks(arg_0));
    }

    public void updatePlayerDisplayName(@NotNull TabPlayer tabPlayer) {
        tabPlayer.getDisplayName(this.plugin).thenAccept(displayName -> {
            if (displayName == null) {
                this.plugin.log(Level.ERROR, "Failed to get display name for " + tabPlayer.getPlayer().getUsername(), new Throwable[0]);
                return;
            }
            Component single = this.plugin.getFormatter().format((String)displayName, tabPlayer, this.plugin);
            boolean isVanished = this.plugin.getVanishManager().isVanished(tabPlayer.getPlayer().getUsername());
            Set<TabPlayer> players = tabPlayer.getGroup().getTabPlayers(this.plugin, tabPlayer);
            players.forEach(player -> {
                if (isVanished && !this.plugin.getVanishManager().canSee(player.getPlayer().getUsername(), tabPlayer.getPlayer().getUsername())) {
                    return;
                }
                Component relationalPlaceholder = this.getRelationalPlaceholder(tabPlayer, (TabPlayer)player, single, (String)displayName);
                this.updateDisplayName(tabPlayer, (TabPlayer)player, relationalPlaceholder);
            });
        });
    }

    public void checkCorrectDisplayName(@NotNull TabPlayer tabPlayer) {
        if (!tabPlayer.isLoaded()) {
            return;
        }
        boolean bypass = this.plugin.getSettings().isForceSendingTabListPackets();
        this.players.values().stream().filter(TabPlayer::isLoaded).forEach(player -> player.getPlayer().getTabList().getEntry(tabPlayer.getPlayer().getUniqueId()).ifPresent(entry -> {
            Optional<Component> displayNameOptional = tabPlayer.getRelationalDisplayName(player.getPlayer().getUniqueId());
            if (displayNameOptional.isEmpty()) {
                return;
            }
            Component lastDisplayName = displayNameOptional.get();
            if (bypass || entry.getDisplayNameComponent().isEmpty() || !lastDisplayName.equals(entry.getDisplayNameComponent().get())) {
                entry.setDisplayName(lastDisplayName);
            }
        }));
    }

    public void updateDisplayNames() {
        this.players.values().forEach(this::updatePlayerDisplayName);
    }

    public void checkCorrectDisplayNames() {
        this.players.values().forEach(this::checkCorrectDisplayName);
    }

    public void ensureDisplayNameTask() {
        this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, this::checkCorrectDisplayNames).delay(1L, TimeUnit.SECONDS).repeat(2L, TimeUnit.SECONDS).schedule();
    }

    public CompletableFuture<Component> getHeader(@NotNull TabPlayer player) {
        String header = player.getGroup().getHeader(player.getHeaderIndex());
        return Placeholder.replace(header, this.plugin, player).thenApply(replaced -> this.plugin.getFormatter().format((String)replaced, player, this.plugin));
    }

    public CompletableFuture<Component> getFooter(@NotNull TabPlayer player) {
        String footer = player.getGroup().getFooter(player.getFooterIndex());
        return Placeholder.replace(footer, this.plugin, player).thenApply(replaced -> this.plugin.getFormatter().format((String)replaced, player, this.plugin));
    }

    public void reloadUpdate() {
        this.taskManager.cancelAllTasks();
        this.plugin.getTabGroups().getGroups().forEach(this.taskManager::updatePeriodically);
        if (this.players.isEmpty()) {
            return;
        }
        this.players.values().forEach(player -> {
            Optional server = player.getPlayer().getCurrentServer();
            if (server.isEmpty()) {
                return;
            }
            String serverName = ((ServerConnection)server.get()).getServerInfo().getName();
            Optional<Group> group = this.getGroup(serverName);
            if (group.isEmpty()) {
                return;
            }
            player.setGroup(group.get());
            this.sendPlayerServerLinks((TabPlayer)player);
            this.updatePlayer((TabPlayer)player, true);
            player.sendHeaderAndFooter(this);
        });
        this.updateDisplayNames();
    }

    @NotNull
    public Optional<Group> getGroup(@NotNull String serverName) {
        return this.plugin.getTabGroups().getGroupFromServer(serverName, this.plugin);
    }

    public void removeOldEntry(@NotNull Group group, @NotNull UUID uuid) {
        Set<TabPlayer> players = group.getTabPlayers(this.plugin);
        players.forEach(player -> player.getPlayer().getTabList().removeEntry(uuid));
    }

    public void removeOfflinePlayer(@NotNull Player player) {
        this.players.remove(player.getUniqueId());
    }

    private boolean hasListOrder(@NotNull TabPlayer tabPlayer) {
        return tabPlayer.getPlayer().getProtocolVersion().noLessThan((Object)ProtocolVersion.MINECRAFT_1_21_2);
    }

    private void updateSorting(@NotNull TabPlayer tabPlayer, @NotNull UUID uuid, int position) {
        if (!tabPlayer.getPlayer().getTabList().containsEntry(uuid)) {
            return;
        }
        if (tabPlayer.getCachedListOrders().containsKey(uuid) && tabPlayer.getCachedListOrders().get(uuid) == position) {
            return;
        }
        tabPlayer.getCachedListOrders().put(uuid, position);
        UpsertPlayerInfoPacket packet = new UpsertPlayerInfoPacket(UpsertPlayerInfoPacket.Action.UPDATE_LIST_ORDER);
        UpsertPlayerInfoPacket.Entry entry = new UpsertPlayerInfoPacket.Entry(uuid);
        entry.setListOrder(position);
        packet.addEntry(entry);
        ((ConnectedPlayer)tabPlayer.getPlayer()).getConnection().write((Object)packet);
    }

    private String getPlayerName(UUID uuid) {
        return this.plugin.getServer().getPlayer(uuid).map(Player::getUsername).orElse("Unknown");
    }

    public synchronized void recalculateSortingForPlayer(@NotNull TabPlayer tabPlayer, @NotNull Set<TabPlayer> players) {
        if (!this.hasListOrder(tabPlayer)) {
            return;
        }
        players.forEach(p -> {
            int order = p.getListOrder();
            this.updateSorting(tabPlayer, p.getPlayer().getUniqueId(), order);
        });
    }

    @Generated
    public VanishTabList getVanishTabList() {
        return this.vanishTabList;
    }

    @Generated
    public Map<UUID, TabPlayer> getPlayers() {
        return this.players;
    }
}

