/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.api;

import com.velocitypowered.api.proxy.Player;
import java.util.List;
import java.util.Optional;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.libraries.annotations.ApiStatus;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.annotations.Nullable;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.tab.PlayerTabList;
import net.william278.velocitab.vanish.VanishIntegration;

public class VelocitabAPI {
    private final Velocitab plugin;
    private static VelocitabAPI instance;

    @ApiStatus.Internal
    protected VelocitabAPI(@NotNull Velocitab plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public static VelocitabAPI getInstance() {
        if (instance == null) {
            throw new NotRegisteredException();
        }
        return instance;
    }

    @ApiStatus.Internal
    public static void register(@NotNull Velocitab plugin) {
        instance = new VelocitabAPI(plugin);
    }

    @ApiStatus.Internal
    public static void unregister() {
        instance = null;
    }

    public Optional<TabPlayer> getUser(@NotNull Player player) {
        return this.plugin.getTabList().getTabPlayer(player);
    }

    public void setCustomPlayerName(@NotNull Player player, @Nullable String name) {
        this.getUser(player).ifPresent(tabPlayer -> {
            tabPlayer.setCustomName(name);
            this.plugin.getTabList().updatePlayerDisplayName((TabPlayer)tabPlayer);
        });
    }

    public Optional<String> getCustomPlayerName(@NotNull Player player) {
        return this.getUser(player).flatMap(TabPlayer::getCustomName);
    }

    @NotNull
    public PlayerTabList getTabList() {
        return this.plugin.getTabList();
    }

    public void setVanishIntegration(@NotNull VanishIntegration vanishIntegration) {
        this.plugin.getVanishManager().setIntegration(vanishIntegration);
    }

    @NotNull
    public VanishIntegration getVanishIntegration() {
        return this.plugin.getVanishManager().getIntegration();
    }

    public void vanishPlayer(@NotNull Player player) {
        this.plugin.getVanishManager().vanishPlayer(player);
    }

    public void unVanishPlayer(@NotNull Player player) {
        this.plugin.getVanishManager().unVanishPlayer(player);
    }

    @Nullable
    public Group getServerGroup(@NotNull Player player) {
        return this.getUser(player).map(TabPlayer::getGroup).orElse(null);
    }

    @NotNull
    public List<Group> getServerGroups() {
        return this.plugin.getTabGroups().getGroups();
    }

    @NotNull
    public Optional<Group> getGroup(@NotNull String name) {
        return this.plugin.getTabGroups().getGroup(name);
    }

    public Optional<Group> getGroupFromServer(@NotNull String server) {
        return this.plugin.getTabGroups().getGroupFromServer(server, this.plugin);
    }

    static final class NotRegisteredException
    extends IllegalStateException {
        private static final String MESSAGE = "Could not access the Velocitab API as it has not yet been registered. This could be because:\n1) Velocitab has failed to enable successfully\n2) You are attempting to access Velocitab on plugin construction/before your plugin has enabled.\n3) You have shaded Velocitab into your plugin jar and need to fix your maven/gradle/build script\n   to only include Velocitab as a dependency and not as a shaded dependency.";

        NotRegisteredException() {
            super(MESSAGE);
        }
    }
}

