/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.configlib;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.william278.velocitab.libraries.configlib.Configuration;
import net.william278.velocitab.libraries.configlib.Ignore;
import net.william278.velocitab.libraries.configlib.Validator;

final class Reflect {
    private static final Map<Class<?>, Object> DEFAULT_VALUES = Reflect.initDefaultValues();

    private Reflect() {
    }

    private static Map<Class<?>, Object> initDefaultValues() {
        return Stream.of(Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE).collect(Collectors.toMap(type -> type, type -> Array.get(Array.newInstance(type, 1), 0)));
    }

    static <T> T getDefaultValue(Class<T> clazz) {
        Object defaultValue = DEFAULT_VALUES.get(clazz);
        return (T)defaultValue;
    }

    static <T> T callConstructor(Class<T> cls, Class<?>[] argumentTypes, Object ... arguments) {
        try {
            Constructor<T> constructor = cls.getDeclaredConstructor(argumentTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(arguments);
        }
        catch (NoSuchMethodException e) {
            String msg = "Type '%s' doesn't have a constructor with parameters: %s.".formatted(cls.getSimpleName(), Reflect.argumentTypeNamesJoined(argumentTypes));
            throw new RuntimeException(msg, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            String msg = "Type '%s' is not instantiable.".formatted(cls.getSimpleName());
            throw new RuntimeException(msg, e);
        }
        catch (InvocationTargetException e) {
            String msg = "Constructor of type '%s' with parameters '%s' threw an exception.".formatted(cls.getSimpleName(), Reflect.argumentTypeNamesJoined(argumentTypes));
            throw new RuntimeException(msg, e);
        }
    }

    private static String argumentTypeNamesJoined(Class<?>[] argumentTypes) {
        return Arrays.stream(argumentTypes).map(Class::getName).collect(Collectors.joining(", "));
    }

    static boolean hasConstructor(Class<?> type, Class<?> ... argumentTypes) {
        Predicate<Constructor> predicate = ctor -> Arrays.equals(ctor.getParameterTypes(), argumentTypes);
        return Arrays.stream(type.getDeclaredConstructors()).anyMatch(predicate);
    }

    static <T> T callNoParamConstructor(Class<T> cls) {
        try {
            Constructor<T> constructor = cls.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            String msg = "Type '%s' doesn't have a no-args constructor.".formatted(cls.getSimpleName());
            throw new RuntimeException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "No-args constructor of type '%s' not accessible.".formatted(cls.getSimpleName());
            throw new RuntimeException(msg, e);
        }
        catch (InstantiationException e) {
            String msg = "Type '%s' is not instantiable.".formatted(cls.getSimpleName());
            throw new RuntimeException(msg, e);
        }
        catch (InvocationTargetException e) {
            String msg = "No-args constructor of type '%s' threw an exception.".formatted(cls.getSimpleName());
            throw new RuntimeException(msg, e);
        }
    }

    static <R> R callCanonicalConstructor(Class<R> recordType, Object ... constructorArguments) {
        try {
            Constructor<R> constructor = Reflect.getCanonicalConstructor(Validator.requireRecord(recordType));
            constructor.setAccessible(true);
            return constructor.newInstance(constructorArguments);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            String msg = "The canonical constructor of record type '%s' threw an exception.".formatted(recordType.getSimpleName());
            throw new RuntimeException(msg, e);
        }
    }

    static <R> R callCanonicalConstructorWithDefaultValues(Class<R> recordType) {
        Object[] args = Arrays.stream(Reflect.recordParameterTypes(Validator.requireRecord(recordType))).map(Reflect::getDefaultValue).toArray(Object[]::new);
        return Reflect.callCanonicalConstructor(recordType, args);
    }

    static <R> Constructor<R> getCanonicalConstructor(Class<R> recordType) throws NoSuchMethodException {
        Class<?>[] parameterTypes = Reflect.recordParameterTypes(Validator.requireRecord(recordType));
        return recordType.getDeclaredConstructor(parameterTypes);
    }

    private static <R> Class<?>[] recordParameterTypes(Class<R> recordType) {
        return (Class[])Arrays.stream(recordType.getRecordComponents()).map(RecordComponent::getType).toArray(Class[]::new);
    }

    static <T> T[] newArray(Class<T> componentType, int length) {
        Object[] array = (Object[])Array.newInstance(componentType, length);
        return array;
    }

    static boolean hasDefaultConstructor(Class<?> type) {
        return Arrays.stream(type.getDeclaredConstructors()).anyMatch(ctor -> ctor.getParameterCount() == 0);
    }

    static Object getValue(Field field, Object instance) {
        try {
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (IllegalAccessException e) {
            String msg = "Illegal access of field '%s' on object %s.".formatted(field, instance);
            throw new RuntimeException(msg, e);
        }
    }

    static Object getValue(RecordComponent component, Object recordInstance) {
        Method accessor = component.getAccessor();
        try {
            accessor.setAccessible(true);
            return accessor.invoke(recordInstance, new Object[0]);
        }
        catch (IllegalAccessException e) {
            String msg = "Illegal access of method '%s' on record '%s'.".formatted(accessor, recordInstance);
            throw new RuntimeException(msg, e);
        }
        catch (InvocationTargetException e) {
            String msg = "Invocation of method '%s' on record '%s' failed.".formatted(accessor, recordInstance);
            throw new RuntimeException(msg, e);
        }
    }

    static void setValue(Field field, Object instance, Object value) {
        try {
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            String msg = "Illegal access of field '%s' on object %s.".formatted(field, instance);
            throw new RuntimeException(msg, e);
        }
    }

    static boolean isIntegerType(Class<?> cls) {
        return cls == Byte.TYPE || cls == Byte.class || cls == Short.TYPE || cls == Short.class || cls == Integer.TYPE || cls == Integer.class || cls == Long.TYPE || cls == Long.class;
    }

    static boolean isFloatingPointType(Class<?> cls) {
        return cls == Float.TYPE || cls == Float.class || cls == Double.TYPE || cls == Double.class;
    }

    static boolean isEnumType(Class<?> cls) {
        return cls.isEnum();
    }

    static boolean isArrayType(Class<?> cls) {
        return cls.isArray();
    }

    static boolean isListType(Class<?> cls) {
        return List.class.isAssignableFrom(cls);
    }

    static boolean isSetType(Class<?> cls) {
        return Set.class.isAssignableFrom(cls);
    }

    static boolean isMapType(Class<?> cls) {
        return Map.class.isAssignableFrom(cls);
    }

    static boolean isConfigurationClass(Class<?> cls) {
        return cls.getAnnotation(Configuration.class) != null;
    }

    static boolean isConfigurationType(Class<?> type) {
        return type.isRecord() || type.getAnnotation(Configuration.class) != null;
    }

    static boolean isIgnored(Field field) {
        return field.getAnnotation(Ignore.class) != null;
    }

    static Class<?> getClassByName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static Object invoke(Method method, Object object, Object ... arguments) {
        try {
            method.setAccessible(true);
            return method.invoke(object, arguments);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

