/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.sorting;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import net.william278.velocitab.libraries.annotations.NotNull;

public class SortedSet {
    private final ConcurrentSkipListSet<String> sortedTeams;
    private final Map<String, Integer> positionMap;

    public SortedSet(@NotNull Comparator<String> comparator) {
        this.sortedTeams = new ConcurrentSkipListSet<String>(comparator);
        this.positionMap = Maps.newConcurrentMap();
    }

    public synchronized boolean addTeam(@NotNull String teamName) {
        boolean result = this.sortedTeams.add(teamName);
        if (!result) {
            return false;
        }
        this.updatePositions();
        return true;
    }

    public synchronized boolean removeTeam(@NotNull String teamName) {
        boolean result = this.sortedTeams.remove(teamName);
        if (!result) {
            return false;
        }
        this.updatePositions();
        return true;
    }

    private synchronized void updatePositions() {
        int index = 0;
        this.positionMap.clear();
        for (String team : this.sortedTeams) {
            this.positionMap.put(team, index);
            ++index;
        }
    }

    public synchronized int getPosition(@NotNull String teamName) {
        return this.positionMap.getOrDefault(teamName, -1);
    }

    public String toString() {
        return this.sortedTeams.toString();
    }
}

