/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.tab;

import com.google.common.collect.Sets;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.player.KickedFromServerEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.event.proxy.ProxyReloadEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.ServerInfo;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.tab.PlayerTabList;

public class TabListListener {
    private final Velocitab plugin;
    private final PlayerTabList tabList;
    private final Set<UUID> justQuit;

    public TabListListener(@NotNull Velocitab plugin, @NotNull PlayerTabList tabList) {
        this.plugin = plugin;
        this.tabList = tabList;
        this.justQuit = Sets.newConcurrentHashSet();
    }

    @Subscribe
    public void onKick(@NotNull KickedFromServerEvent event) {
        event.getPlayer().getTabList().getEntries().stream().filter(entry -> entry.getProfile() != null && !entry.getProfile().getId().equals(event.getPlayer().getUniqueId())).forEach(entry -> event.getPlayer().getTabList().removeEntry(entry.getProfile().getId()));
        event.getPlayer().getTabList().clearHeaderAndFooter();
        if (event.getResult() instanceof KickedFromServerEvent.DisconnectPlayer) {
            this.tabList.removePlayer(event.getPlayer());
        } else {
            KickedFromServerEvent.ServerKickResult serverKickResult = event.getResult();
            if (serverKickResult instanceof KickedFromServerEvent.RedirectPlayer) {
                KickedFromServerEvent.RedirectPlayer redirectPlayer = (KickedFromServerEvent.RedirectPlayer)serverKickResult;
                this.tabList.removePlayer(event.getPlayer(), redirectPlayer.getServer());
            } else {
                serverKickResult = event.getResult();
                if (serverKickResult instanceof KickedFromServerEvent.Notify) {
                    KickedFromServerEvent.Notify notify = (KickedFromServerEvent.Notify)serverKickResult;
                    return;
                }
            }
        }
        event.getPlayer().getTabList().removeEntry(event.getPlayer().getUniqueId());
        event.getPlayer().getTabList().clearHeaderAndFooter();
        this.justQuit.add(event.getPlayer().getUniqueId());
        this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> this.justQuit.remove(event.getPlayer().getUniqueId())).delay(300L, TimeUnit.MILLISECONDS).schedule();
    }

    @Subscribe
    public void onPlayerJoin(@NotNull ServerPostConnectEvent event) {
        Player joined = event.getPlayer();
        String serverName = joined.getCurrentServer().map(ServerConnection::getServerInfo).map(ServerInfo::getName).orElse("");
        Optional<Group> previousGroup = this.tabList.getTabPlayer(joined).map(TabPlayer::getGroup);
        @NotNull Optional<Group> groupOptional = this.tabList.getGroup(serverName);
        boolean isDefault = groupOptional.map(g -> g.isDefault(this.plugin)).orElse(true);
        this.plugin.getTabList().clearCachedData(joined);
        if (!this.plugin.getSettings().isShowAllPlayersFromAllGroups() && previousGroup.isPresent() && (groupOptional.isPresent() && !previousGroup.get().equals(groupOptional.get()) || groupOptional.isEmpty())) {
            this.tabList.removeOldEntry(previousGroup.get(), joined.getUniqueId());
        }
        if (isDefault && !this.plugin.getSettings().isFallbackEnabled() && !groupOptional.map(g -> g.containsServer(this.plugin, serverName)).orElse(false).booleanValue()) {
            Optional<TabPlayer> tabPlayer = this.tabList.getTabPlayer(joined);
            if (tabPlayer.isEmpty()) {
                return;
            }
            if (event.getPreviousServer() == null) {
                return;
            }
            Component header = tabPlayer.get().getLastHeader();
            Component footer = tabPlayer.get().getLastFooter();
            this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> {
                Component currentHeader = joined.getPlayerListHeader();
                Component currentFooter = joined.getPlayerListFooter();
                if (header.equals(currentHeader) && footer.equals(currentFooter) || currentHeader.equals(Component.empty()) && currentFooter.equals(Component.empty())) {
                    joined.sendPlayerListHeaderAndFooter((Component)Component.empty(), (Component)Component.empty());
                    joined.getCurrentServer().ifPresent(serverConnection -> serverConnection.getServer().getPlayersConnected().forEach(player -> player.getTabList().getEntry(joined.getUniqueId()).ifPresent(entry -> entry.setDisplayName((Component)Component.text((String)joined.getUsername())))));
                }
            }).delay(500L, TimeUnit.MILLISECONDS).schedule();
            this.tabList.getPlayers().remove(event.getPlayer().getUniqueId());
            return;
        }
        if (groupOptional.isEmpty()) {
            return;
        }
        Group group = groupOptional.get();
        this.plugin.getScoreboardManager().resetCache(joined, group);
        if (this.justQuit.contains(joined.getUniqueId())) {
            this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> this.tabList.joinPlayer(joined, group)).delay(250L, TimeUnit.MILLISECONDS).schedule();
            return;
        }
        this.tabList.joinPlayer(joined, group);
    }

    @Subscribe(order=PostOrder.CUSTOM, priority=-32768)
    public void onPlayerQuit(@NotNull DisconnectEvent event) {
        if (event.getLoginStatus() != DisconnectEvent.LoginStatus.SUCCESSFUL_LOGIN) {
            this.checkDelayedDisconnect(event);
            return;
        }
        this.tabList.removePlayer(event.getPlayer());
    }

    private void checkDelayedDisconnect(@NotNull DisconnectEvent event) {
        Player player = event.getPlayer();
        this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> {
            Optional actualPlayer = this.plugin.getServer().getPlayer(player.getUniqueId());
            if (actualPlayer.isPresent() && !((Player)actualPlayer.get()).equals(player)) {
                return;
            }
            if (player.getCurrentServer().isPresent()) {
                return;
            }
            this.tabList.removeTabListUUID(event.getPlayer().getUniqueId());
        }).delay(750L, TimeUnit.MILLISECONDS).schedule();
    }

    @Subscribe
    public void proxyReload(@NotNull ProxyReloadEvent event) {
        this.plugin.loadConfigs();
        this.tabList.reloadUpdate();
        this.plugin.log("Velocitab has been reloaded!");
    }
}

