/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.hook;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import net.william278.papiproxybridge.api.PlaceholderAPI;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.hook.Hook;
import net.william278.velocitab.libraries.annotations.NotNull;

public class PAPIProxyBridgeHook
extends Hook {
    private final PlaceholderAPI api = PlaceholderAPI.createInstance();

    public PAPIProxyBridgeHook(@NotNull Velocitab plugin) {
        super(plugin);
        this.api.setCacheExpiry(Math.max(0L, plugin.getSettings().getPapiCacheTime()));
        this.api.setRequestTimeout(1500L);
    }

    public CompletableFuture<String> formatPlaceholders(@NotNull String input, @NotNull Player player) {
        return this.api.formatPlaceholders(input, player.getUniqueId());
    }

    public CompletableFuture<Map<String, String>> parsePlaceholders(@NotNull List<String> input, @NotNull Player player) {
        ConcurrentMap map = Maps.newConcurrentMap();
        ArrayList futures = Lists.newArrayList();
        for (String s : input) {
            CompletableFuture<String> future = this.formatPlaceholders(s, player);
            futures.add(future);
            future.thenAccept(r -> map.put(s, r));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).thenApply(v -> map);
    }
}

