/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.tab;

import com.google.common.collect.Maps;
import com.velocitypowered.api.scheduler.ScheduledTask;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.tab.GroupTasks;

public class TaskManager {
    private final Velocitab plugin;
    private final Map<Group, GroupTasks> groupTasks;

    public TaskManager(@NotNull Velocitab plugin) {
        this.plugin = plugin;
        this.groupTasks = Maps.newConcurrentMap();
    }

    protected void cancelAllTasks() {
        this.groupTasks.values().forEach(GroupTasks::cancel);
        this.groupTasks.clear();
    }

    protected void updatePeriodically(@NotNull Group group) {
        ScheduledTask headerFooterTask = null;
        ScheduledTask updateTask = null;
        if (group.headerFooterUpdateRate() > 0) {
            headerFooterTask = this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> this.updateGroupPlayers(group, false, true)).delay(1L, TimeUnit.SECONDS).repeat((long)Math.max(200, group.headerFooterUpdateRate()), TimeUnit.MILLISECONDS).schedule();
        }
        if (group.placeholderUpdateRate() > 0) {
            updateTask = this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> this.updateGroupPlayers(group, true, false)).delay(1L, TimeUnit.SECONDS).repeat((long)Math.max(200, group.placeholderUpdateRate()), TimeUnit.MILLISECONDS).schedule();
        }
        ScheduledTask latencyTask = this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> this.updateLatency(group)).delay(1L, TimeUnit.SECONDS).repeat(3L, TimeUnit.SECONDS).schedule();
        this.groupTasks.put(group, new GroupTasks(headerFooterTask, updateTask, latencyTask));
    }

    private void updateGroupPlayers(@NotNull Group group, boolean all, boolean incrementIndexes) {
        Set<TabPlayer> groupPlayers = group.getTabPlayers(this.plugin);
        if (groupPlayers.isEmpty()) {
            return;
        }
        groupPlayers.stream().filter(player -> player.getPlayer().isActive()).forEach(player -> {
            if (incrementIndexes) {
                player.incrementIndexes();
            }
            if (all) {
                this.plugin.getTabList().updatePlayer((TabPlayer)player, false);
            }
            player.sendHeaderAndFooter(this.plugin.getTabList());
        });
        if (all) {
            this.plugin.getTabList().updateDisplayNames();
        }
    }

    private void updateLatency(@NotNull Group group) {
        Set<TabPlayer> groupPlayers = group.getTabPlayers(this.plugin);
        if (groupPlayers.isEmpty()) {
            return;
        }
        groupPlayers.stream().filter(player -> player.getPlayer().isActive()).forEach(player -> {
            int latency = (int)player.getPlayer().getPing();
            Set<TabPlayer> players = group.getTabPlayers(this.plugin, (TabPlayer)player);
            players.forEach(p -> p.getPlayer().getTabList().getEntry(player.getPlayer().getUniqueId()).ifPresent(entry -> entry.setLatency(Math.max(latency, 0))));
        });
    }
}

