/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.config;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.ConfigValidator;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.config.PlaceholderReplacement;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.configlib.Configuration;
import net.william278.velocitab.tab.Nametag;

@Configuration
public class TabGroups
implements ConfigValidator {
    public static final String CONFIG_HEADER = "\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503      Velocitab TabGroups     \u2503\n\u2503    Developed by William278   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information: https://william278.net/project/velocitab\n\u2517\u2578 Documentation: https://william278.net/docs/velocitab";
    private static final Group DEFAULT_GROUP = new Group("default", List.of("<rainbow:!2>Running Velocitab by William278 & AlexDev_</rainbow>"), List.of("<gray>There are currently %players_online%/%max_players_online% players online</gray>"), "<gray>[%server%] %prefix%%username%</gray>", new Nametag("", ""), Set.of("lobby", "survival", "creative", "minigames", "skyblock", "prison", "hub"), List.of("%role_weight%", "%username_lower%"), (Map<String, List<PlaceholderReplacement>>)new LinkedHashMap<String, List<PlaceholderReplacement>>(){
        {
            this.put("%current_date_weekday_en-US%", List.of(new PlaceholderReplacement("Monday", "<red>Monday</red>"), new PlaceholderReplacement("Tuesday", "<gold>Tuesday</gold>"), new PlaceholderReplacement("Else", "<green>Other day</green>")));
        }
    }, false, 1000, 1000, false);
    public List<Group> groups = List.of(DEFAULT_GROUP);

    @NotNull
    public Group getGroupFromName(@NotNull String name) {
        return this.groups.stream().filter(group -> group.name().equals(name)).findFirst().orElseThrow(() -> new IllegalStateException("No group with name %s found".formatted(name)));
    }

    public Optional<Group> getGroup(@NotNull String name) {
        return this.groups.stream().filter(group -> group.name().equals(name)).findFirst();
    }

    public Optional<Group> getGroupFromServer(@NotNull String server, @NotNull Velocitab plugin) {
        ArrayList<Group> groups = new ArrayList<Group>(this.groups);
        Optional<Group> defaultGroup = this.getGroup("default");
        if (defaultGroup.isEmpty()) {
            throw new IllegalStateException("No default group found");
        }
        groups.remove(defaultGroup.get());
        groups.add(defaultGroup.get());
        for (Group group : groups) {
            if (!group.registeredServers(plugin, false).stream().anyMatch(s -> s.getServerInfo().getName().equalsIgnoreCase(server))) continue;
            return Optional.of(group);
        }
        if (!plugin.getSettings().isFallbackEnabled()) {
            return Optional.empty();
        }
        return defaultGroup;
    }

    public int getPosition(@NotNull Group group) {
        return this.groups.indexOf(group) + 1;
    }

    @Override
    public void validateConfig(@NotNull Velocitab plugin) {
        if (this.groups.isEmpty()) {
            throw new IllegalStateException("No tab groups defined in config");
        }
        if (this.groups.stream().noneMatch(group -> group.name().equals("default"))) {
            throw new IllegalStateException("No default tab group defined in config");
        }
        Multimap<Group, String> missingKeys = this.getMissingKeys();
        if (missingKeys.isEmpty()) {
            return;
        }
        this.fixMissingKeys(plugin, missingKeys);
    }

    @NotNull
    private Multimap<Group, String> getMissingKeys() {
        SetMultimap missingKeys = Multimaps.newSetMultimap((Map)Maps.newHashMap(), HashSet::new);
        for (Group group : this.groups) {
            if (group.format() == null) {
                missingKeys.put((Object)group, (Object)"format");
            }
            if (group.nametag() == null) {
                missingKeys.put((Object)group, (Object)"nametag");
            }
            if (group.servers() == null) {
                missingKeys.put((Object)group, (Object)"servers");
            }
            if (group.sortingPlaceholders() == null) {
                missingKeys.put((Object)group, (Object)"sortingPlaceholders");
            }
            if (group.placeholderReplacements() != null) continue;
            missingKeys.put((Object)group, (Object)"placeholderReplacements");
        }
        return missingKeys;
    }

    private void fixMissingKeys(@NotNull Velocitab plugin, @NotNull Multimap<Group, String> missingKeys) {
        missingKeys.forEach((group, keys) -> {
            plugin.log("Missing required key(s) " + keys + " for group " + group.name());
            plugin.log("Using default values for group " + group.name());
            this.groups.remove(group);
            group = new Group(group.name(), group.headers(), group.footers(), group.format() == null ? DEFAULT_GROUP.format() : group.format(), group.nametag() == null ? DEFAULT_GROUP.nametag() : group.nametag(), group.servers() == null ? DEFAULT_GROUP.servers() : group.servers(), group.sortingPlaceholders() == null ? DEFAULT_GROUP.sortingPlaceholders() : group.sortingPlaceholders(), group.placeholderReplacements() == null ? DEFAULT_GROUP.placeholderReplacements() : group.placeholderReplacements(), group.collisions(), group.headerFooterUpdateRate(), group.placeholderUpdateRate(), group.onlyListPlayersInSameServer());
            this.groups.add((Group)group);
        });
        plugin.saveTabGroups();
    }

    @Generated
    public List<Group> getGroups() {
        return this.groups;
    }

    @Generated
    private TabGroups() {
    }
}

