/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.hook.miniconditions;

import com.google.common.collect.Lists;
import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.Placeholder;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.commons.jexl3.JexlBuilder;
import net.william278.velocitab.libraries.commons.jexl3.JexlContext;
import net.william278.velocitab.libraries.commons.jexl3.JexlEngine;
import net.william278.velocitab.libraries.commons.jexl3.MapContext;
import net.william278.velocitab.libraries.expiringmap.ExpiringMap;
import net.william278.velocitab.player.TabPlayer;

public class MiniConditionManager {
    public static final Map<String, String> REPLACE = Map.of("\"", "-q-", "'", "-a-");
    public static final Map<String, String> REPLACE_2 = Map.of("*LESS3*", "<", "*GREATER3*", ">", "*LESS2*", "<", "*GREATER2*", ">");
    private static final Map<String, String> REPLACE_3 = Map.of("?dp?", ":");
    private final Velocitab plugin;
    private final JexlEngine jexlEngine;
    private final JexlContext jexlContext;
    private final Pattern targetPlaceholderPattern;
    private final Pattern miniEscapeEndTags;
    private final Map<String, Object> cachedExpressions;

    public MiniConditionManager(@NotNull Velocitab plugin) {
        this.plugin = plugin;
        this.jexlEngine = this.createJexlEngine();
        this.jexlContext = this.createJexlContext();
        this.targetPlaceholderPattern = Pattern.compile("%target_(\\w+)?%");
        this.miniEscapeEndTags = Pattern.compile("</(\\w+)>");
        this.cachedExpressions = ExpiringMap.builder().expiration(5L, TimeUnit.MINUTES).build();
    }

    @NotNull
    private JexlEngine createJexlEngine() {
        return new JexlBuilder().create();
    }

    @NotNull
    private JexlContext createJexlContext() {
        MapContext jexlContext = new MapContext();
        jexlContext.set("startsWith", new StartsWith());
        jexlContext.set("endsWith", new EndsWith());
        return jexlContext;
    }

    @NotNull
    public Component checkConditions(@NotNull Player target, @NotNull Player audience, @NotNull ArgumentQueue queue) {
        List<String> parameters = this.collectParameters(queue);
        if (parameters.isEmpty()) {
            this.plugin.getLogger().warn("Empty condition");
            return Component.empty();
        }
        String condition = this.decodeCondition(parameters.get(0));
        if (parameters.size() < 3) {
            this.plugin.getLogger().warn("Invalid condition: Missing true/false values for condition: {}", (Object)condition);
            return Component.empty();
        }
        Optional<TabPlayer> tabPlayer = this.plugin.getTabList().getTabPlayer(target);
        if (tabPlayer.isEmpty()) {
            return Component.empty();
        }
        condition = (String)Placeholder.replaceInternal(condition, this.plugin, tabPlayer.get()).first();
        String falseValue = this.processFalseValue(parameters.get(2));
        String expression = this.buildExpression(condition);
        return this.evaluateAndFormatCondition(expression, target, audience, parameters.get(1), falseValue);
    }

    @NotNull
    private List<String> collectParameters(@NotNull ArgumentQueue queue) {
        ArrayList parameters = Lists.newArrayList();
        while (queue.hasNext()) {
            String param = queue.pop().value();
            for (Map.Entry<String, String> entry : REPLACE_2.entrySet()) {
                param = param.replace(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : REPLACE_3.entrySet()) {
                param = param.replace(entry.getKey(), entry.getValue());
            }
            parameters.add(param);
        }
        return parameters;
    }

    @NotNull
    private String decodeCondition(@NotNull String condition) {
        for (Map.Entry<String, String> entry : REPLACE.entrySet()) {
            condition = condition.replace(entry.getValue(), entry.getKey());
            condition = condition.replace(entry.getKey() + entry.getKey(), entry.getKey());
        }
        return condition;
    }

    @NotNull
    private String processFalseValue(@NotNull String falseValue) {
        String tag;
        Matcher matcher = this.miniEscapeEndTags.matcher(falseValue);
        if (matcher.find() && falseValue.startsWith("</" + (tag = matcher.group(1)) + ">")) {
            falseValue = falseValue.substring(tag.length() + 3);
        }
        return falseValue;
    }

    @NotNull
    private String buildExpression(@NotNull String condition) {
        return condition.replace("and", "&&").replace("or", "||").replace("AND", "&&").replace("OR", "||");
    }

    @NotNull
    private Component evaluateAndFormatCondition(@NotNull String expression, @NotNull Player target, @NotNull Player audience, @NotNull String trueValue, @NotNull String falseValue) {
        String targetString = this.parseTargetPlaceholders(expression, target);
        try {
            Object result = this.evaluateExpression(targetString);
            if (result instanceof Boolean) {
                boolean boolResult = (Boolean)result;
                String value = boolResult ? trueValue : falseValue;
                return this.plugin.getMiniPlaceholdersHook().orElseThrow().format(value, (Audience)target, (Audience)audience);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warn("Failed to evaluate condition: {} error: {}", (Object)expression, (Object)e.getMessage());
        }
        return Component.empty();
    }

    @NotNull
    private Object evaluateExpression(@NotNull String expression) {
        return this.cachedExpressions.computeIfAbsent(expression, key -> this.jexlEngine.createExpression((String)key).evaluate(this.jexlContext));
    }

    @NotNull
    private String parseTargetPlaceholders(@NotNull String input, @NotNull Player target) {
        Optional<TabPlayer> tabPlayer = this.plugin.getTabList().getTabPlayer(target);
        if (tabPlayer.isEmpty()) {
            return input;
        }
        return this.targetPlaceholderPattern.matcher(input).replaceAll(match -> {
            String placeholder = match.group(1);
            if (placeholder == null) {
                return "";
            }
            String text = "%" + placeholder + "%";
            Optional<String> placeholderValue = ((TabPlayer)tabPlayer.get()).getCachedPlaceholderValue(text);
            return placeholderValue.orElse(text);
        });
    }

    private static class StartsWith {
        private StartsWith() {
        }

        public boolean startsWith(String str, String prefix) {
            return str != null && str.startsWith(prefix);
        }
    }

    private static class EndsWith {
        private EndsWith() {
        }

        public boolean endsWith(String str, String suffix) {
            return str != null && str.endsWith(suffix);
        }
    }
}

