/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.packet;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.ServerInfo;
import com.velocitypowered.proxy.protocol.packet.UpsertPlayerInfoPacket;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.packet.ScoreboardManager;
import net.william278.velocitab.packet.UpdateTeamsPacket;
import net.william278.velocitab.player.TabPlayer;

public class PlayerChannelHandler
extends ChannelDuplexHandler {
    private final Velocitab plugin;
    private final Player player;

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof UpdateTeamsPacket) {
            UpdateTeamsPacket updateTeamsPacket = (UpdateTeamsPacket)msg;
            if (this.plugin.getSettings().isSendScoreboardPackets()) {
                ScoreboardManager scoreboardManager = this.plugin.getScoreboardManager();
                if (!scoreboardManager.handleTeams()) {
                    super.write(ctx, msg, promise);
                    return;
                }
                if (updateTeamsPacket.isRemoveTeam()) {
                    super.write(ctx, msg, promise);
                    return;
                }
                if (scoreboardManager.isInternalTeam(updateTeamsPacket.teamName())) {
                    super.write(ctx, msg, promise);
                    return;
                }
                if (!updateTeamsPacket.hasEntities()) {
                    super.write(ctx, msg, promise);
                    return;
                }
                if (updateTeamsPacket.entities().stream().noneMatch(entity -> this.plugin.getServer().getPlayer(entity).isPresent())) {
                    super.write(ctx, msg, promise);
                    return;
                }
                this.plugin.getLogger().warn("Cancelled team \"{}\" packet from backend for player {}. We suggest disabling \"send_scoreboard_packets\" in Velocitab's config.yml file, but note this will disable TAB sorting", (Object)updateTeamsPacket.teamName(), (Object)this.player.getUsername());
                return;
            }
        }
        if (!(msg instanceof UpsertPlayerInfoPacket)) {
            super.write(ctx, msg, promise);
            return;
        }
        UpsertPlayerInfoPacket minecraftPacket = (UpsertPlayerInfoPacket)msg;
        try {
            Optional<TabPlayer> tabPlayer = this.plugin.getTabList().getTabPlayer(this.player);
            if (tabPlayer.isEmpty() && !this.isFutureTabPlayer()) {
                super.write(ctx, msg, promise);
                return;
            }
            if (this.plugin.getSettings().isRemoveSpectatorEffect() && minecraftPacket.containsAction(UpsertPlayerInfoPacket.Action.UPDATE_GAME_MODE)) {
                this.forceGameMode(minecraftPacket.getEntries());
            }
            if (minecraftPacket.containsAction(UpsertPlayerInfoPacket.Action.ADD_PLAYER)) {
                minecraftPacket.getEntries().stream().filter(entry -> entry.getProfile() != null && !entry.getProfile().getId().equals(entry.getProfileId())).forEach(entry -> entry.setListed(false));
            }
            if (!minecraftPacket.containsAction(UpsertPlayerInfoPacket.Action.ADD_PLAYER) && !minecraftPacket.containsAction(UpsertPlayerInfoPacket.Action.UPDATE_LISTED)) {
                super.write(ctx, msg, promise);
                return;
            }
            if (minecraftPacket.getEntries().stream().allMatch(entry -> entry.getProfile() != null && entry.getProfile().getName().startsWith("CIT"))) {
                super.write(ctx, msg, promise);
                return;
            }
            super.write(ctx, msg, promise);
        }
        catch (Exception e) {
            this.plugin.getLogger().error("An error occurred while handling a packet", (Throwable)e);
            super.write(ctx, msg, promise);
        }
    }

    private void forceGameMode(@NotNull List<UpsertPlayerInfoPacket.Entry> entries) {
        entries.stream().filter(entry -> entry.getProfileId() != null && entry.getGameMode() == 3 && !entry.getProfileId().equals(this.player.getUniqueId())).forEach(entry -> entry.setGameMode(0));
    }

    private boolean isFutureTabPlayer() {
        String serverName = this.player.getCurrentServer().map(ServerConnection::getServerInfo).map(ServerInfo::getName).orElse("");
        Optional<Group> groupOptional = this.plugin.getTabList().getGroup(serverName);
        return groupOptional.isPresent();
    }

    @Generated
    public PlayerChannelHandler(Velocitab plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }
}

