/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.mvel2.ast;

import net.william278.velocitab.libraries.mvel2.CompileException;
import net.william278.velocitab.libraries.mvel2.DataConversion;
import net.william278.velocitab.libraries.mvel2.MVEL;
import net.william278.velocitab.libraries.mvel2.ParserContext;
import net.william278.velocitab.libraries.mvel2.ast.ASTNode;
import net.william278.velocitab.libraries.mvel2.compiler.ExecutableStatement;
import net.william278.velocitab.libraries.mvel2.integration.VariableResolverFactory;
import net.william278.velocitab.libraries.mvel2.util.ParseTools;
import net.william278.velocitab.libraries.mvel2.util.ReflectionUtil;

public class TypeCast
extends ASTNode {
    private ExecutableStatement statement;
    private boolean widen;

    public TypeCast(char[] expr, int start, int offset, Class cast, int fields, ParserContext pCtx) {
        super(pCtx);
        this.egressType = cast;
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        if ((fields & 0x10) != 0 && (this.statement = (ExecutableStatement)ParseTools.subCompileExpression(expr, start, offset, pCtx)).getKnownEgressType() != Object.class && !DataConversion.canConvert(cast, this.statement.getKnownEgressType())) {
            if (this.canCast(this.statement.getKnownEgressType(), cast)) {
                this.widen = true;
            } else {
                throw new CompileException("unable to cast type: " + this.statement.getKnownEgressType() + "; to: " + cast, expr, start);
            }
        }
    }

    private boolean canCast(Class from, Class to) {
        return ReflectionUtil.isAssignableFrom(from, to) || from.isInterface() && this.interfaceAssignable(from, to);
    }

    private boolean interfaceAssignable(Class from, Class to) {
        for (Class<?> c : from.getInterfaces()) {
            if (!c.isAssignableFrom(to)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.widen ? TypeCast.typeCheck(this.statement.getValue(ctx, thisValue, factory), this.egressType) : DataConversion.convert(this.statement.getValue(ctx, thisValue, factory), this.egressType);
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.widen ? TypeCast.typeCheck(MVEL.eval(this.expr, this.start, this.offset, ctx, factory), this.egressType) : DataConversion.convert(MVEL.eval(this.expr, this.start, this.offset, ctx, factory), this.egressType);
    }

    private static Object typeCheck(Object inst, Class type) {
        if (inst == null) {
            return null;
        }
        if (type.isInstance(inst)) {
            return inst;
        }
        throw new ClassCastException(inst.getClass().getName() + " cannot be cast to: " + type.getName());
    }

    public ExecutableStatement getStatement() {
        return this.statement;
    }
}

