/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.config;

import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.PluginDescription;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.Metadata;
import net.william278.velocitab.config.Settings;
import net.william278.velocitab.config.TabGroupsManager;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.configlib.NameFormatters;
import net.william278.velocitab.libraries.configlib.YamlConfigurationProperties;
import net.william278.velocitab.libraries.configlib.YamlConfigurations;
import net.william278.velocitab.libraries.desertwell.util.Version;

public interface ConfigProvider {
    @NotNull
    public static final YamlConfigurationProperties.Builder<?> YAML_CONFIGURATION_PROPERTIES = (YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)YamlConfigurationProperties.newBuilder().charset(StandardCharsets.UTF_8)).outputNulls(true)).inputNulls(false)).setNameFormatter(NameFormatters.LOWER_UNDERSCORE);

    @NotNull
    public Velocitab getPlugin();

    @NotNull
    public Settings getSettings();

    public void setSettings(@NotNull Settings var1);

    default public void loadSettings() {
        this.setSettings(YamlConfigurations.update(this.getConfigDirectory().resolve("config.yml"), Settings.class, ((YamlConfigurationProperties.Builder)YAML_CONFIGURATION_PROPERTIES.header("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503       Velocitab Config       \u2503\n\u2503  by William278 & AlexDev03   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information: https://william278.net/project/velocitab\n\u2517\u2578 Documentation: https://william278.net/docs/velocitab")).build()));
        this.getSettings().validateConfig(this.getPlugin(), "config.yml");
    }

    @NotNull
    public TabGroupsManager getTabGroupsManager();

    public void setTabGroupsManager(@NotNull TabGroupsManager var1);

    default public void loadTabGroups() {
        this.setTabGroupsManager(new TabGroupsManager(this.getPlugin()));
        this.getTabGroupsManager().loadGroups();
    }

    @NotNull
    default public Metadata getMetadata() {
        Metadata metadata;
        block8: {
            URL resource = ConfigProvider.class.getResource("/metadata.yml");
            InputStream input = Objects.requireNonNull(resource, "Metadata file missing").openStream();
            try {
                metadata = YamlConfigurations.read(input, Metadata.class, YAML_CONFIGURATION_PROPERTIES.build());
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to load plugin metadata", e);
                }
            }
            input.close();
        }
        return metadata;
    }

    default public void checkCompatibility() {
        if (this.getSkipCompatibilityCheck().orElse(false).booleanValue()) {
            this.getPlugin().getLogger().warn("Skipping compatibility checks");
            return;
        }
        Metadata metadata = this.getMetadata();
        Version proxyVersion = this.getVelocityVersion();
        metadata.validateApiVersion(proxyVersion);
        metadata.validateBuild(proxyVersion);
        Optional<Version> papiProxyBridgeVersion = this.getPapiProxyBridgeVersion();
        if (papiProxyBridgeVersion.isPresent()) {
            metadata.validatePapiProxyBridgeVersion(papiProxyBridgeVersion.get());
        }
    }

    @NotNull
    default public Optional<Boolean> getSkipCompatibilityCheck() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().stream().filter(s -> s.startsWith("-Dvelocitab.skip-compatibility-check=")).map(s -> s.substring(s.indexOf(61) + 1)).filter(s -> s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false")).map(Boolean::parseBoolean).findFirst();
    }

    default public Optional<Version> getPapiProxyBridgeVersion() {
        return this.getPlugin().getServer().getPluginManager().getPlugin("papiproxybridge").map(PluginContainer::getDescription).flatMap(PluginDescription::getVersion).map(Version::fromString);
    }

    @NotNull
    public Version getVelocityVersion();

    @NotNull
    public Path getConfigDirectory();
}

