/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.ConfigProvider;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.config.TabGroups;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.configlib.YamlConfigurationProperties;
import net.william278.velocitab.libraries.configlib.YamlConfigurations;

public class TabGroupsManager {
    private final Velocitab plugin;
    private final Map<String, Group> groups;
    private final Map<TabGroups, String> groupsFiles;
    private List<Group> groupsList;

    public TabGroupsManager(@NotNull Velocitab plugin) {
        this.plugin = plugin;
        this.groups = Maps.newConcurrentMap();
        this.groupsFiles = Maps.newConcurrentMap();
        this.groupsList = Lists.newArrayList();
    }

    public void loadGroups() {
        this.groups.clear();
        this.groupsFiles.clear();
        Path configDirectory = this.plugin.getConfigDirectory();
        File defaultFile = configDirectory.resolve("tab_groups.yml").toFile();
        YamlConfigurationProperties properties = ((YamlConfigurationProperties.Builder)ConfigProvider.YAML_CONFIGURATION_PROPERTIES.header("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503     Velocitab Tab Groups     \u2503\n\u2503  by William278 & AlexDev03   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information: https://william278.net/project/velocitab\n\u2517\u2578 Documentation: https://william278.net/docs/velocitab")).build();
        TabGroups defaultTagGroupsFile = YamlConfigurations.update(configDirectory.resolve("tab_groups.yml"), TabGroups.class, properties);
        String defaultName = defaultFile.getAbsolutePath().replace(".yml", "");
        if (!this.validateGroups(defaultTagGroupsFile, defaultName)) {
            throw new IllegalStateException("Failed to load default tab groups file");
        }
        File folder = this.plugin.getConfigDirectory().resolve("tab_groups").toFile();
        if (folder.exists()) {
            File[] filesArray = folder.listFiles();
            List<Object> files = filesArray == null ? List.of() : Arrays.asList(filesArray);
            for (File file : files) {
                String name;
                if (!file.getName().endsWith(".yml")) continue;
                TabGroups preCheck = YamlConfigurations.load(file.toPath(), TabGroups.class, properties);
                preCheck.groups.removeIf(g -> g.name().equals("default"));
                YamlConfigurations.save(file.toPath(), TabGroups.class, preCheck, properties);
                TabGroups group = YamlConfigurations.update(file.toPath(), TabGroups.class, properties);
                if (this.validateGroups(group, name = String.valueOf(folder.getAbsoluteFile()) + "/" + file.getName().replace(".yml", ""))) continue;
                throw new IllegalStateException("Failed to load tab groups file " + file.getName());
            }
        }
        this.groupsList = Lists.newArrayList(this.getGroups());
    }

    @NotNull
    public List<File> getGroupsFiles() {
        return this.groupsFiles.values().stream().map(f -> new File(f + ".yml")).collect(Collectors.toList());
    }

    public boolean isDefaultFile(@NotNull File file) {
        return this.plugin.getConfigDirectory().resolve("tab_groups.yml").toFile().getAbsolutePath().equals(file.getAbsolutePath());
    }

    private boolean validateGroups(@NotNull TabGroups group, @NotNull String name) {
        Set<RegisteredServer> current;
        this.groupsFiles.put(group, name);
        group.validateConfig(this.plugin, name);
        ArrayList eligibleGroups = Lists.newArrayList();
        HashSet registeredServers = Sets.newHashSet();
        block0: for (Group group1 : group.groups) {
            current = group1.registeredServers(this.plugin, false);
            if (this.groups.containsKey(group1.name())) {
                this.plugin.getLogger().warn("Group {} is already defined in {} tab groups file. Skipping.", (Object)group1.name(), (Object)name);
                continue;
            }
            for (RegisteredServer registeredServer : current) {
                if (!registeredServers.contains(registeredServer)) continue;
                this.plugin.getLogger().warn("Server {} is already registered for group {} in {}, the same tabgroups file. Skipping.", new Object[]{registeredServer.getServerInfo().getName(), group1.name(), name});
                continue block0;
            }
            registeredServers.addAll(current);
            eligibleGroups.add(group1);
        }
        block2: for (Group group1 : this.groups.values()) {
            current = group1.registeredServers(this.plugin, false);
            for (Group loadingGroup : eligibleGroups) {
                Set<RegisteredServer> loadingGroupServers = loadingGroup.registeredServers(this.plugin, false);
                for (RegisteredServer registeredServer : loadingGroupServers) {
                    if (!current.contains(registeredServer)) continue;
                    this.plugin.getLogger().warn("Server {} in {} tab groups file is already registered for group {}. Skipping.", new Object[]{registeredServer.getServerInfo().getName(), name, group1.name()});
                    eligibleGroups.remove(loadingGroup);
                    continue block2;
                }
            }
        }
        for (Group group1 : eligibleGroups) {
            this.groups.put(group1.name(), group1);
        }
        return true;
    }

    public void saveGroup(@NotNull TabGroups group) {
        String name = this.groupsFiles.get(group);
        YamlConfigurations.save(new File("plugins/Velocitab").toPath().resolve(name + ".yml"), TabGroups.class, group, ((YamlConfigurationProperties.Builder)ConfigProvider.YAML_CONFIGURATION_PROPERTIES.header("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503     Velocitab Tab Groups     \u2503\n\u2503  by William278 & AlexDev03   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information: https://william278.net/project/velocitab\n\u2517\u2578 Documentation: https://william278.net/docs/velocitab")).build());
    }

    public Optional<Group> getGroupFromServer(@NotNull String server, @NotNull Velocitab plugin) {
        ArrayList<Group> groups = new ArrayList<Group>(this.groups.values());
        Optional<Group> defaultGroup = this.getGroup("default");
        if (defaultGroup.isEmpty()) {
            throw new IllegalStateException("No default tab group defined");
        }
        groups.remove(defaultGroup.get());
        groups.add(defaultGroup.get());
        for (Group group : groups) {
            if (!group.registeredServers(plugin, false).stream().anyMatch(s -> s.getServerInfo().getName().equalsIgnoreCase(server))) continue;
            return Optional.of(group);
        }
        return Optional.empty();
    }

    public Optional<Group> getGroup(@NotNull String name) {
        return Optional.ofNullable(this.groups.get(name));
    }

    public int getGroupPosition(@NotNull Group group) {
        return this.groupsList.indexOf(group) + 1;
    }

    @NotNull
    public Collection<Group> getGroups() {
        return this.groups.values();
    }
}

