/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.tab;

import com.google.common.collect.Maps;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.player.TabList;
import com.velocitypowered.api.proxy.player.TabListEntry;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import com.velocitypowered.api.scheduler.ScheduledTask;
import com.velocitypowered.api.util.ServerLink;
import com.velocitypowered.proxy.tablist.KeyedVelocityTabList;
import com.velocitypowered.proxy.tablist.VelocityTabList;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.api.PlayerAddedToTabEvent;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.config.ServerUrl;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.packet.ScoreboardManager;
import net.william278.velocitab.player.Role;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.tab.TabListListener;
import net.william278.velocitab.tab.TaskManager;
import net.william278.velocitab.tab.VanishTabList;
import net.william278.velocitab.util.DebugSystem;
import org.slf4j.event.Level;

public class PlayerTabList {
    private static final String RELATIONAL_PERMISSION = "velocitab.relational";
    private final Velocitab plugin;
    private final VanishTabList vanishTabList;
    private final Map<UUID, TabPlayer> players;
    private final TaskManager taskManager;
    private final Map<Class<?>, Field> entriesFields;

    public PlayerTabList(@NotNull Velocitab plugin) {
        this.plugin = plugin;
        this.vanishTabList = new VanishTabList(plugin, this);
        this.players = Maps.newConcurrentMap();
        this.taskManager = new TaskManager(plugin);
        this.entriesFields = Maps.newHashMap();
        this.registerListener();
        this.ensureDisplayNameTask();
        this.registerFields();
    }

    private void registerFields() {
        Field entriesField;
        Class<KeyedVelocityTabList> keyedVelocityTabListClass = KeyedVelocityTabList.class;
        Class<VelocityTabList> velocityTabListClass = VelocityTabList.class;
        try {
            entriesField = keyedVelocityTabListClass.getDeclaredField("entries");
            entriesField.setAccessible(true);
            this.entriesFields.put(keyedVelocityTabListClass, entriesField);
        }
        catch (NoSuchFieldException e) {
            this.plugin.log(Level.ERROR, "Failed to register KeyedVelocityTabList field", e);
        }
        try {
            entriesField = velocityTabListClass.getDeclaredField("entries");
            entriesField.setAccessible(true);
            this.entriesFields.put(velocityTabListClass, entriesField);
        }
        catch (NoSuchFieldException e) {
            this.plugin.log(Level.ERROR, "Failed to register VelocityTabList field", e);
        }
    }

    private void registerListener() {
        this.plugin.getServer().getEventManager().register((Object)this.plugin, (Object)new TabListListener(this.plugin, this));
    }

    public Optional<TabPlayer> getTabPlayer(@NotNull Player player) {
        return Optional.ofNullable(this.players.get(player.getUniqueId()));
    }

    public Optional<TabPlayer> getTabPlayer(@NotNull UUID uuid) {
        return Optional.ofNullable(this.players.get(uuid));
    }

    public void load() {
        this.plugin.getServer().getAllPlayers().forEach(p -> {
            Optional server = p.getCurrentServer();
            if (server.isEmpty()) {
                return;
            }
            String serverName = ((ServerConnection)server.get()).getServerInfo().getName();
            @NotNull Optional<Group> group = this.getGroup(serverName);
            if (group.isEmpty()) {
                return;
            }
            this.loadPlayer((Player)p, group.get(), 400);
        });
        this.reloadUpdate();
    }

    protected void loadPlayer(@NotNull Player player, @NotNull Group group, int delay) {
        ScheduledTask task = this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> this.plugin.getPlaceholderManager().fetchPlaceholders(player.getUniqueId(), group.getTextsWithPlaceholders(this.plugin), group)).delay(150L, TimeUnit.MILLISECONDS).repeat(50L, TimeUnit.MILLISECONDS).schedule();
        this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> {
            task.cancel();
            this.joinPlayer(player, group);
        }).delay((long)delay, TimeUnit.MILLISECONDS).schedule();
    }

    public void close() {
        this.taskManager.close();
        this.plugin.getServer().getAllPlayers().forEach(p -> {
            Optional server = p.getCurrentServer();
            if (server.isEmpty()) {
                return;
            }
            TabPlayer tabPlayer = this.players.get(p.getUniqueId());
            if (tabPlayer == null) {
                return;
            }
            Set<RegisteredServer> serversInGroup = tabPlayer.getGroup().registeredServers(this.plugin);
            if (serversInGroup.isEmpty()) {
                return;
            }
            serversInGroup.remove(((ServerConnection)server.get()).getServer());
            serversInGroup.forEach(s -> s.getPlayersConnected().forEach(t -> t.getTabList().removeEntry(p.getUniqueId())));
        });
        this.plugin.getPacketEventManager().removeAllPlayers();
    }

    protected void clearCachedData(@NotNull Player player) {
        this.players.values().forEach(p -> {
            p.unsetRelationalDisplayName(player.getUniqueId());
            p.unsetRelationalNametag(player.getUniqueId());
        });
    }

    protected void joinPlayer(@NotNull Player joined, @NotNull Group group) {
        Optional<TabPlayer> tabPlayerOptional = this.getTabPlayer(joined);
        if (tabPlayerOptional.isPresent()) {
            tabPlayerOptional.get().clearCachedData();
            tabPlayerOptional.get().setGroup(group);
            tabPlayerOptional.get().setRole(this.plugin.getLuckPermsHook().map(hook -> hook.getPlayerRole(joined)).orElse(Role.DEFAULT_ROLE));
        }
        TabPlayer tabPlayer = tabPlayerOptional.orElseGet(() -> this.createTabPlayer(joined, group));
        String serverName = this.getServerName(joined);
        tabPlayer.setLastServer(serverName);
        this.sendPlayerServerLinks(tabPlayer);
        this.handleDisplayLoad(tabPlayer);
    }

    private void handleDisplayLoad(@NotNull TabPlayer tabPlayer) {
        Player joined = tabPlayer.getPlayer();
        Group group = tabPlayer.getGroup();
        boolean isVanished = this.plugin.getVanishManager().isVanished(joined.getUsername());
        this.players.putIfAbsent(joined.getUniqueId(), tabPlayer);
        tabPlayer.sendHeaderAndFooter(this);
        tabPlayer.setLoaded(true);
        List<TabPlayer> tabPlayers = group.getTabPlayersAsList(this.plugin, tabPlayer);
        this.updateTabListOnJoin(tabPlayer, group, tabPlayers, isVanished);
    }

    private void updateTabListOnJoin(@NotNull TabPlayer tabPlayer, @NotNull Group group, @NotNull List<TabPlayer> tabPlayers, boolean isJoinedVanished) {
        Player joined = tabPlayer.getPlayer();
        String serverName = this.getServerName(joined);
        Set uuids = tabPlayers.stream().map(p -> p.getPlayer().getUniqueId()).collect(Collectors.toSet());
        List.copyOf(tabPlayer.getPlayer().getTabList().getEntries()).forEach(entry -> {
            if (!uuids.contains(entry.getProfile().getId())) {
                tabPlayer.getPlayer().getTabList().removeEntry(entry.getProfile().getId());
            }
        });
        for (TabPlayer iteratedPlayer : tabPlayers) {
            Player player = iteratedPlayer.getPlayer();
            String username = player.getUsername();
            boolean isPlayerVanished = this.plugin.getVanishManager().isVanished(username);
            if (group.onlyListPlayersInSameServer() && !serverName.equals(this.getServerName(player))) continue;
            this.checkVisibilityAndUpdateName(iteratedPlayer, tabPlayer, isJoinedVanished);
            if (iteratedPlayer != tabPlayer) {
                this.checkVisibilityAndUpdateName(tabPlayer, iteratedPlayer, isPlayerVanished);
            }
            iteratedPlayer.sendHeaderAndFooter(this);
        }
        ScoreboardManager scoreboardManager = this.plugin.getScoreboardManager();
        scoreboardManager.resendAllTeams(tabPlayer);
        this.updateSorting(tabPlayer, false);
        this.fixDuplicateEntries(joined);
        this.plugin.getServer().getEventManager().fireAndForget((Object)new PlayerAddedToTabEvent(tabPlayer, group));
    }

    private void checkVisibilityAndUpdateName(@NotNull TabPlayer observedPlayer, @NotNull TabPlayer observableTabPlayer, boolean isObservablePlayerVanished) {
        UUID observableUUID = observableTabPlayer.getPlayer().getUniqueId();
        String observedUsername = observedPlayer.getPlayer().getUsername();
        String observableUsername = observableTabPlayer.getPlayer().getUsername();
        TabList observableTabPlayerTabList = observableTabPlayer.getPlayer().getTabList();
        if (isObservablePlayerVanished && !this.plugin.getVanishManager().canSee(observableUsername, observedUsername) && !observableUUID.equals(observedPlayer.getPlayer().getUniqueId()) || !observedPlayer.getPlayer().isActive()) {
            observableTabPlayerTabList.removeEntry(observedPlayer.getPlayer().getUniqueId());
        } else {
            this.calculateAndSetDisplayName(observedPlayer, observableTabPlayer);
        }
    }

    @NotNull
    private String getServerName(@NotNull Player player) {
        return player.getCurrentServer().map(serverConnection -> serverConnection.getServerInfo().getName()).orElse("");
    }

    @NotNull
    public Component formatRelationalComponent(@NotNull TabPlayer player, @NotNull TabPlayer viewer, @NotNull String toParse) {
        return this.plugin.getFormatter().format(toParse, player, viewer, this.plugin);
    }

    @NotNull
    public Component formatComponent(@NotNull TabPlayer player, @NotNull String toParse) {
        return this.plugin.getFormatter().format(toParse, player, this.plugin);
    }

    private void fixDuplicateEntries(@NotNull Player target) {
        try {
            Optional<Field> optionalField = Optional.ofNullable(this.entriesFields.get(target.getTabList().getClass()));
            if (optionalField.isEmpty()) {
                return;
            }
            Field entriesField = optionalField.get();
            Map entries = (Map)entriesField.get(target.getTabList());
            entries.entrySet().stream().filter(entry -> ((TabListEntry)entry.getValue()).getProfile() != null).filter(entry -> ((TabListEntry)entry.getValue()).getProfile().getId().equals(target.getUniqueId())).filter(entry -> !((UUID)entry.getKey()).equals(target.getUniqueId())).forEach(entry -> target.getTabList().removeEntry((UUID)entry.getKey()));
        }
        catch (Throwable error) {
            this.plugin.log(Level.ERROR, "Failed to fix duplicate entries for class " + target.getTabList().getClass().getName(), error);
        }
    }

    protected void removeTabListUUID(@NotNull UUID uuid) {
        this.getPlayers().forEach((key, value) -> value.getPlayer().getTabList().getEntry(uuid).ifPresent(entry -> value.getPlayer().getTabList().removeEntry(uuid)));
    }

    protected void removePlayer(@NotNull Player target) {
        UUID uuid = target.getUniqueId();
        Optional<TabPlayer> tabPlayer = this.getTabPlayer(target.getUniqueId());
        if (tabPlayer.isEmpty()) {
            return;
        }
        Group group = tabPlayer.get().getGroup();
        tabPlayer.get().setLoaded(false);
        this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> {
            List<TabPlayer> list = group.getTabPlayersAsList(this.plugin);
            list.forEach(player -> {
                player.getPlayer().getTabList().removeEntry(uuid);
                player.sendHeaderAndFooter(this);
            });
        }).delay(250L, TimeUnit.MILLISECONDS).schedule();
        this.plugin.getScoreboardManager().resetCache(target);
        this.getPlayers().remove(uuid);
    }

    @NotNull
    protected TabListEntry createEntry(@NotNull TabPlayer player, @NotNull TabList tabList, @NotNull Component displayName) {
        return TabListEntry.builder().profile(player.getPlayer().getGameProfile()).displayName(displayName).latency(Math.max((int)player.getPlayer().getPing(), 0)).tabList(tabList).build();
    }

    @NotNull
    protected TabListEntry createEntry(@NotNull TabPlayer player, @NotNull TabList tabList, @NotNull TabPlayer viewer) {
        if (!viewer.getPlayer().getTabList().equals(tabList)) {
            throw new IllegalArgumentException("TabList of viewer is not the same as the TabList of the entry");
        }
        String displayNameUnformatted = this.plugin.getPlaceholderManager().applyPlaceholders(player, player.getGroup().format(), viewer);
        Component displayName = this.formatRelationalComponent(player, viewer, displayNameUnformatted);
        player.setRelationalDisplayName(viewer.getPlayer().getUniqueId(), displayName);
        return TabListEntry.builder().profile(player.getPlayer().getGameProfile()).displayName(displayName).latency(Math.max((int)player.getPlayer().getPing(), 0)).tabList(tabList).build();
    }

    protected void calculateAndSetDisplayName(@NotNull TabPlayer player, @NotNull TabPlayer viewer) {
        String withPlaceholders = this.plugin.getPlaceholderManager().applyPlaceholders(player, player.getGroup().format());
        String unformatted = this.plugin.getPlaceholderManager().formatVelocitabPlaceholders(withPlaceholders, player, null);
        if (!this.plugin.getSettings().isEnableRelationalPlaceholders()) {
            String stripped = this.plugin.getPlaceholderManager().stripVelocitabRelPlaceholders(unformatted);
            Component displayName = this.plugin.getFormatter().format(stripped, player, this.plugin);
            this.updateEntryDisplayName(player, viewer, displayName);
            return;
        }
        String withRelationalPlaceholders = this.plugin.getPlaceholderManager().formatVelocitabPlaceholders(unformatted, player, viewer);
        Component displayName = this.plugin.getFormatter().format(withRelationalPlaceholders, player, viewer, this.plugin);
        this.updateEntryDisplayName(player, viewer, displayName);
    }

    protected void updateEntryDisplayName(@NotNull TabPlayer player, @NotNull TabPlayer viewer, @NotNull Component displayName) {
        Optional<Component> cached = player.getRelationalDisplayName(viewer.getPlayer().getUniqueId());
        if (cached.isPresent() && cached.get().equals(displayName)) {
            if (viewer.getPlayer().getTabList().getEntry(player.getPlayer().getUniqueId()).flatMap(TabListEntry::getDisplayNameComponent).map(displayName::equals).orElse(false).booleanValue()) {
                return;
            }
        }
        player.setRelationalDisplayName(viewer.getPlayer().getUniqueId(), displayName);
        viewer.getPlayer().getTabList().getEntry(player.getPlayer().getUniqueId()).ifPresentOrElse(entry -> entry.setDisplayName(displayName), () -> viewer.getPlayer().getTabList().addEntry(this.createEntry(player, viewer.getPlayer().getTabList(), displayName)));
    }

    @NotNull
    public TabPlayer createTabPlayer(@NotNull Player player, @NotNull Group group) {
        return new TabPlayer(this.plugin, player, this.plugin.getLuckPermsHook().map(hook -> hook.getPlayerRole(player)).orElse(Role.DEFAULT_ROLE), group);
    }

    public void updateHeaderFooter(@NotNull Group group) {
        group.getTabPlayers(this.plugin).forEach(p -> p.sendHeaderAndFooter(this));
    }

    public void updatePlayer(@NotNull TabPlayer tabPlayer, boolean force) {
        if (!tabPlayer.getPlayer().isActive()) {
            this.removeOfflinePlayer(tabPlayer.getPlayer());
            return;
        }
        this.plugin.getPlaceholderManager().fetchPlaceholders(tabPlayer.getPlayer().getUniqueId(), tabPlayer.getGroup().sortingPlaceholders(), tabPlayer.getGroup());
        this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> this.updateSorting(tabPlayer, force)).delay(100L, TimeUnit.MILLISECONDS).schedule();
    }

    public void updateSorting(@NotNull Group group) {
        List<TabPlayer> players = group.getTabPlayersAsList(this.plugin);
        players.forEach(p -> this.updateSorting((TabPlayer)p, false, players));
    }

    private void updateSorting(@NotNull TabPlayer tabPlayer, boolean force) {
        List<TabPlayer> players = tabPlayer.getGroup().getTabPlayersAsList(this.plugin, tabPlayer);
        this.updateSorting(tabPlayer, force, players);
    }

    private void updateSorting(@NotNull TabPlayer tabPlayer, boolean force, @NotNull List<TabPlayer> players) {
        String teamName = tabPlayer.getTeamName(this.plugin);
        if (teamName.isBlank() || !tabPlayer.getPlayer().isActive()) {
            return;
        }
        this.plugin.getScoreboardManager().updateRole(tabPlayer, teamName, force);
        int order = this.plugin.getScoreboardManager().getPosition(teamName);
        if (order == -1) {
            DebugSystem.log(DebugSystem.DebugLevel.ERROR, "Failed to get position for " + tabPlayer.getPlayer().getUsername());
            return;
        }
        tabPlayer.setListOrder(order);
        this.recalculateSortingForPlayers(tabPlayer, players, order);
    }

    private boolean hasListOrder(TabPlayer tabPlayer) {
        return tabPlayer.getPlayer().getProtocolVersion().noLessThan((Object)ProtocolVersion.MINECRAFT_1_21_2);
    }

    private void updateSorting(TabPlayer tabPlayer, UUID uuid, int position) {
        tabPlayer.getPlayer().getTabList().getEntry(uuid).filter(entry -> entry.getListOrder() != position).ifPresent(entry -> entry.setListOrder(position));
    }

    public synchronized void recalculateSortingForPlayers(@NotNull TabPlayer tabPlayer, @NotNull List<TabPlayer> players, int order) {
        players.stream().filter(this::hasListOrder).forEach(p -> this.updateSorting((TabPlayer)p, tabPlayer.getPlayer().getUniqueId(), order));
    }

    public void sendPlayerServerLinks(@NotNull TabPlayer player) {
        if (player.getPlayer().getProtocolVersion().lessThan((Object)ProtocolVersion.MINECRAFT_1_21)) {
            return;
        }
        List<ServerUrl> urls = this.plugin.getSettings().getUrlsForGroup(player.getGroup());
        List<ServerLink> serverLinks = ServerUrl.resolve(this.plugin, player, urls);
        player.getPlayer().setServerLinks(serverLinks);
    }

    public void updateGroupNames(@NotNull Group group) {
        List<TabPlayer> players = group.getTabPlayersAsList(this.plugin);
        if (this.plugin.getSettings().isEnableRelationalPlaceholders()) {
            this.updateRelationalGroupNames(players, group);
            return;
        }
        this.updateNormalGroupNames(players, group);
    }

    private void updateNormalGroupNames(List<TabPlayer> players, @NotNull Group group) {
        String stripped = this.plugin.getPlaceholderManager().stripVelocitabRelPlaceholders(group.format());
        this.checkStrippedString(stripped, group);
        for (TabPlayer player : players) {
            String displayName = this.plugin.getPlaceholderManager().applyPlaceholders(player, stripped);
            String displayNameConditional = this.plugin.getPlaceholderManager().formatVelocitabPlaceholders(displayName, player, null);
            Component displayNameComponent = this.formatComponent(player, displayNameConditional);
            players.forEach(viewer -> this.updateEntryDisplayName(player, (TabPlayer)viewer, displayNameComponent));
        }
    }

    private void updateRelationalGroupNames(@NotNull List<TabPlayer> players, @NotNull Group group) {
        for (TabPlayer p1 : players) {
            if (!p1.getPlayer().isActive() || !p1.isLoaded()) {
                return;
            }
            boolean isVanished = this.plugin.getVanishManager().isVanished(p1.getPlayer().getUsername());
            String formatPlaceholders = this.plugin.getPlaceholderManager().applyPlaceholders(p1, group.format());
            String formatConditionalPlaceholders = this.plugin.getPlaceholderManager().formatVelocitabPlaceholders(formatPlaceholders, p1, null);
            String formatConditionalPlaceholdersWithoutRelational = this.plugin.getPlaceholderManager().stripVelocitabRelPlaceholders(formatConditionalPlaceholders);
            Component relationalPlaceholder = this.formatComponent(p1, formatConditionalPlaceholdersWithoutRelational);
            for (TabPlayer player : players) {
                if (isVanished && !this.plugin.getVanishManager().canSee(player.getPlayer().getUsername(), p1.getPlayer().getUsername())) {
                    return;
                }
                if (!player.getPlayer().isActive() || !player.isLoaded()) {
                    return;
                }
                if (!player.getPlayer().hasPermission(RELATIONAL_PERMISSION)) {
                    this.updateEntryDisplayName(p1, player, relationalPlaceholder);
                    continue;
                }
                String withPlaceholders = this.plugin.getPlaceholderManager().applyViewerPlaceholders(player, formatConditionalPlaceholders);
                String unformatted = this.plugin.getPlaceholderManager().formatVelocitabPlaceholders(withPlaceholders, p1, player);
                Component displayName = this.formatRelationalComponent(p1, player, unformatted);
                this.updateEntryDisplayName(p1, player, displayName);
            }
        }
    }

    public void updateDisplayName(@NotNull TabPlayer tabPlayer) {
        if (this.plugin.getSettings().isEnableRelationalPlaceholders()) {
            this.updateRelationalDisplayName(tabPlayer);
            return;
        }
        this.updateNormalDisplayName(tabPlayer);
    }

    private void updateNormalDisplayName(@NotNull TabPlayer tabPlayer) {
        Group group = tabPlayer.getGroup();
        String stripped = this.plugin.getPlaceholderManager().stripVelocitabRelPlaceholders(group.format());
        this.checkStrippedString(stripped, group);
        List<TabPlayer> players = group.getTabPlayersAsList(this.plugin, tabPlayer);
        players.forEach(player -> {
            if (!player.getPlayer().hasPermission(RELATIONAL_PERMISSION)) {
                String displayName = this.plugin.getPlaceholderManager().applyPlaceholders((TabPlayer)player, stripped);
                String displayNameConditional = this.plugin.getPlaceholderManager().formatVelocitabPlaceholders(displayName, (TabPlayer)player, null);
                Component displayNameComponent = this.formatComponent((TabPlayer)player, displayNameConditional);
                this.updateEntryDisplayName((TabPlayer)player, tabPlayer, displayNameComponent);
                return;
            }
            String withPlaceholders = this.plugin.getPlaceholderManager().applyViewerPlaceholders((TabPlayer)player, stripped);
            String unformatted = this.plugin.getPlaceholderManager().formatVelocitabPlaceholders(withPlaceholders, tabPlayer, (TabPlayer)player);
            Component displayName = this.formatRelationalComponent(tabPlayer, (TabPlayer)player, unformatted);
            this.updateEntryDisplayName(tabPlayer, (TabPlayer)player, displayName);
        });
    }

    private void updateRelationalDisplayName(@NotNull TabPlayer tabPlayer) {
        Group group = tabPlayer.getGroup();
        String stripped = this.plugin.getPlaceholderManager().stripVelocitabRelPlaceholders(group.format());
        this.checkStrippedString(stripped, group);
        List<TabPlayer> players = group.getTabPlayersAsList(this.plugin, tabPlayer);
        players.forEach(player -> {
            String displayName = this.plugin.getPlaceholderManager().applyPlaceholders((TabPlayer)player, stripped);
            String displayNameConditional = this.plugin.getPlaceholderManager().formatVelocitabPlaceholders(displayName, (TabPlayer)player, null);
            Component displayNameComponent = this.formatRelationalComponent((TabPlayer)player, tabPlayer, displayNameConditional);
            this.updateEntryDisplayName((TabPlayer)player, tabPlayer, displayNameComponent);
        });
    }

    private void checkStrippedString(@NotNull String text, @NotNull Group group) {
        if (text.length() != group.format().length()) {
            DebugSystem.log(DebugSystem.DebugLevel.WARNING, "Found relational placeholder in group {} format even though relational placeholders are disabled", group.name());
        }
    }

    public void checkCorrectDisplayName(@NotNull TabPlayer tabPlayer) {
        if (!tabPlayer.isLoaded()) {
            return;
        }
        boolean bypass = this.plugin.getSettings().isForceSendingTabListPackets();
        this.players.values().stream().filter(TabPlayer::isLoaded).forEach(player -> player.getPlayer().getTabList().getEntry(tabPlayer.getPlayer().getUniqueId()).ifPresent(entry -> {
            Optional<Component> displayNameOptional = tabPlayer.getRelationalDisplayName(player.getPlayer().getUniqueId());
            if (displayNameOptional.isEmpty()) {
                return;
            }
            Component lastDisplayName = displayNameOptional.get();
            if (bypass || entry.getDisplayNameComponent().isEmpty() || !lastDisplayName.equals(entry.getDisplayNameComponent().get())) {
                entry.setDisplayName(lastDisplayName);
            }
        }));
    }

    public void checkCorrectDisplayNames() {
        this.players.values().forEach(this::checkCorrectDisplayName);
    }

    public void ensureDisplayNameTask() {
        this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, this::checkCorrectDisplayNames).delay(1L, TimeUnit.SECONDS).repeat(5L, TimeUnit.SECONDS).schedule();
    }

    public Component getHeader(@NotNull TabPlayer player) {
        String header = player.getGroup().getHeader(player.getHeaderIndex());
        String replaced = this.plugin.getPlaceholderManager().applyPlaceholders(player, header);
        return this.plugin.getFormatter().format(replaced, player, this.plugin);
    }

    public Component getFooter(@NotNull TabPlayer player) {
        String footer = player.getGroup().getFooter(player.getFooterIndex());
        String replaced = this.plugin.getPlaceholderManager().applyPlaceholders(player, footer);
        return this.plugin.getFormatter().format(replaced, player, this.plugin);
    }

    public void reloadUpdate() {
        this.taskManager.cancelAllTasks();
        this.plugin.getPlaceholderManager().reload();
        this.plugin.getPlaceholderManager().preparePlaceholdersReplacements();
        this.plugin.getTabGroupsManager().getGroups().forEach(g -> {
            this.plugin.getPlaceholderManager().fetchPlaceholders((Group)g);
            this.taskManager.updatePeriodically((Group)g);
        });
        if (this.players.isEmpty()) {
            return;
        }
        this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> {
            this.players.values().forEach(player -> {
                Optional server = player.getPlayer().getCurrentServer();
                if (server.isEmpty()) {
                    return;
                }
                String serverName = ((ServerConnection)server.get()).getServerInfo().getName();
                Optional<Group> group = this.getGroup(serverName);
                if (group.isEmpty()) {
                    return;
                }
                player.setGroup(group.get());
                this.sendPlayerServerLinks((TabPlayer)player);
                this.updatePlayer((TabPlayer)player, true);
                player.sendHeaderAndFooter(this);
            });
            this.plugin.getTabGroupsManager().getGroups().forEach(this::updateGroupNames);
        }).delay(500L, TimeUnit.MILLISECONDS).schedule();
    }

    @NotNull
    public Optional<Group> getGroup(@NotNull String serverName) {
        return this.plugin.getTabGroupsManager().getGroupFromServer(serverName, this.plugin);
    }

    @NotNull
    public Group getGroupOrDefault(@NotNull Player player) {
        Optional<Group> group = this.getGroup(player.getCurrentServer().map(ServerConnection::getServerInfo).map(ServerInfo::getName).orElse(""));
        return group.orElse(this.plugin.getTabGroupsManager().getGroup("default").orElseThrow());
    }

    public void removeOldEntry(@NotNull Group group, @NotNull UUID uuid) {
        Set<TabPlayer> players = group.getTabPlayers(this.plugin);
        players.forEach(player -> player.getPlayer().getTabList().removeEntry(uuid));
    }

    public void removeOfflinePlayer(@NotNull Player player) {
        this.players.remove(player.getUniqueId());
    }

    @Generated
    public VanishTabList getVanishTabList() {
        return this.vanishTabList;
    }

    @Generated
    public Map<UUID, TabPlayer> getPlayers() {
        return this.players;
    }

    @Generated
    protected TaskManager getTaskManager() {
        return this.taskManager;
    }
}

