/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.tab;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.velocitypowered.api.scheduler.ScheduledTask;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.util.DebugSystem;

public class TaskManager {
    private final Velocitab plugin;
    private final Map<Group, List<ScheduledFuture<?>>> groupTasks;
    private final Map<Group, List<ScheduledTask>> groupTasksOld;
    private final ScheduledExecutorService processThread;

    public TaskManager(@NotNull Velocitab plugin) {
        this.plugin = plugin;
        this.groupTasksOld = Maps.newConcurrentMap();
        this.groupTasks = Maps.newConcurrentMap();
        this.processThread = Executors.newSingleThreadScheduledExecutor();
    }

    protected void cancelAllTasks() {
        this.groupTasksOld.values().forEach(c -> c.forEach(ScheduledTask::cancel));
        this.groupTasksOld.clear();
        this.groupTasks.values().forEach(c -> c.forEach(t -> t.cancel(true)));
        this.groupTasks.clear();
    }

    public void close() {
        try {
            this.cancelAllTasks();
            this.processThread.shutdownNow();
        }
        catch (Throwable e) {
            this.plugin.getLogger().error("Failed to close task manager", e);
        }
    }

    protected void updatePeriodically(@NotNull Group group) {
        List tasks = this.groupTasks.computeIfAbsent(group, g -> Lists.newArrayList());
        if (group.headerFooterUpdateRate() > 0) {
            ScheduledFuture<?> headerFooterTask = this.processThread.scheduleAtFixedRate(() -> {
                long startTime = System.currentTimeMillis();
                this.plugin.getTabList().updateHeaderFooter(group);
                long endTime = System.currentTimeMillis();
                long time = endTime - startTime;
                if (time > 30L) {
                    DebugSystem.log(DebugSystem.DebugLevel.DEBUG, "Updated header/footer for group {} took {}ms", group.name(), time);
                }
            }, 250L, Math.max(200, group.headerFooterUpdateRate()), TimeUnit.MILLISECONDS);
            tasks.add(headerFooterTask);
        }
        if (group.formatUpdateRate() > 0) {
            ScheduledFuture<?> formatTask = this.processThread.scheduleAtFixedRate(() -> {
                long startTime = System.currentTimeMillis();
                this.plugin.getTabList().updateGroupNames(group);
                long endTime = System.currentTimeMillis();
                long time = endTime - startTime;
                if (time > 50L) {
                    DebugSystem.log(DebugSystem.DebugLevel.DEBUG, "Updated format for group {} took {}ms", group.name(), time);
                }
            }, 500L, Math.max(200, group.formatUpdateRate()), TimeUnit.MILLISECONDS);
            tasks.add(formatTask);
        }
        if (group.nametagUpdateRate() > 0) {
            ScheduledFuture<?> nametagTask = this.processThread.scheduleAtFixedRate(() -> {
                long startTime = System.currentTimeMillis();
                this.plugin.getTabList().updateSorting(group);
                long endTime = System.currentTimeMillis();
                long time = endTime - startTime;
                if (time > 50L) {
                    DebugSystem.log(DebugSystem.DebugLevel.DEBUG, "Updated nametags/sorting for group {} took {}ms", group.name(), time);
                }
            }, 750L, Math.max(200, group.nametagUpdateRate()), TimeUnit.MILLISECONDS);
            tasks.add(nametagTask);
        }
        if (group.placeholderUpdateRate() > 0) {
            ScheduledFuture<?> updateTask = this.processThread.scheduleAtFixedRate(() -> {
                long startTime = System.currentTimeMillis();
                this.updatePlaceholders(group);
                long endTime = System.currentTimeMillis();
                long time = endTime - startTime;
                if (time > 10L) {
                    DebugSystem.log(DebugSystem.DebugLevel.DEBUG, "Updated placeholders for group {} took {}ms", group.name(), time);
                }
            }, 1000L, Math.max(200, group.placeholderUpdateRate()), TimeUnit.MILLISECONDS);
            tasks.add(updateTask);
        }
        ScheduledFuture<?> latencyTask = this.processThread.scheduleAtFixedRate(() -> {
            long startTime = System.currentTimeMillis();
            this.updateLatency(group);
            long endTime = System.currentTimeMillis();
            long time = endTime - startTime;
            if (time > 10L) {
                DebugSystem.log(DebugSystem.DebugLevel.DEBUG, "Updated latency for group {} took {}ms", group.name(), time);
            }
        }, 1250L, 2500L, TimeUnit.MILLISECONDS);
        tasks.add(latencyTask);
    }

    private void updatePlaceholders(@NotNull Group group) {
        List<TabPlayer> players = group.getTabPlayersAsList(this.plugin);
        if (players.isEmpty()) {
            return;
        }
        List<String> texts = group.getTextsWithPlaceholders(this.plugin);
        players.forEach(player -> this.plugin.getPlaceholderManager().fetchPlaceholders(player.getPlayer().getUniqueId(), texts, group));
    }

    private void updateLatency(@NotNull Group group) {
        Set<TabPlayer> groupPlayers = group.getTabPlayers(this.plugin);
        if (groupPlayers.isEmpty()) {
            return;
        }
        groupPlayers.stream().filter(player -> player.getPlayer().isActive()).forEach(player -> {
            int latency = (int)player.getPlayer().getPing();
            Set<TabPlayer> players = group.getTabPlayers(this.plugin, (TabPlayer)player);
            players.forEach(p -> p.getPlayer().getTabList().getEntry(player.getPlayer().getUniqueId()).ifPresent(entry -> entry.setLatency(Math.max(latency, 0))));
        });
    }

    public void run(@NotNull Runnable runnable) {
        this.processThread.execute(runnable);
    }

    public void runDelayed(@NotNull Runnable runnable, long delay, @NotNull TimeUnit timeUnit) {
        this.processThread.schedule(runnable, delay, timeUnit);
    }
}

