/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.vanish;

import com.velocitypowered.api.proxy.Player;
import java.util.Optional;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.util.DebugSystem;
import net.william278.velocitab.vanish.DefaultVanishIntegration;
import net.william278.velocitab.vanish.VanishIntegration;

public class VanishManager {
    private final Velocitab plugin;
    private VanishIntegration integration;

    public VanishManager(@NotNull Velocitab plugin) {
        this.plugin = plugin;
        this.setIntegration(new DefaultVanishIntegration());
    }

    public void setIntegration(@NotNull VanishIntegration integration) {
        this.integration = integration;
    }

    @NotNull
    public VanishIntegration getIntegration() {
        return this.integration;
    }

    public boolean canSee(@NotNull String name, @NotNull String otherName) {
        long start = System.currentTimeMillis();
        boolean result = this.integration.canSee(name, otherName);
        long end = System.currentTimeMillis();
        if (end - start > 2L) {
            DebugSystem.log(DebugSystem.DebugLevel.DEBUG, "Vanish isVanished check took " + (end - start) + "ms");
        }
        return result;
    }

    public boolean isVanished(@NotNull String name) {
        long start = System.currentTimeMillis();
        boolean result = this.integration.isVanished(name);
        long end = System.currentTimeMillis();
        if (end - start > 2L) {
            DebugSystem.log(DebugSystem.DebugLevel.DEBUG, "Vanish isVanished check took " + (end - start) + "ms");
        }
        return result;
    }

    public void vanishPlayer(@NotNull Player player) {
        Optional<TabPlayer> tabPlayer = this.plugin.getTabList().getTabPlayer(player);
        if (tabPlayer.isEmpty()) {
            this.plugin.log("Failed to vanish player " + player.getUsername() + " as they are not in the tab list");
            return;
        }
        this.plugin.getTabList().getVanishTabList().vanishPlayer(tabPlayer.get());
        this.plugin.getScoreboardManager().vanishPlayer(tabPlayer.get());
    }

    public void unVanishPlayer(@NotNull Player player) {
        Optional<TabPlayer> tabPlayer = this.plugin.getTabList().getTabPlayer(player);
        if (tabPlayer.isEmpty()) {
            this.plugin.log("Failed to un-vanish player " + player.getUsername() + " as they are not in the tab list");
            return;
        }
        this.plugin.getTabList().getVanishTabList().unVanishPlayer(tabPlayer.get());
        this.plugin.getScoreboardManager().unVanishPlayer(tabPlayer.get());
    }
}

