/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.hook;

import com.google.common.collect.Maps;
import com.velocitypowered.api.proxy.Player;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.event.EventSubscription;
import net.luckperms.api.event.user.UserDataRecalculateEvent;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.hook.Hook;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.annotations.Nullable;
import net.william278.velocitab.player.Role;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.tab.PlayerTabList;

public class LuckPermsHook
extends Hook {
    private final LuckPerms api = LuckPermsProvider.get();
    private final EventSubscription<UserDataRecalculateEvent> event;
    private final Map<UUID, Long> lastUpdate = Maps.newConcurrentMap();
    private boolean enabled;

    public LuckPermsHook(@NotNull Velocitab plugin) throws IllegalStateException {
        super(plugin, "LuckPerms");
        this.event = this.api.getEventBus().subscribe((Object)plugin, UserDataRecalculateEvent.class, this::onLuckPermsGroupUpdate);
        this.enabled = true;
    }

    public void closeEvent() {
        this.event.close();
        this.enabled = false;
    }

    @NotNull
    public Role getPlayerRole(@NotNull Player player) {
        return this.getRoleFromMetadata(this.getUser(player.getUniqueId()).getCachedData().getMetaData());
    }

    @NotNull
    private Role getRoleFromMetadata(@NotNull CachedMetaData metaData) {
        if (metaData.getPrimaryGroup() == null) {
            return Role.DEFAULT_ROLE;
        }
        Optional<Group> group = this.getGroup(metaData.getPrimaryGroup());
        return new Role(group.map(this::getGroupWeight).orElse(0), metaData.getPrimaryGroup(), group.map(Group::getDisplayName).orElse(metaData.getPrimaryGroup()), metaData.getPrefix(), metaData.getSuffix());
    }

    @Nullable
    public String getMeta(@NotNull Player player, @NotNull String key) {
        return this.getUser(player.getUniqueId()).getCachedData().getMetaData().getMetaValue(key);
    }

    public void onLuckPermsGroupUpdate(@NotNull UserDataRecalculateEvent event) {
        if (this.lastUpdate.getOrDefault(event.getUser().getUniqueId(), 0L) > System.currentTimeMillis() - 100L) {
            return;
        }
        this.lastUpdate.put(event.getUser().getUniqueId(), System.currentTimeMillis());
        if (!this.enabled) {
            return;
        }
        PlayerTabList tabList = this.plugin.getTabList();
        this.plugin.getServer().getPlayer(event.getUser().getUniqueId()).ifPresent(player -> this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> {
            Role newRole;
            Optional<TabPlayer> tabPlayerOptional = tabList.getTabPlayer((Player)player);
            if (tabPlayerOptional.isEmpty()) {
                return;
            }
            TabPlayer tabPlayer = tabPlayerOptional.get();
            Role oldRole = tabPlayer.getRole();
            if (oldRole.equals(newRole = this.getRoleFromMetadata(event.getUser().getCachedData().getMetaData())) && player.hasPermission("velocitab.relational") == tabPlayer.isRelationalPermission()) {
                return;
            }
            tabPlayer.setRole(newRole);
            tabPlayer.setRelationalPermission(player.hasPermission("velocitab.relational"));
            tabList.updateDisplayName(tabPlayer);
            tabList.getVanishTabList().recalculateVanishForPlayer(tabPlayer);
            this.checkRoleUpdate(tabPlayer, oldRole);
        }).delay(100L, TimeUnit.MILLISECONDS).schedule());
    }

    private Optional<Group> getGroup(@Nullable String groupName) {
        if (groupName == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.api.getGroupManager().getGroup(groupName));
    }

    private int getGroupWeight(@NotNull Group group) {
        return group.getWeight().orElse(0);
    }

    private User getUser(@NotNull UUID uuid) {
        return this.api.getUserManager().getUser(uuid);
    }

    private void checkRoleUpdate(@NotNull TabPlayer player, @NotNull Role oldRole) {
        if (oldRole.equals(player.getRole())) {
            return;
        }
        this.plugin.getTabList().updatePlayer(player, false);
    }
}

