/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.mvel2.ast;

import net.william278.velocitab.libraries.mvel2.ParserContext;
import net.william278.velocitab.libraries.mvel2.ast.ASTNode;
import net.william278.velocitab.libraries.mvel2.integration.VariableResolverFactory;
import net.william278.velocitab.libraries.mvel2.util.CompilerTools;

public class Instance
extends ASTNode {
    private ASTNode stmt;
    private ASTNode clsStmt;

    public Instance(ASTNode stmt, ASTNode clsStmt, ParserContext pCtx) {
        super(pCtx);
        this.stmt = stmt;
        this.clsStmt = clsStmt;
        CompilerTools.expectType(pCtx, clsStmt, Class.class, true);
    }

    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return ((Class)this.clsStmt.getReducedValueAccelerated(ctx, thisValue, factory)).isInstance(this.stmt.getReducedValueAccelerated(ctx, thisValue, factory));
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            Class i = (Class)this.clsStmt.getReducedValue(ctx, thisValue, factory);
            if (i == null) {
                throw new ClassCastException();
            }
            return i.isInstance(this.stmt.getReducedValue(ctx, thisValue, factory));
        }
        catch (ClassCastException e) {
            throw new RuntimeException("not a class reference: " + this.clsStmt.getName());
        }
    }

    @Override
    public Class getEgressType() {
        return Boolean.class;
    }

    public ASTNode getStatement() {
        return this.stmt;
    }

    public ASTNode getClassStatement() {
        return this.clsStmt;
    }
}

