/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.toilet;

import com.fatboyindustrial.gsonjavatime.Converters;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import lombok.Generated;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.annotations.Nullable;
import net.william278.velocitab.libraries.toilet.DumpOptions;
import net.william278.velocitab.libraries.toilet.dump.AttachedFile;
import net.william278.velocitab.libraries.toilet.dump.Dump;
import net.william278.velocitab.libraries.toilet.dump.DumpUser;
import net.william278.velocitab.libraries.toilet.dump.Dumper;
import net.william278.velocitab.libraries.toilet.dump.ExtraFile;
import net.william278.velocitab.libraries.toilet.dump.PluginStatus;
import net.william278.velocitab.libraries.toilet.dump.ProjectMeta;
import net.william278.velocitab.libraries.toilet.util.AttachedFileSerializer;
import net.william278.velocitab.libraries.toilet.util.FileReaderUtil;
import net.william278.velocitab.libraries.toilet.util.StatusBlockDeserializer;
import net.william278.velocitab.libraries.toilet.web.Flusher;

public abstract class Toilet
implements Dumper,
Flusher {
    protected static final int LATEST_LOG_MAX_LINES = 1500;
    private DumpOptions options;

    @NotNull
    public final URI dump(@Nullable PluginStatus status, @Nullable DumpUser dumper, ExtraFile ... extraFiles) {
        try {
            Dump dump = this.createDump(status, dumper, extraFiles);
            String json = this.createGson().toJson((Object)dump);
            String code = this.uploadDump(json, this.options.getBytebinUrl(), this.options.getProjectMeta().getId());
            return URI.create("%s/%s".formatted(this.options.getViewerUrl(), code));
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to create dump: %s".formatted(e.getCause()), e);
        }
    }

    @NotNull
    public final URI dump(@Nullable PluginStatus status, ExtraFile ... extraFiles) {
        return this.dump(status, (DumpUser)null, extraFiles);
    }

    @NotNull
    public final URI dump(@Nullable DumpUser dumper, ExtraFile ... extraFiles) {
        return this.dump(null, dumper, extraFiles);
    }

    @NotNull
    public final URI dump(ExtraFile ... extraFiles) {
        return this.dump((PluginStatus)null, (DumpUser)null, extraFiles);
    }

    @NotNull
    private Gson createGson() {
        return Converters.registerOffsetDateTime(new GsonBuilder().registerTypeAdapter(PluginStatus.StatusBlock.class, (Object)new StatusBlockDeserializer()).registerTypeAdapter(AttachedFile.class, (Object)new AttachedFileSerializer())).create();
    }

    @Override
    @NotNull
    public final ProjectMeta getProjectMeta() {
        return this.options.getProjectMeta();
    }

    @Override
    @NotNull
    public Path getProjectConfigDirectory() {
        return Path.of(System.getProperty("user.dir"), new String[0]).resolve("plugins").resolve(this.getProjectMeta().getName());
    }

    @Override
    @NotNull
    public String getLatestLog() {
        try {
            return FileReaderUtil.readLargeFile(Path.of(System.getProperty("user.dir"), new String[0]).resolve("logs").resolve("latest.log"), 1500);
        }
        catch (IOException e) {
            return "Failed to read latest.log";
        }
    }

    @Override
    @Generated
    public DumpOptions getOptions() {
        return this.options;
    }

    @Generated
    protected Toilet(DumpOptions options) {
        this.options = options;
    }
}

