/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.toilet.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.toilet.DumpOptions;
import net.william278.velocitab.libraries.toilet.dump.AttachedFile;
import net.william278.velocitab.libraries.toilet.dump.ConfigFile;
import net.william278.velocitab.libraries.toilet.file.FileReader;
import net.william278.velocitab.libraries.toilet.util.FileFilterUtil;
import net.william278.velocitab.libraries.toilet.util.FileReaderUtil;

public final class ConfigFileReader
implements FileReader {
    private static final int CONFIG_MAX_LINES = 1000;

    @Override
    public Optional<AttachedFile> read(@NotNull DumpOptions.FileInclusionRule.FileMeta meta, @NotNull Path configDirectory) {
        try {
            Path file = meta.getPath(configDirectory);
            if (Files.isRegularFile(file, new LinkOption[0])) {
                return Optional.of(new ConfigFile(file.getFileName().toString(), meta.fileLabel(), FileFilterUtil.filterConfig(FileReaderUtil.readLargeFile(file, 1000))));
            }
            return Optional.empty();
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }
}

