/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.player;

import com.google.common.collect.Maps;
import com.velocitypowered.api.proxy.Player;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.annotations.Nullable;
import net.william278.velocitab.packet.UpdateTeamsPacket;
import net.william278.velocitab.player.Role;
import net.william278.velocitab.tab.Nametag;
import net.william278.velocitab.tab.PlayerTabList;

public final class TabPlayer
implements Comparable<TabPlayer> {
    private final Velocitab plugin;
    private final Player player;
    private Role role;
    private int headerIndex = 0;
    private int footerIndex = 0;
    private final Map<UUID, Component> relationalDisplayNames;
    private final Map<UUID, Component[]> relationalNametags;
    private Component lastHeader;
    private Component lastFooter;
    private String teamName;
    private int listOrder = -1;
    @Nullable
    private UpdateTeamsPacket.TeamColor teamColor;
    @Nullable
    private String customName;
    @Nullable
    private String lastServer;
    @NotNull
    private Group group;
    private boolean loaded;
    private boolean relationalPermission;

    public TabPlayer(@NotNull Velocitab plugin, @NotNull Player player, @NotNull Role role, @NotNull Group group, boolean relationalPermission) {
        this.plugin = plugin;
        this.player = player;
        this.role = role;
        this.group = group;
        this.relationalDisplayNames = Maps.newConcurrentMap();
        this.relationalNametags = Maps.newConcurrentMap();
        this.relationalPermission = relationalPermission;
    }

    @NotNull
    public String getRoleWeightString() {
        return this.getRole().getWeightString();
    }

    @NotNull
    public String getServerName() {
        return this.player.getCurrentServer().map(serverConnection -> serverConnection.getServerInfo().getName()).orElse(this.lastServer != null ? this.lastServer : "unknown");
    }

    public int getServerGroupPosition(@NotNull Velocitab plugin) {
        return plugin.getTabGroupsManager().getGroupPosition(this.group);
    }

    public Nametag getNametag(@NotNull Velocitab plugin) {
        String prefix = plugin.getPlaceholderManager().applyPlaceholders(this, this.group.nametag().prefix());
        String suffix = plugin.getPlaceholderManager().applyPlaceholders(this, this.group.nametag().suffix());
        return new Nametag(prefix, suffix);
    }

    @NotNull
    public String getTeamName(@NotNull Velocitab plugin) {
        String teamName;
        this.teamName = teamName = plugin.getSortingManager().getTeamName(this);
        return this.teamName;
    }

    public Optional<String> getLastTeamName() {
        return Optional.ofNullable(this.teamName);
    }

    public void sendHeaderAndFooter(@NotNull PlayerTabList tabList) {
        Component header = tabList.getHeader(this);
        Component footer = tabList.getFooter(this);
        this.lastHeader = header;
        this.lastFooter = footer;
        this.player.sendPlayerListHeaderAndFooter(header, footer);
    }

    public void incrementIndexes() {
        this.incrementHeaderIndex();
        this.incrementFooterIndex();
    }

    public void incrementHeaderIndex() {
        ++this.headerIndex;
        if (this.headerIndex >= this.group.headers().size()) {
            this.headerIndex = 0;
        }
    }

    public void incrementFooterIndex() {
        ++this.footerIndex;
        if (this.footerIndex >= this.group.footers().size()) {
            this.footerIndex = 0;
        }
    }

    public void setRelationalDisplayName(@NotNull UUID target, @NotNull Component displayName) {
        this.relationalDisplayNames.put(target, displayName);
    }

    public void unsetRelationalDisplayName(@NotNull UUID target) {
        this.relationalDisplayNames.remove(target);
    }

    public Optional<Component> getRelationalDisplayName(@NotNull UUID target) {
        return Optional.ofNullable(this.relationalDisplayNames.get(target));
    }

    public void setRelationalNametag(@NotNull UUID target, @NotNull Component prefix, @NotNull Component suffix) {
        this.relationalNametags.put(target, new Component[]{prefix, suffix});
    }

    public void unsetRelationalNametag(@NotNull UUID target) {
        this.relationalNametags.remove(target);
    }

    public Optional<Component[]> getRelationalNametag(@NotNull UUID target) {
        return Optional.ofNullable(this.relationalNametags.get(target));
    }

    public void clearCachedData() {
        this.loaded = false;
        this.relationalDisplayNames.clear();
        this.relationalNametags.clear();
        this.lastHeader = null;
        this.lastFooter = null;
        this.role = Role.DEFAULT_ROLE;
        this.teamName = null;
    }

    public Optional<String> getCustomName() {
        return Optional.ofNullable(this.customName);
    }

    @Override
    public int compareTo(@NotNull TabPlayer o) {
        int roleDifference = this.role.compareTo(o.role);
        if (roleDifference <= 0) {
            return this.player.getUsername().compareTo(o.player.getUsername());
        }
        return roleDifference;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TabPlayer)) return false;
        TabPlayer other = (TabPlayer)obj;
        if (!this.player.getUniqueId().equals(other.player.getUniqueId())) return false;
        return true;
    }

    @Generated
    public Velocitab getPlugin() {
        return this.plugin;
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public Role getRole() {
        return this.role;
    }

    @Generated
    public int getHeaderIndex() {
        return this.headerIndex;
    }

    @Generated
    public int getFooterIndex() {
        return this.footerIndex;
    }

    @Generated
    public Map<UUID, Component> getRelationalDisplayNames() {
        return this.relationalDisplayNames;
    }

    @Generated
    public Map<UUID, Component[]> getRelationalNametags() {
        return this.relationalNametags;
    }

    @Generated
    public Component getLastHeader() {
        return this.lastHeader;
    }

    @Generated
    public Component getLastFooter() {
        return this.lastFooter;
    }

    @Generated
    public String getTeamName() {
        return this.teamName;
    }

    @Generated
    public int getListOrder() {
        return this.listOrder;
    }

    @Nullable
    @Generated
    public UpdateTeamsPacket.TeamColor getTeamColor() {
        return this.teamColor;
    }

    @Nullable
    @Generated
    public String getLastServer() {
        return this.lastServer;
    }

    @NotNull
    @Generated
    public Group getGroup() {
        return this.group;
    }

    @Generated
    public boolean isLoaded() {
        return this.loaded;
    }

    @Generated
    public boolean isRelationalPermission() {
        return this.relationalPermission;
    }

    @Generated
    public String toString() {
        return "TabPlayer(plugin=" + String.valueOf(this.getPlugin()) + ", player=" + String.valueOf(this.getPlayer()) + ", role=" + String.valueOf(this.getRole()) + ", headerIndex=" + this.getHeaderIndex() + ", footerIndex=" + this.getFooterIndex() + ", relationalDisplayNames=" + String.valueOf(this.getRelationalDisplayNames()) + ", relationalNametags=" + String.valueOf(this.getRelationalNametags()) + ", lastHeader=" + String.valueOf(this.getLastHeader()) + ", lastFooter=" + String.valueOf(this.getLastFooter()) + ", teamName=" + this.getTeamName() + ", listOrder=" + this.getListOrder() + ", teamColor=" + String.valueOf((Object)this.getTeamColor()) + ", customName=" + String.valueOf(this.getCustomName()) + ", lastServer=" + this.getLastServer() + ", group=" + String.valueOf(this.getGroup()) + ", loaded=" + this.isLoaded() + ", relationalPermission=" + this.isRelationalPermission() + ")";
    }

    @Generated
    public void setRole(Role role) {
        this.role = role;
    }

    @Generated
    public void setListOrder(int listOrder) {
        this.listOrder = listOrder;
    }

    @Generated
    public void setTeamColor(@Nullable UpdateTeamsPacket.TeamColor teamColor) {
        this.teamColor = teamColor;
    }

    @Generated
    public void setCustomName(@Nullable String customName) {
        this.customName = customName;
    }

    @Generated
    public void setLastServer(@Nullable String lastServer) {
        this.lastServer = lastServer;
    }

    @Generated
    public void setGroup(@NotNull Group group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        this.group = group;
    }

    @Generated
    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    @Generated
    public void setRelationalPermission(boolean relationalPermission) {
        this.relationalPermission = relationalPermission;
    }
}

