/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.placeholder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.annotations.Nullable;
import net.william278.velocitab.placeholder.ConditionManager;
import net.william278.velocitab.placeholder.Placeholder;
import net.william278.velocitab.placeholder.PlaceholderReplacement;
import net.william278.velocitab.player.Role;
import net.william278.velocitab.player.TabPlayer;

public class PlaceholderManager {
    private boolean debug = false;
    private static final String ELSE_PLACEHOLDER = "else";
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("%.*?%", 32);
    private static final Pattern VELOCITAB_PLACEHOLDERS = Pattern.compile("<velocitab[^<>]*(?:<(?!v)[^<>]*>[^<>]*)*>");
    private static final Pattern VELOCITAB_REL_PLACEHOLDERS = Pattern.compile("<velocitab_rel[^<>]*(?:<(?!v)[^<>]*>[^<>]*)*>");
    private final Velocitab plugin;
    private final Map<UUID, Map<String, String>> placeholders;
    private final Map<UUID, Set<CompletableFuture<?>>> requests;
    private final Map<Group, List<String>> cachedTexts;
    private final Set<UUID> blocked;
    private final ConditionManager conditionManager;
    private Map<Group, Map<String, Map<String, String>>> placeholdersReplacements;

    public PlaceholderManager(Velocitab plugin) {
        this.plugin = plugin;
        this.placeholders = Maps.newConcurrentMap();
        this.requests = Maps.newConcurrentMap();
        this.blocked = Sets.newConcurrentHashSet();
        this.cachedTexts = Maps.newConcurrentMap();
        this.conditionManager = new ConditionManager(plugin);
        this.placeholdersReplacements = Maps.newConcurrentMap();
        this.preparePlaceholdersReplacements();
    }

    public void preparePlaceholdersReplacements() {
        this.placeholdersReplacements = Maps.newConcurrentMap();
        for (Group group : this.plugin.getTabGroupsManager().getGroups()) {
            HashMap map = Maps.newHashMap();
            this.placeholdersReplacements.put(group, map);
            for (String placeholder : group.placeholderReplacements().keySet()) {
                HashMap repMap = Maps.newHashMap();
                map.put(placeholder, repMap);
                for (PlaceholderReplacement replacement : group.placeholderReplacements().get(placeholder)) {
                    repMap.put(replacement.placeholder().toLowerCase(Locale.ROOT), replacement.replacement());
                }
            }
        }
    }

    public void fetchPlaceholders(@NotNull Group group) {
        List texts = this.cachedTexts.computeIfAbsent(group, g -> g.getTextsWithPlaceholders(this.plugin));
        group.getPlayersAsList(this.plugin).forEach(player -> this.fetchPlaceholders(player.getUniqueId(), texts, group));
    }

    public void reload() {
        this.cachedTexts.clear();
    }

    public void fetchPlaceholders(@NotNull UUID uuid, @NotNull List<String> texts, @NotNull Group group) {
        Player player = this.plugin.getServer().getPlayer(uuid).orElse(null);
        if (player == null) {
            return;
        }
        if (this.blocked.contains(uuid)) {
            return;
        }
        Map parsed = this.placeholders.computeIfAbsent(uuid, k -> Maps.newConcurrentMap());
        TabPlayer tabPlayer = this.plugin.getTabList().getTabPlayer(player).orElse(new TabPlayer(this.plugin, player, this.plugin.getLuckPermsHook().map(hook -> hook.getPlayerRole(player)).orElse(Role.DEFAULT_ROLE), this.plugin.getTabList().getGroupOrDefault(player), player.hasPermission("velocitab.relational")));
        List<String> placeholders = texts.stream().map(PlaceholderManager::extractPlaceholders).flatMap(Collection::stream).map(s -> s.replace("%target_", "%")).toList();
        long start = System.currentTimeMillis();
        placeholders.forEach(placeholder -> this.replaceSingle((String)placeholder, this.plugin, tabPlayer).ifPresentOrElse(replacement -> parsed.put(placeholder, replacement), () -> this.plugin.getPAPIProxyBridgeHook().ifPresent(hook -> {
            CompletableFuture<String> future = hook.formatPlaceholders((String)placeholder, player);
            this.requests.computeIfAbsent(player.getUniqueId(), u -> Sets.newConcurrentHashSet()).add(future);
            future.thenAccept(replacement -> {
                long diff;
                if (replacement == null || replacement.equals(placeholder)) {
                    return;
                }
                if (this.blocked.contains(player.getUniqueId())) {
                    return;
                }
                if (this.debug) {
                    this.plugin.getLogger().info("Placeholder {} replaced with  {} in {}ms", new Object[]{placeholder, replacement, System.currentTimeMillis() - start});
                }
                if ((diff = System.currentTimeMillis() - start) > (long)group.placeholderUpdateRate()) {
                    long increase = diff + 100L;
                    this.plugin.getLogger().warn("Placeholder {} took more than group placeholder update rate of {} ms to update. This may cause a thread leak.\nPlease fix the issue of the plugin providing the placeholder.\nIf you can't fix it, increase the placeholder update rate of the group to at least {} ms.\n", new Object[]{placeholder, group.placeholderUpdateRate(), increase});
                }
                parsed.put(placeholder, replacement);
                this.requests.get(player.getUniqueId()).remove(future);
            });
        })));
    }

    @NotNull
    public String applyPlaceholders(@NotNull TabPlayer player, @NotNull String text) {
        Map parsed = this.placeholders.computeIfAbsent(player.getPlayer().getUniqueId(), uuid -> Maps.newConcurrentMap());
        return this.applyPlaceholderReplacements(text, player, parsed);
    }

    @NotNull
    public String applyPlaceholders(@NotNull TabPlayer player, @NotNull String text, @NotNull TabPlayer viewer) {
        Map parsed = this.placeholders.computeIfAbsent(player.getPlayer().getUniqueId(), uuid -> Maps.newConcurrentMap());
        String applied = this.applyPlaceholderReplacements(text, player, parsed);
        Map targetParsed = this.placeholders.computeIfAbsent(viewer.getPlayer().getUniqueId(), uuid -> Maps.newConcurrentMap());
        return this.applyPlaceholderReplacements(applied.replace("%target_", "%"), viewer, targetParsed);
    }

    @NotNull
    public String applyViewerPlaceholders(@NotNull TabPlayer viewer, @NotNull String text) {
        Map parsed = this.placeholders.computeIfAbsent(viewer.getPlayer().getUniqueId(), uuid -> Maps.newConcurrentMap());
        return this.applyPlaceholderReplacements(text.replace("%target_", "%"), viewer, parsed);
    }

    public void clearPlaceholders(@NotNull UUID uuid) {
        this.blocked.add(uuid);
        this.placeholders.remove(uuid);
        Optional.ofNullable(this.requests.get(uuid)).ifPresent(set -> set.forEach(c -> c.cancel(true)));
    }

    public void unblockPlayer(@NotNull UUID uuid) {
        this.blocked.remove(uuid);
        this.requests.remove(uuid);
    }

    @NotNull
    private static List<String> extractPlaceholders(@NotNull String text) {
        ArrayList placeholders = Lists.newArrayList();
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(text);
        while (matcher.find()) {
            placeholders.add(matcher.group());
        }
        return placeholders;
    }

    @Nullable
    private String getReplacement(@NotNull Group group, @NotNull String placeholder, @NotNull String text) {
        Map<String, Map<String, String>> replacements = this.placeholdersReplacements.get(group);
        if (replacements == null) {
            return null;
        }
        Map<String, String> replacementMap = replacements.get(placeholder.toLowerCase(Locale.ROOT));
        if (replacementMap == null) {
            return null;
        }
        String replacement = replacementMap.get(text);
        if (replacement == null) {
            return replacementMap.get(ELSE_PLACEHOLDER);
        }
        return replacement;
    }

    @NotNull
    private String applyPlaceholderReplacements(@NotNull String text, @NotNull TabPlayer player, @NotNull Map<String, String> parsed) {
        for (Map.Entry<String, List<PlaceholderReplacement>> entry : player.getGroup().placeholderReplacements().entrySet()) {
            String replaced = parsed.get(entry.getKey());
            String replacement = this.getReplacement(player.getGroup(), entry.getKey(), replaced);
            if (replacement == null) continue;
            text = text.replace(entry.getKey(), replacement);
        }
        return this.applyPlaceholders(text, parsed);
    }

    @NotNull
    private String applyPlaceholders(@NotNull String text, @NotNull Map<String, String> replacements) {
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            text = text.replace(entry.getKey(), entry.getValue());
        }
        return text;
    }

    public Optional<String> getCachedPlaceholderValue(@NotNull String text, @NotNull UUID uuid) {
        if (!this.placeholders.containsKey(uuid)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.placeholders.get(uuid).get(text));
    }

    private Optional<String> replaceSingle(@NotNull String placeholder, @NotNull Velocitab plugin, @NotNull TabPlayer player) {
        Optional<Placeholder> optionalPlaceholder = Placeholder.byName(placeholder);
        if (optionalPlaceholder.isEmpty()) {
            for (Placeholder placeholderType : Placeholder.getPARAMETERISED()) {
                Matcher matcher = placeholderType.getPattern().matcher(placeholder);
                if (!matcher.find()) continue;
                String s = this.chop(matcher.group().replace("%" + placeholderType.name().toLowerCase(), "").replaceFirst("_", ""));
                return Optional.of(placeholderType.getReplacer().apply(s, plugin, player));
            }
            return Optional.empty();
        }
        if (optionalPlaceholder.get().isParameterised()) {
            throw new IllegalArgumentException("Placeholder " + placeholder + " is parameterised");
        }
        Placeholder placeholderType = optionalPlaceholder.get();
        return Optional.of(placeholderType.getReplacer().apply(null, plugin, player));
    }

    @NotNull
    private String chop(@NotNull String text) {
        int strLen = text.length();
        if (strLen < 2) {
            return "";
        }
        int lastIdx = strLen - 1;
        String ret = text.substring(0, lastIdx);
        char last = text.charAt(lastIdx);
        return last == '\n' && ret.charAt(lastIdx - 1) == '\r' ? ret.substring(0, lastIdx - 1) : ret;
    }

    @NotNull
    public String formatVelocitabPlaceholders(@NotNull String text, @NotNull TabPlayer player, @Nullable TabPlayer viewer) {
        Matcher matcher = VELOCITAB_PLACEHOLDERS.matcher(text);
        if (!matcher.find()) {
            return text;
        }
        StringBuilder result = new StringBuilder(text.length());
        int lastEnd = 0;
        do {
            String replacement;
            String placeholder = matcher.group();
            String cleanedPlaceholder = placeholder.substring(1, placeholder.length() - 1);
            try {
                replacement = this.conditionManager.handleVelocitabPlaceholders(cleanedPlaceholder, player, viewer);
                if (replacement.equals(cleanedPlaceholder)) {
                    continue;
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warn("Failed to calculate condition for {}", (Object)cleanedPlaceholder, (Object)e);
                replacement = placeholder;
            }
            result.append(text, lastEnd, matcher.start()).append(replacement);
            lastEnd = matcher.end();
        } while (matcher.find());
        result.append(text.substring(lastEnd));
        return result.toString();
    }

    @NotNull
    public String stripVelocitabRelPlaceholders(@NotNull String text) {
        Matcher matcher = VELOCITAB_REL_PLACEHOLDERS.matcher(text);
        StringBuilder result = new StringBuilder();
        int lastEnd = 0;
        while (matcher.find()) {
            String placeholder = matcher.group();
            String cleanedPlaceholder = placeholder.substring(1, placeholder.length() - 1);
            try {
                String replacement = "";
                result.append(text, lastEnd, matcher.start()).append(replacement);
                lastEnd = matcher.end();
            }
            catch (Exception e) {
                this.plugin.getLogger().warn("Failed to calculate condition for {}", (Object)cleanedPlaceholder, (Object)e);
            }
        }
        result.append(text.substring(lastEnd));
        return result.toString();
    }

    @Generated
    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

