/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.config;

import com.google.common.collect.Lists;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.annotations.Nullable;
import net.william278.velocitab.placeholder.PlaceholderReplacement;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.tab.Nametag;
import net.william278.velocitab.util.StringUtil;
import org.slf4j.event.Level;

public record Group(String name, List<String> headers, List<String> footers, String format, Nametag nametag, Set<String> servers, List<String> sortingPlaceholders, Map<String, List<PlaceholderReplacement>> placeholderReplacements, boolean collisions, int headerFooterUpdateRate, int formatUpdateRate, int nametagUpdateRate, int placeholderUpdateRate, boolean onlyListPlayersInSameServer) {
    @NotNull
    public String getHeader(int index) {
        return this.headers.isEmpty() ? "" : StringUtil.unescapeJava(this.headers.get(Math.max(0, Math.min(index, this.headers.size() - 1))));
    }

    @NotNull
    public String getFooter(int index) {
        return this.footers.isEmpty() ? "" : StringUtil.unescapeJava(this.footers.get(Math.max(0, Math.min(index, this.footers.size() - 1))));
    }

    public boolean containsServer(@NotNull Velocitab plugin, @NotNull String serverName) {
        return this.registeredServers(plugin).stream().anyMatch(registeredServer -> registeredServer.getServerInfo().getName().equalsIgnoreCase(serverName));
    }

    @NotNull
    public List<RegisteredServer> registeredServers(@NotNull Velocitab plugin) {
        return this.registeredServers(plugin, true);
    }

    @NotNull
    public List<RegisteredServer> registeredServers(@NotNull Velocitab plugin, boolean includeAllPlayers) {
        if (includeAllPlayers && plugin.getSettings().isShowAllPlayersFromAllGroups() || this.isDefault(plugin) && plugin.getSettings().isFallbackEnabled()) {
            return Lists.newArrayList((Iterable)plugin.getServer().getAllServers());
        }
        return this.getRegexServers(plugin);
    }

    @NotNull
    private List<RegisteredServer> getRegexServers(@NotNull Velocitab plugin) {
        Optional<List<RegisteredServer>> cachedServers = plugin.getTabGroupsManager().getCachedServers(this);
        if (cachedServers.isPresent()) {
            return cachedServers.get();
        }
        ArrayList totalServers = Lists.newArrayList();
        for (String server : this.servers) {
            try {
                Matcher matcher = Pattern.compile(server, 2).matcher("");
                plugin.getServer().getAllServers().stream().filter(registeredServer -> matcher.reset(registeredServer.getServerInfo().getName()).matches()).forEach(totalServers::add);
            }
            catch (PatternSyntaxException exception) {
                plugin.log(Level.WARN, "Invalid regex pattern " + server + " in group " + this.name, exception);
                plugin.getServer().getServer(server).ifPresent(totalServers::add);
            }
        }
        plugin.getTabGroupsManager().cacheServers(this, totalServers);
        return totalServers;
    }

    public boolean isDefault(@NotNull Velocitab plugin) {
        return this.name.equals(plugin.getSettings().getFallbackGroup());
    }

    @NotNull
    public List<Player> getPlayers(@NotNull Velocitab plugin) {
        ArrayList players = Lists.newArrayList();
        for (RegisteredServer server : this.registeredServers(plugin)) {
            players.addAll(server.getPlayersConnected());
        }
        return players;
    }

    @NotNull
    public List<Player> getPlayers(@NotNull Velocitab plugin, @NotNull TabPlayer tabPlayer) {
        if (plugin.getSettings().isShowAllPlayersFromAllGroups()) {
            return Lists.newArrayList((Iterable)plugin.getServer().getAllPlayers());
        }
        if (this.onlyListPlayersInSameServer) {
            return tabPlayer.getPlayer().getCurrentServer().map(s -> Lists.newArrayList((Iterable)s.getServer().getPlayersConnected())).orElseGet(Lists::newArrayList);
        }
        return this.getPlayers(plugin);
    }

    public List<TabPlayer> getTabPlayers(@NotNull Velocitab plugin) {
        if (plugin.getSettings().isShowAllPlayersFromAllGroups()) {
            return plugin.getTabList().getPlayers().values().stream().filter(TabPlayer::isLoaded).collect(Collectors.toList());
        }
        return plugin.getTabList().getPlayers().values().stream().filter(tabPlayer -> tabPlayer.isLoaded() && tabPlayer.getGroup().equals(this)).collect(Collectors.toList());
    }

    @NotNull
    public List<TabPlayer> getTabPlayers(@NotNull Velocitab plugin, @NotNull TabPlayer tabPlayer) {
        return this.getTabPlayers(plugin, tabPlayer, false);
    }

    @NotNull
    public List<TabPlayer> getTabPlayers(@NotNull Velocitab plugin, @NotNull TabPlayer tabPlayer, boolean force) {
        if (plugin.getSettings().isShowAllPlayersFromAllGroups()) {
            return plugin.getTabList().getPlayers().values().stream().filter(TabPlayer::isLoaded).collect(Collectors.toList());
        }
        if (this.onlyListPlayersInSameServer) {
            return plugin.getTabList().getPlayers().values().stream().filter(player -> (player.isLoaded() || force) && player.getGroup().equals(this) && player.getServerName().equals(tabPlayer.getServerName())).collect(Collectors.toList());
        }
        return this.getTabPlayers(plugin);
    }

    @NotNull
    public List<String> getTextsWithPlaceholders(@NotNull Velocitab plugin) {
        ArrayList texts = Lists.newArrayList();
        texts.add(this.name);
        texts.add(this.format);
        texts.addAll(this.headers);
        texts.addAll(this.footers);
        texts.add(this.nametag.prefix());
        texts.add(this.nametag.suffix());
        texts.addAll(this.sortingPlaceholders);
        if (plugin.getLuckPermsHook().isEmpty()) {
            texts.add("%luckperms_meta_weight%");
        }
        return texts;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof Group)) {
            return false;
        }
        Group group = (Group)obj;
        return this.name.equals(group.name);
    }
}

