/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.mvel2.optimizers.impl.refl.nodes;

import java.lang.reflect.Method;
import net.william278.velocitab.libraries.mvel2.DataConversion;
import net.william278.velocitab.libraries.mvel2.compiler.AccessorNode;
import net.william278.velocitab.libraries.mvel2.integration.VariableResolverFactory;
import net.william278.velocitab.libraries.mvel2.util.ParseTools;
import net.william278.velocitab.libraries.mvel2.util.PropertyTools;

public class SetterAccessor
implements AccessorNode {
    private AccessorNode nextNode;
    private final Method method;
    private Class<?> targetType;
    private boolean primitive;
    private boolean coercionRequired = false;
    public static final Object[] EMPTY = new Object[0];

    @Override
    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        boolean attemptedCoercion = this.coercionRequired;
        try {
            if (this.coercionRequired) {
                return this.method.invoke(ctx, DataConversion.convert(value, this.targetType));
            }
            return this.method.invoke(ctx, value == null && this.primitive ? PropertyTools.getPrimitiveInitialValue(this.targetType) : value);
        }
        catch (IllegalArgumentException e) {
            Method o;
            if (ctx != null && this.method.getDeclaringClass() != ctx.getClass() && (o = ParseTools.getBestCandidate(EMPTY, this.method.getName(), ctx.getClass(), ctx.getClass().getMethods(), true)) != null) {
                return this.executeOverrideTarget(o, ctx, value);
            }
            if (!attemptedCoercion) {
                this.coercionRequired = true;
                return this.setValue(ctx, elCtx, variableFactory, value);
            }
            throw new RuntimeException("unable to bind property", e);
        }
        catch (Exception e) {
            throw new RuntimeException("error calling method: " + this.method.getDeclaringClass().getName() + "." + this.method.getName(), e);
        }
    }

    @Override
    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        return null;
    }

    public SetterAccessor(Method method) {
        this.method = method;
        assert (method != null);
        this.targetType = method.getParameterTypes()[0];
        this.primitive = this.targetType.isPrimitive();
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    @Override
    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    public String toString() {
        return this.method.getDeclaringClass().getName() + "." + this.method.getName();
    }

    @Override
    public Class getKnownEgressType() {
        return this.method.getReturnType();
    }

    private Object executeOverrideTarget(Method o, Object ctx, Object value) {
        try {
            return o.invoke(ctx, DataConversion.convert(value, this.targetType));
        }
        catch (Exception e2) {
            throw new RuntimeException("unable to invoke method", e2);
        }
    }
}

