/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.providers;

import com.google.common.collect.Lists;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.hook.Hook;
import net.william278.velocitab.libraries.annotations.Blocking;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.toilet.DumpOptions;
import net.william278.velocitab.libraries.toilet.Toilet;
import net.william278.velocitab.libraries.toilet.dump.DumpUser;
import net.william278.velocitab.libraries.toilet.dump.ExtraFile;
import net.william278.velocitab.libraries.toilet.dump.PluginInfo;
import net.william278.velocitab.libraries.toilet.dump.PluginStatus;
import net.william278.velocitab.libraries.toilet.dump.ProjectMeta;
import net.william278.velocitab.libraries.toilet.velocity.VelocityToilet;
import net.william278.velocitab.util.DebugSystem;

public interface DumpProvider {
    @NotNull
    public static final PluginInfo.Label VANISH_INCOMPATIBLE = new PluginInfo.Label("Vanish Incompatible", "#bd3b01", "This plugin is not compatible with Velocitab as the developer has not added support for it. Vanished users will continue to appear in TAB.");
    @NotNull
    public static final Map<String, PluginInfo.Label> INCOMPATIBLE_PLUGINS = Map.ofEntries(Map.entry("tab", PluginInfo.INCOMPATIBLE_LABEL));
    @NotNull
    public static final List<Integer> COLORS = Arrays.asList(Color.RED.getRGB(), Color.GREEN.getRGB(), Color.BLUE.getRGB(), Color.YELLOW.getRGB(), Color.ORANGE.getRGB(), Color.PINK.getRGB(), Color.CYAN.getRGB(), Color.MAGENTA.getRGB(), Color.GRAY.getRGB(), Color.LIGHT_GRAY.getRGB(), Color.DARK_GRAY.getRGB(), Color.BLACK.getRGB(), Color.WHITE.getRGB(), new Color(255, 165, 0).getRGB(), new Color(128, 0, 128).getRGB(), new Color(0, 128, 128).getRGB(), new Color(128, 128, 0).getRGB(), new Color(255, 192, 203).getRGB(), new Color(0, 255, 255).getRGB(), new Color(255, 215, 0).getRGB());
    @NotNull
    public static final String BYTEBIN_URL = "https://bytebin.lucko.me";
    @NotNull
    public static final String VIEWER_URL = "https://william278.net/dump";

    @NotNull
    public Toilet getToilet();

    public void setToilet(@NotNull Toilet var1);

    default public void initializeToilet() {
        VelocityToilet toilet = VelocityToilet.create(this.getDumpOptions(), this.getPlugin().getServer());
        this.setToilet(toilet);
    }

    @NotNull
    @Blocking
    default public String createDump(@NotNull CommandSource u) {
        DumpUser dumpUser;
        Toilet toilet = this.getToilet();
        PluginStatus pluginStatus = this.getPluginStatus();
        if (u instanceof Player) {
            Player o = (Player)u;
            dumpUser = new DumpUser(o.getUsername(), o.getUniqueId());
        } else {
            dumpUser = null;
        }
        return toilet.dump(pluginStatus, dumpUser, this.getDebugLog()).toString();
    }

    @NotNull
    default public DumpOptions getDumpOptions() {
        return DumpOptions.builder().bytebinUrl(BYTEBIN_URL).viewerUrl(VIEWER_URL).projectMeta(ProjectMeta.builder().id("velocitab").name("Velocitab").version(this.getPlugin().getVersion().toString()).md5("unknown").author("William278, AlexDev03").sourceCode("https://github.com/WiIIiam278/Velocitab").website("https://william278.net/project/velocitab").support("https://discord.gg/tVYhJfyDWG").build()).compatibilityRules(this.getCompatibilityRules()).fileInclusionRules(this.getFileInclusionRules()).build();
    }

    @NotNull
    private ExtraFile getDebugLog() {
        return new ExtraFile("debug-log", "Internal Debugger", DebugSystem.getLogsAsString());
    }

    @NotNull
    private List<DumpOptions.FileInclusionRule> getFileInclusionRules() {
        List<File> tabGroupsFiles = this.getPlugin().getTabGroupsManager().getGroupsFiles();
        ArrayList rules = Lists.newArrayList();
        rules.add(DumpOptions.FileInclusionRule.configFile(this.getPlugin().getConfigDirectory().resolve("config.yml").toFile().getAbsolutePath(), "Config File"));
        for (File tabGroupsFile : tabGroupsFiles) {
            boolean isDefault = this.getPlugin().getTabGroupsManager().isDefaultFile(tabGroupsFile);
            String name = "Tab Groups File (" + (isDefault ? "default" : tabGroupsFile.getName()) + ")";
            DumpOptions.FileInclusionRule rule = DumpOptions.FileInclusionRule.configFile(tabGroupsFile.getAbsolutePath(), name);
            if (isDefault) {
                rules.add(1, rule);
                continue;
            }
            rules.add(rule);
        }
        return rules;
    }

    @NotNull
    private List<DumpOptions.CompatibilityRule> getCompatibilityRules() {
        return INCOMPATIBLE_PLUGINS.entrySet().stream().filter(e -> this.getPlugin().getServer().getPluginManager().getPlugin((String)e.getKey()).isPresent()).map(e -> DumpOptions.CompatibilityRule.builder().resourceName((String)e.getKey()).labelToApply((PluginInfo.Label)e.getValue()).build()).toList();
    }

    @NotNull
    @Blocking
    private PluginStatus getPluginStatus() {
        return PluginStatus.builder().blocks(List.of(this.getSystemStatus(), this.getServersInEachGroup(), this.getPlayersInEachGroup(), this.getHookStatus())).build();
    }

    @NotNull
    private PluginStatus.MapStatusBlock getSystemStatus() {
        return new PluginStatus.MapStatusBlock(Map.ofEntries(Map.entry("RemoveNameTags", Boolean.toString(this.getPlugin().getSettings().isRemoveNametags())), Map.entry("DisableHeaderFooterIfEmpty", Boolean.toString(this.getPlugin().getSettings().isDisableHeaderFooterIfEmpty())), Map.entry("Formatter", this.getPlugin().getSettings().getFormatter().name()), Map.entry("FallbackGroupEnabled", Boolean.toString(this.getPlugin().getSettings().isFallbackEnabled())), Map.entry("FallbackGroup", this.getPlugin().getSettings().getFallbackGroup()), Map.entry("PapiProxyBridge", Boolean.toString(this.getPlugin().getSettings().isEnablePapiHook())), Map.entry("PapiCacheTime", Long.toString(this.getPlugin().getSettings().getPapiCacheTime())), Map.entry("MiniPlaceholders", Boolean.toString(this.getPlugin().getSettings().isEnableMiniPlaceholdersHook())), Map.entry("SendScoreboardPackets", Boolean.toString(this.getPlugin().getSettings().isSendScoreboardPackets())), Map.entry("SortPlayers", Boolean.toString(this.getPlugin().getSettings().isSortPlayers())), Map.entry("RelationalPlaceholders", Boolean.toString(this.getPlugin().getSettings().isEnableRelationalPlaceholders())), Map.entry("VanishIntegration", this.getPlugin().getVanishManager().getIntegration().getClass().getName())), "Plugin Status", "fa6-solid:wrench");
    }

    @NotNull
    private PluginStatus.ListStatusBlock getHookStatus() {
        return new PluginStatus.ListStatusBlock(this.getPlugin().getHooks().stream().map(Hook::getName).toList(), "Loaded Hooks", "fa6-solid:plug");
    }

    @NotNull
    private PluginStatus.ChartStatusBlock getPlayersInEachGroup() {
        AtomicInteger colorIndex = new AtomicInteger(0);
        Map<PluginStatus.ChartKey, Integer> players = this.getPlugin().getTabGroupsManager().getGroups().stream().collect(Collectors.toMap(g -> new PluginStatus.ChartKey(g.name(), "fa6-solid:server", COLORS.get(colorIndex.getAndIncrement() % COLORS.size())), group -> group.getTabPlayers(this.getPlugin()).size()));
        return new PluginStatus.ChartStatusBlock(players, PluginStatus.ChartType.PIE, "Online players per group", "fa6-solid:users");
    }

    @NotNull
    private PluginStatus.MapStatusBlock getServersInEachGroup() {
        Map servers = this.getPlugin().getTabGroupsManager().getGroups().stream().sorted(this.getGroupComparator(this.getPlugin()).reversed()).collect(Collectors.toMap(Group::name, g -> g.registeredServers(this.getPlugin()).stream().map(RegisteredServer::getServerInfo).map(ServerInfo::getName).collect(Collectors.joining(", ")), (e1, e2) -> e1, LinkedHashMap::new));
        return new PluginStatus.MapStatusBlock(servers, "Servers in each group", "fa6-solid:network-wired");
    }

    default public Comparator<Group> getGroupComparator(@NotNull Velocitab plugin) {
        return (g1, g2) -> {
            int servers2;
            int servers1 = g1.registeredServers(plugin).size();
            if (servers1 != (servers2 = g2.registeredServers(plugin).size())) {
                return servers1 - servers2;
            }
            return g1.servers().size() - g2.servers().size();
        };
    }

    @NotNull
    public Velocitab getPlugin();
}

