/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.config;

import com.google.common.collect.Lists;
import com.velocitypowered.api.util.ServerLink;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.player.TabPlayer;

public record ServerUrl(@NotNull String label, @NotNull String url, @NotNull Set<String> groups) {
    public ServerUrl(@NotNull String label, @NotNull String url) {
        this(label, url, Set.of("*"));
    }

    @NotNull
    ServerLink getServerLink(@NotNull Velocitab plugin, @NotNull TabPlayer player) {
        return this.getBuiltInLabel().map(type -> ServerLink.serverLink((ServerLink.Type)type, (String)this.url())).orElseGet(() -> {
            String replaced = plugin.getPlaceholderManager().applyPlaceholders(player, this.label());
            Component formatted = plugin.getFormatter().format(replaced, player, plugin);
            return ServerLink.serverLink((Component)formatted, (String)this.url());
        });
    }

    @NotNull
    public static List<ServerLink> resolve(@NotNull Velocitab plugin, @NotNull TabPlayer player, @NotNull List<ServerUrl> urls) {
        ArrayList serverLinks = Lists.newArrayList();
        for (ServerUrl url : urls) {
            serverLinks.add(url.getServerLink(plugin, player));
        }
        return serverLinks;
    }

    private Optional<ServerLink.Type> getBuiltInLabel() {
        String label = this.label().replaceAll(" ", "_").toUpperCase(Locale.ENGLISH);
        return Arrays.stream(ServerLink.Type.values()).filter(type -> type.name().equals(label)).findFirst();
    }

    void validate() throws IllegalStateException {
        if (this.label().isEmpty()) {
            throw new IllegalStateException("Server URL label cannot be empty");
        }
        if (this.url().isEmpty()) {
            throw new IllegalStateException("Server URL cannot be empty");
        }
        if (this.groups().isEmpty()) {
            throw new IllegalStateException("Server URL must have at least one group, or '*' to show on all groups");
        }
        try {
            URI.create(this.url());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Server URL is not a valid URI");
        }
    }
}

