/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.sorting;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import lombok.Generated;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.annotations.Nullable;

public class SortedSet {
    private final ConcurrentSkipListSet<String> sortedTeams;
    private final Map<String, Integer> positionMap;

    public SortedSet(@NotNull Comparator<String> comparator) {
        this.sortedTeams = new ConcurrentSkipListSet<String>(comparator);
        this.positionMap = Maps.newConcurrentMap();
    }

    public boolean addTeam(@NotNull String teamName) {
        if (!this.sortedTeams.add(teamName)) {
            return false;
        }
        this.updatePositions(teamName);
        return true;
    }

    public boolean removeTeam(@NotNull String teamName) {
        if (!this.sortedTeams.remove(teamName)) {
            return false;
        }
        this.updatePositions(null);
        return true;
    }

    private void updatePositions(@Nullable String newTeam) {
        if (newTeam != null) {
            int newPosition = this.sortedTeams.headSet((Object)newTeam).size();
            this.positionMap.put(newTeam, newPosition);
            this.sortedTeams.tailSet((Object)newTeam).forEach(team -> this.positionMap.put((String)team, this.sortedTeams.headSet(team).size()));
        } else {
            int index = 0;
            this.positionMap.clear();
            for (String team2 : this.sortedTeams) {
                this.positionMap.put(team2, index++);
            }
        }
    }

    public int getPosition(@NotNull String teamName) {
        return this.positionMap.getOrDefault(teamName, -1);
    }

    @Generated
    public String toString() {
        return "SortedSet(sortedTeams=" + String.valueOf(this.sortedTeams) + ", positionMap=" + String.valueOf(this.positionMap) + ")";
    }
}

