/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.tab;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.util.DebugSystem;
import org.slf4j.event.Level;

public class TaskManager {
    private final Velocitab plugin;
    private final Map<Group, List<ScheduledFuture<?>>> groupTasks;
    private final ScheduledExecutorService processThread;

    public TaskManager(@NotNull Velocitab plugin) {
        this.plugin = plugin;
        this.groupTasks = Maps.newConcurrentMap();
        this.processThread = this.createProcessThread();
    }

    @NotNull
    private ScheduledExecutorService createProcessThread() {
        Thread.UncaughtExceptionHandler handler = (t, e) -> this.plugin.log(Level.ERROR, "Uncaught exception in task manager thread", e);
        return Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, "Velocitab Task Manager");
            thread.setUncaughtExceptionHandler(handler);
            return thread;
        });
    }

    protected void cancelAllTasks() {
        this.groupTasks.values().forEach(c -> c.forEach(t -> t.cancel(true)));
        this.groupTasks.clear();
    }

    public void close() {
        try {
            this.cancelAllTasks();
            this.processThread.shutdownNow();
        }
        catch (Throwable e) {
            this.plugin.getLogger().error("Failed to close task manager", e);
        }
    }

    protected void updatePeriodically(@NotNull Group group) {
        List tasks = this.groupTasks.computeIfAbsent(group, g -> Lists.newArrayList());
        if (group.headerFooterUpdateRate() > 0) {
            ScheduledFuture<?> headerFooterTask = this.processThread.scheduleAtFixedRate(() -> {
                try {
                    long startTime = System.currentTimeMillis();
                    this.plugin.getTabList().updateHeaderFooter(group);
                    long endTime = System.currentTimeMillis();
                    long time = endTime - startTime;
                    if (time > 30L) {
                        DebugSystem.log(DebugSystem.DebugLevel.DEBUG, "Updated header/footer for group {} took {}ms", group.name(), time);
                    }
                }
                catch (Throwable e) {
                    this.plugin.log(Level.ERROR, "Failed to update header/footer for group " + group.name(), e);
                }
            }, 250L, Math.max(200, group.headerFooterUpdateRate()), TimeUnit.MILLISECONDS);
            tasks.add(headerFooterTask);
        }
        if (group.formatUpdateRate() > 0) {
            ScheduledFuture<?> formatTask = this.processThread.scheduleAtFixedRate(() -> {
                try {
                    long startTime = System.currentTimeMillis();
                    this.plugin.getTabList().updateGroupNames(group);
                    long endTime = System.currentTimeMillis();
                    long time = endTime - startTime;
                    if (time > 50L) {
                        DebugSystem.log(DebugSystem.DebugLevel.DEBUG, "Updated format for group {} took {}ms", group.name(), time);
                    }
                }
                catch (Throwable e) {
                    this.plugin.log(Level.ERROR, "Failed to update format for group " + group.name(), e);
                }
            }, 500L, Math.max(200, group.formatUpdateRate()), TimeUnit.MILLISECONDS);
            tasks.add(formatTask);
        }
        if (group.nametagUpdateRate() > 0) {
            ScheduledFuture<?> nametagTask = this.processThread.scheduleAtFixedRate(() -> {
                try {
                    long startTime = System.currentTimeMillis();
                    this.plugin.getTabList().updateSorting(group);
                    long endTime = System.currentTimeMillis();
                    long time = endTime - startTime;
                    if (time > 50L) {
                        DebugSystem.log(DebugSystem.DebugLevel.DEBUG, "Updated nametags/sorting for group {} took {}ms", group.name(), time);
                    }
                }
                catch (Throwable e) {
                    this.plugin.log(Level.ERROR, "Failed to update nametags/sorting for group " + group.name(), e);
                }
            }, 750L, Math.max(200, group.nametagUpdateRate()), TimeUnit.MILLISECONDS);
            tasks.add(nametagTask);
        }
        if (group.placeholderUpdateRate() > 0) {
            ScheduledFuture<?> updateTask = this.processThread.scheduleAtFixedRate(() -> {
                try {
                    long startTime = System.currentTimeMillis();
                    this.updatePlaceholders(group);
                    long endTime = System.currentTimeMillis();
                    long time = endTime - startTime;
                    if (time > 10L) {
                        DebugSystem.log(DebugSystem.DebugLevel.DEBUG, "Updated placeholders for group {} took {}ms", group.name(), time);
                    }
                }
                catch (Throwable e) {
                    this.plugin.log(Level.ERROR, "Failed to update placeholders for group " + group.name(), e);
                }
            }, 1000L, Math.max(200, group.placeholderUpdateRate()), TimeUnit.MILLISECONDS);
            tasks.add(updateTask);
        }
        ScheduledFuture<?> latencyTask = this.processThread.scheduleAtFixedRate(() -> {
            try {
                long startTime = System.currentTimeMillis();
                this.updateLatency(group);
                long endTime = System.currentTimeMillis();
                long time = endTime - startTime;
                if (time > 25L) {
                    DebugSystem.log(DebugSystem.DebugLevel.DEBUG, "Updated latency for group {} took {}ms", group.name(), time);
                }
            }
            catch (Throwable e) {
                this.plugin.log(Level.ERROR, "Failed to update latency for group " + group.name(), e);
            }
        }, 1250L, 5000L, TimeUnit.MILLISECONDS);
        tasks.add(latencyTask);
    }

    private void updatePlaceholders(@NotNull Group group) {
        List<TabPlayer> players = group.getTabPlayers(this.plugin);
        if (players.isEmpty()) {
            return;
        }
        List<String> texts = group.getTextsWithPlaceholders(this.plugin);
        players.forEach(player -> this.plugin.getPlaceholderManager().fetchPlaceholders(player.getPlayer().getUniqueId(), texts, group));
    }

    private void updateLatency(@NotNull Group group) {
        List<TabPlayer> groupPlayers = group.getTabPlayers(this.plugin);
        if (groupPlayers.isEmpty()) {
            return;
        }
        groupPlayers.forEach(player -> {
            int latency = (int)player.getPlayer().getPing();
            groupPlayers.forEach(p -> p.getPlayer().getTabList().getEntry(player.getPlayer().getUniqueId()).ifPresent(entry -> entry.setLatency(Math.max(latency, 0))));
        });
    }

    public void run(@NotNull Runnable runnable) {
        try {
            this.processThread.execute(runnable);
        }
        catch (Throwable e) {
            this.plugin.log(Level.ERROR, "Failed to run task", e);
        }
    }

    public void runDelayed(@NotNull Runnable runnable, long delay, @NotNull TimeUnit timeUnit) {
        try {
            this.processThread.schedule(runnable, delay, timeUnit);
        }
        catch (Throwable e) {
            this.plugin.log(Level.ERROR, "Failed to run delayed task", e);
        }
    }
}

