/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.hook;

import com.velocitypowered.api.proxy.Player;
import io.github.miniplaceholders.api.MiniPlaceholders;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.hook.Hook;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.annotations.Nullable;
import net.william278.velocitab.libraries.expiringmap.ExpiringMap;

public class MiniPlaceholdersHook
extends Hook {
    private final Map<UUID, TagResolver> cache = ExpiringMap.builder().expiration(5L, TimeUnit.MINUTES).build();

    public MiniPlaceholdersHook(@NotNull Velocitab plugin) {
        super(plugin, "MiniPlaceholders");
    }

    @NotNull
    private TagResolver getResolver(@NotNull Player player, @Nullable Player viewer) {
        if (viewer == null) {
            return this.cache.computeIfAbsent(player.getUniqueId(), u -> MiniPlaceholders.getAudienceGlobalPlaceholders((Audience)player));
        }
        UUID merged = new UUID(player.getUniqueId().getMostSignificantBits(), viewer.getUniqueId().getMostSignificantBits());
        return this.cache.computeIfAbsent(merged, u -> MiniPlaceholders.getRelationalGlobalPlaceholders((Audience)player, (Audience)viewer));
    }

    @NotNull
    public Component format(@NotNull String text, @NotNull Player player, @Nullable Player viewer) {
        if (viewer == null) {
            return MiniMessage.miniMessage().deserialize(text, this.getResolver(player, null));
        }
        return MiniMessage.miniMessage().deserialize(text, this.getResolver(player, viewer));
    }
}

