/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.mvel2.optimizers.impl.asm;

import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.william278.velocitab.libraries.mvel2.CompileException;
import net.william278.velocitab.libraries.mvel2.DataConversion;
import net.william278.velocitab.libraries.mvel2.MVEL;
import net.william278.velocitab.libraries.mvel2.OptimizationFailure;
import net.william278.velocitab.libraries.mvel2.ParserContext;
import net.william278.velocitab.libraries.mvel2.PropertyAccessException;
import net.william278.velocitab.libraries.mvel2.asm.ClassWriter;
import net.william278.velocitab.libraries.mvel2.asm.Label;
import net.william278.velocitab.libraries.mvel2.asm.MethodVisitor;
import net.william278.velocitab.libraries.mvel2.asm.Type;
import net.william278.velocitab.libraries.mvel2.ast.FunctionInstance;
import net.william278.velocitab.libraries.mvel2.ast.TypeDescriptor;
import net.william278.velocitab.libraries.mvel2.ast.WithNode;
import net.william278.velocitab.libraries.mvel2.compiler.Accessor;
import net.william278.velocitab.libraries.mvel2.compiler.ExecutableAccessor;
import net.william278.velocitab.libraries.mvel2.compiler.ExecutableLiteral;
import net.william278.velocitab.libraries.mvel2.compiler.ExecutableStatement;
import net.william278.velocitab.libraries.mvel2.compiler.PropertyVerifier;
import net.william278.velocitab.libraries.mvel2.integration.GlobalListenerFactory;
import net.william278.velocitab.libraries.mvel2.integration.PropertyHandler;
import net.william278.velocitab.libraries.mvel2.integration.PropertyHandlerFactory;
import net.william278.velocitab.libraries.mvel2.integration.VariableResolverFactory;
import net.william278.velocitab.libraries.mvel2.optimizers.AbstractOptimizer;
import net.william278.velocitab.libraries.mvel2.optimizers.AccessorOptimizer;
import net.william278.velocitab.libraries.mvel2.optimizers.OptimizationNotSupported;
import net.william278.velocitab.libraries.mvel2.optimizers.impl.asm.ProducesBytecode;
import net.william278.velocitab.libraries.mvel2.optimizers.impl.refl.nodes.Union;
import net.william278.velocitab.libraries.mvel2.util.ArrayTools;
import net.william278.velocitab.libraries.mvel2.util.JITClassLoader;
import net.william278.velocitab.libraries.mvel2.util.MVELClassLoader;
import net.william278.velocitab.libraries.mvel2.util.MethodStub;
import net.william278.velocitab.libraries.mvel2.util.NullType;
import net.william278.velocitab.libraries.mvel2.util.ParseTools;
import net.william278.velocitab.libraries.mvel2.util.PropertyTools;
import net.william278.velocitab.libraries.mvel2.util.ReflectionUtil;
import net.william278.velocitab.libraries.mvel2.util.StringAppender;
import net.william278.velocitab.libraries.mvel2.util.Varargs;

public class ASMAccessorOptimizer
extends AbstractOptimizer
implements AccessorOptimizer {
    private static final String MAP_IMPL = "java/util/HashMap";
    private static String LIST_IMPL;
    private static String NAMESPACE;
    private static final int OPCODES_VERSION;
    private Object ctx;
    private Object thisRef;
    private VariableResolverFactory variableFactory;
    private static final Object[] EMPTYARG;
    private static final Class[] EMPTYCLS;
    private boolean first = true;
    private boolean noinit = false;
    private boolean deferFinish = false;
    private boolean literal = false;
    private boolean propNull = false;
    private boolean methNull = false;
    private String className;
    private ClassWriter cw;
    private MethodVisitor mv;
    private Object val;
    private int stacksize = 1;
    private int maxlocals = 1;
    private long time;
    private ArrayList<ExecutableStatement> compiledInputs;
    private Class ingressType;
    private Class returnType;
    private int compileDepth = 0;
    private StringAppender buildLog;
    private static MVELClassLoader classLoader;
    private static final int ARRAY = 0;
    private static final int LIST = 1;
    private static final int MAP = 2;
    private static final int VAL = 3;

    public ASMAccessorOptimizer() {
        new ClassWriter(1);
    }

    private ASMAccessorOptimizer(ClassWriter cw, MethodVisitor mv, ArrayList<ExecutableStatement> compiledInputs, String className, StringAppender buildLog, int compileDepth) {
        this.cw = cw;
        this.mv = mv;
        this.compiledInputs = compiledInputs;
        this.className = className;
        this.buildLog = buildLog;
        this.compileDepth = compileDepth + 1;
        this.noinit = true;
        this.deferFinish = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initJIT() {
        if (MVEL.isAdvancedDebugging()) {
            this.buildLog = new StringAppender();
        }
        this.cw = new ClassWriter(3);
        Runtime runtime = Runtime.getRuntime();
        synchronized (runtime) {
            this.className = "ASMAccessorImpl_" + String.valueOf(this.cw.hashCode()).replaceAll("\\-", "_") + System.currentTimeMillis() / 10L + (int)(Math.random() * 100.0);
            this.cw.visit(OPCODES_VERSION, 33, this.className, null, "java/lang/Object", new String[]{NAMESPACE + "compiler/Accessor"});
        }
        MethodVisitor m = this.cw.visitMethod(1, "<init>", "()V", null, null);
        m.visitCode();
        m.visitVarInsn(25, 0);
        m.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        m.visitInsn(177);
        m.visitMaxs(1, 1);
        m.visitEnd();
        this.mv = this.cw.visitMethod(1, "getValue", "(Ljava/lang/Object;Ljava/lang/Object;L" + NAMESPACE + "integration/VariableResolverFactory;)Ljava/lang/Object;", null, null);
        this.mv.visitCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initJIT2() {
        if (MVEL.isAdvancedDebugging()) {
            this.buildLog = new StringAppender();
        }
        this.cw = new ClassWriter(3);
        Runtime runtime = Runtime.getRuntime();
        synchronized (runtime) {
            this.className = "ASMAccessorImpl_" + String.valueOf(this.cw.hashCode()).replaceAll("\\-", "_") + System.currentTimeMillis() / 10L + (int)(Math.random() * 100.0);
            this.cw.visit(OPCODES_VERSION, 33, this.className, null, "java/lang/Object", new String[]{NAMESPACE + "compiler/Accessor"});
        }
        MethodVisitor m = this.cw.visitMethod(1, "<init>", "()V", null, null);
        m.visitCode();
        m.visitVarInsn(25, 0);
        m.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        m.visitInsn(177);
        m.visitMaxs(1, 1);
        m.visitEnd();
        this.mv = this.cw.visitMethod(1, "setValue", "(Ljava/lang/Object;Ljava/lang/Object;L" + NAMESPACE + "integration/VariableResolverFactory;Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        this.mv.visitCode();
    }

    @Override
    public Accessor optimizeAccessor(ParserContext pCtx, char[] property, int start, int offset, Object staticContext, Object thisRef, VariableResolverFactory factory, boolean root, Class ingressType) {
        this.time = System.currentTimeMillis();
        if (this.compiledInputs == null) {
            this.compiledInputs = new ArrayList();
        }
        this.start = this.cursor = start;
        this.end = start + offset;
        this.length = this.end - this.start;
        this.first = true;
        this.val = null;
        this.pCtx = pCtx;
        this.expr = property;
        this.ctx = staticContext;
        this.thisRef = thisRef;
        this.variableFactory = factory;
        this.ingressType = ingressType;
        if (!this.noinit) {
            this._initJIT();
        }
        return this.compileAccessor();
    }

    @Override
    public Accessor optimizeSetAccessor(ParserContext pCtx, char[] property, int start, int offset, Object ctx, Object thisRef, VariableResolverFactory factory, boolean rootThisRef, Object value, Class ingressType) {
        block92: {
            this.expr = property;
            this.start = this.cursor = start;
            this.end = start + offset;
            this.length = start + offset;
            this.first = true;
            this.ingressType = ingressType;
            this.compiledInputs = new ArrayList();
            this.pCtx = pCtx;
            this.ctx = ctx;
            this.thisRef = thisRef;
            this.variableFactory = factory;
            char[] root = null;
            this.pCtx = pCtx;
            PropertyVerifier verifier = new PropertyVerifier(property, this.pCtx);
            int split = this.findLastUnion();
            if (split != -1) {
                root = ParseTools.subset(property, 0, split);
            }
            Object rootAccessor = null;
            this._initJIT2();
            if (root != null) {
                int _length = this.length;
                int _end = this.end;
                char[] _expr = this.expr;
                this.expr = root;
                this.length = this.end = root.length;
                this.deferFinish = true;
                this.noinit = true;
                this.compileAccessor();
                ctx = this.val;
                this.expr = _expr;
                this.cursor = start + root.length + 1;
                this.length = _length - root.length - 1;
                this.end = this.cursor + this.length;
            } else {
                assert (this.debug("ALOAD 1"));
                this.mv.visitVarInsn(25, 1);
            }
            try {
                this.skipWhitespace();
                if (this.collection) {
                    int st = this.cursor;
                    this.whiteSpaceSkip();
                    if (st == this.end) {
                        throw new PropertyAccessException("unterminated '['", this.expr, start, pCtx);
                    }
                    if (this.scanTo(']')) {
                        throw new PropertyAccessException("unterminated '['", this.expr, start, pCtx);
                    }
                    String ex = new String(this.expr, st, this.cursor - st).trim();
                    assert (this.debug("CHECKCAST " + ctx.getClass().getName()));
                    this.mv.visitTypeInsn(192, Type.getInternalName(ctx.getClass()));
                    if (ctx instanceof Map) {
                        if (MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING && PropertyHandlerFactory.hasPropertyHandler(Map.class)) {
                            this.propHandlerByteCodePut(ex, ctx, Map.class, value);
                        } else {
                            this.returnType = verifier.analyze();
                            ((Map)ctx).put(MVEL.eval(ex, ctx, this.variableFactory), DataConversion.convert(value, this.returnType));
                            this.writeLiteralOrSubexpression(ParseTools.subCompileExpression(ex.toCharArray(), pCtx));
                            assert (this.debug("ALOAD 4"));
                            this.mv.visitVarInsn(25, 4);
                            if (value != null && this.returnType != value.getClass()) {
                                this.dataConversion(this.returnType);
                                this.checkcast(this.returnType);
                            }
                            assert (this.debug("INVOKEINTERFACE Map.put"));
                            this.mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                            assert (this.debug("POP"));
                            this.mv.visitInsn(87);
                            assert (this.debug("ALOAD 4"));
                            this.mv.visitVarInsn(25, 4);
                        }
                    } else if (ctx instanceof List) {
                        if (MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING && PropertyHandlerFactory.hasPropertyHandler(List.class)) {
                            this.propHandlerByteCodePut(ex, ctx, List.class, value);
                        } else {
                            this.returnType = verifier.analyze();
                            ((List)ctx).set(MVEL.eval(ex, ctx, this.variableFactory, Integer.class), DataConversion.convert(value, this.returnType));
                            this.writeLiteralOrSubexpression(ParseTools.subCompileExpression(ex.toCharArray(), pCtx));
                            this.unwrapPrimitive(Integer.TYPE);
                            assert (this.debug("ALOAD 4"));
                            this.mv.visitVarInsn(25, 4);
                            if (value != null && !value.getClass().isAssignableFrom(this.returnType)) {
                                this.dataConversion(this.returnType);
                                this.checkcast(this.returnType);
                            }
                            assert (this.debug("INVOKEINTERFACE List.set"));
                            this.mv.visitMethodInsn(185, "java/util/List", "set", "(ILjava/lang/Object;)Ljava/lang/Object;");
                            assert (this.debug("ALOAD 4"));
                            this.mv.visitVarInsn(25, 4);
                        }
                    } else if (MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING && PropertyHandlerFactory.hasPropertyHandler(ctx.getClass())) {
                        this.propHandlerByteCodePut(ex, ctx, ctx.getClass(), value);
                    } else if (ctx.getClass().isArray()) {
                        if (MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING && PropertyHandlerFactory.hasPropertyHandler(Array.class)) {
                            this.propHandlerByteCodePut(ex, ctx, Array.class, value);
                        } else {
                            Class type = ParseTools.getBaseComponentType(ctx.getClass());
                            Object idx = MVEL.eval(ex, ctx, this.variableFactory);
                            this.writeLiteralOrSubexpression(ParseTools.subCompileExpression(ex.toCharArray(), pCtx), Integer.TYPE);
                            if (!(idx instanceof Integer)) {
                                this.dataConversion(Integer.class);
                                idx = DataConversion.convert(idx, Integer.class);
                                this.unwrapPrimitive(Integer.TYPE);
                            }
                            assert (this.debug("ALOAD 4"));
                            this.mv.visitVarInsn(25, 4);
                            if (type.isPrimitive()) {
                                this.unwrapPrimitive(type);
                            } else if (!type.equals(value.getClass())) {
                                this.dataConversion(type);
                            }
                            this.arrayStore(type);
                            Array.set(ctx, (Integer)idx, DataConversion.convert(value, type));
                            assert (this.debug("ALOAD 4"));
                            this.mv.visitVarInsn(25, 4);
                        }
                    } else {
                        throw new PropertyAccessException("cannot bind to collection property: " + new String(this.expr) + ": not a recognized collection type: " + ctx.getClass(), this.expr, start, pCtx);
                    }
                    this.deferFinish = false;
                    this.noinit = false;
                    this._finishJIT();
                    try {
                        this.deferFinish = false;
                        return this._initializeAccessor();
                    }
                    catch (Exception e) {
                        throw new CompileException("could not generate accessor", this.expr, start, e);
                    }
                }
                String tk = new String(this.expr, this.cursor, this.end - this.cursor);
                Member member = PropertyTools.getFieldOrWriteAccessor(ctx.getClass(), tk, value == null ? null : ingressType);
                if (GlobalListenerFactory.hasSetListeners()) {
                    this.mv.visitVarInsn(25, 1);
                    this.mv.visitLdcInsn(tk);
                    this.mv.visitVarInsn(25, 3);
                    this.mv.visitVarInsn(25, 4);
                    this.mv.visitMethodInsn(184, NAMESPACE + "integration/GlobalListenerFactory", "notifySetListeners", "(Ljava/lang/Object;Ljava/lang/String;L" + NAMESPACE + "integration/VariableResolverFactory;Ljava/lang/Object;)V");
                    GlobalListenerFactory.notifySetListeners(ctx, tk, this.variableFactory, value);
                }
                if (member instanceof Field) {
                    this.checkcast(ctx.getClass());
                    Field fld = (Field)member;
                    Label jmp = null;
                    Label jmp2 = new Label();
                    if (fld.getType().isPrimitive()) {
                        assert (this.debug("ASTORE 5"));
                        this.mv.visitVarInsn(58, 5);
                        assert (this.debug("ALOAD 4"));
                        this.mv.visitVarInsn(25, 4);
                        if (value == null) {
                            value = PropertyTools.getPrimitiveInitialValue(fld.getType());
                        }
                        jmp = new Label();
                        assert (this.debug("IFNOTNULL jmp"));
                        this.mv.visitJumpInsn(199, jmp);
                        assert (this.debug("ALOAD 5"));
                        this.mv.visitVarInsn(25, 5);
                        assert (this.debug("ICONST_0"));
                        this.mv.visitInsn(3);
                        assert (this.debug("PUTFIELD " + Type.getInternalName(fld.getDeclaringClass()) + "." + tk));
                        this.mv.visitFieldInsn(181, Type.getInternalName(fld.getDeclaringClass()), tk, Type.getDescriptor(fld.getType()));
                        assert (this.debug("GOTO jmp2"));
                        this.mv.visitJumpInsn(167, jmp2);
                        assert (this.debug("jmp:"));
                        this.mv.visitLabel(jmp);
                        assert (this.debug("ALOAD 5"));
                        this.mv.visitVarInsn(25, 5);
                        assert (this.debug("ALOAD 4"));
                        this.mv.visitVarInsn(25, 4);
                        this.unwrapPrimitive(fld.getType());
                    } else {
                        assert (this.debug("ALOAD 4"));
                        this.mv.visitVarInsn(25, 4);
                        this.checkcast(fld.getType());
                    }
                    if (jmp == null && value != null && !fld.getType().isAssignableFrom(value.getClass())) {
                        if (!DataConversion.canConvert(fld.getType(), value.getClass())) {
                            throw new CompileException("cannot convert type: " + value.getClass() + ": to " + fld.getType(), this.expr, start);
                        }
                        this.dataConversion(fld.getType());
                        fld.set(ctx, DataConversion.convert(value, fld.getType()));
                    } else {
                        fld.set(ctx, value);
                    }
                    assert (this.debug("PUTFIELD " + Type.getInternalName(fld.getDeclaringClass()) + "." + tk));
                    this.mv.visitFieldInsn(181, Type.getInternalName(fld.getDeclaringClass()), tk, Type.getDescriptor(fld.getType()));
                    assert (this.debug("jmp2:"));
                    this.mv.visitLabel(jmp2);
                    assert (this.debug("ALOAD 4"));
                    this.mv.visitVarInsn(25, 4);
                    break block92;
                }
                if (member != null) {
                    assert (this.debug("CHECKCAST " + Type.getInternalName(ctx.getClass())));
                    this.mv.visitTypeInsn(192, Type.getInternalName(ctx.getClass()));
                    Method meth = (Method)member;
                    assert (this.debug("ALOAD 4"));
                    this.mv.visitVarInsn(25, 4);
                    Class<?> targetType = meth.getParameterTypes()[0];
                    Label jmp2 = new Label();
                    if (value != null && !targetType.isAssignableFrom(value.getClass())) {
                        if (!DataConversion.canConvert(targetType, value.getClass())) {
                            throw new CompileException("cannot convert type: " + value.getClass() + ": to " + meth.getParameterTypes()[0], this.expr, start);
                        }
                        this.dataConversion(this.getWrapperClass(targetType));
                        if (targetType.isPrimitive()) {
                            this.unwrapPrimitive(targetType);
                        } else {
                            this.checkcast(targetType);
                        }
                        meth.invoke(ctx, DataConversion.convert(value, meth.getParameterTypes()[0]));
                    } else {
                        if (targetType.isPrimitive()) {
                            if (value == null) {
                                value = PropertyTools.getPrimitiveInitialValue(targetType);
                            }
                            Label jmp = new Label();
                            assert (this.debug("IFNOTNULL jmp"));
                            this.mv.visitJumpInsn(199, jmp);
                            assert (this.debug("ICONST_0"));
                            this.mv.visitInsn(3);
                            assert (this.debug("INVOKEVIRTUAL " + Type.getInternalName(meth.getDeclaringClass()) + "." + meth.getName()));
                            this.mv.visitMethodInsn(182, Type.getInternalName(meth.getDeclaringClass()), meth.getName(), Type.getMethodDescriptor(meth));
                            assert (this.debug("GOTO jmp2"));
                            this.mv.visitJumpInsn(167, jmp2);
                            assert (this.debug("jmp:"));
                            this.mv.visitLabel(jmp);
                            assert (this.debug("ALOAD 4"));
                            this.mv.visitVarInsn(25, 4);
                            this.unwrapPrimitive(targetType);
                        } else {
                            this.checkcast(targetType);
                        }
                        meth.invoke(ctx, value);
                    }
                    assert (this.debug("INVOKEVIRTUAL " + Type.getInternalName(meth.getDeclaringClass()) + "." + meth.getName()));
                    this.mv.visitMethodInsn(182, Type.getInternalName(meth.getDeclaringClass()), meth.getName(), Type.getMethodDescriptor(meth));
                    assert (this.debug("jmp2:"));
                    this.mv.visitLabel(jmp2);
                    assert (this.debug("ALOAD 4"));
                    this.mv.visitVarInsn(25, 4);
                    break block92;
                }
                if (ctx instanceof Map) {
                    assert (this.debug("CHECKCAST " + Type.getInternalName(ctx.getClass())));
                    this.mv.visitTypeInsn(192, Type.getInternalName(ctx.getClass()));
                    assert (this.debug("LDC '" + tk + "'"));
                    this.mv.visitLdcInsn(tk);
                    assert (this.debug("ALOAD 4"));
                    this.mv.visitVarInsn(25, 4);
                    assert (this.debug("INVOKEINTERFACE java/util/Map.put"));
                    this.mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                    assert (this.debug("ALOAD 4"));
                    this.mv.visitVarInsn(25, 4);
                    ((Map)ctx).put(tk, value);
                    break block92;
                }
                throw new PropertyAccessException("could not access property (" + tk + ") in: " + ingressType.getName(), this.expr, start, pCtx);
            }
            catch (InvocationTargetException e) {
                throw new PropertyAccessException("could not access property", this.expr, start, e, pCtx);
            }
            catch (IllegalAccessException e) {
                throw new PropertyAccessException("could not access property", this.expr, start, e, pCtx);
            }
        }
        try {
            this.deferFinish = false;
            this.noinit = false;
            this._finishJIT();
            return this._initializeAccessor();
        }
        catch (Exception e) {
            throw new CompileException("could not generate accessor", this.expr, start, e);
        }
    }

    private void _finishJIT() {
        if (this.deferFinish) {
            return;
        }
        if (this.returnType != null && this.returnType.isPrimitive()) {
            this.wrapPrimitive(this.returnType);
        }
        if (this.returnType == Void.TYPE) {
            assert (this.debug("ACONST_NULL"));
            this.mv.visitInsn(1);
        }
        assert (this.debug("ARETURN"));
        this.mv.visitInsn(176);
        assert (this.debug("\n{METHOD STATS (maxstack=" + this.stacksize + ")}\n"));
        this.dumpAdvancedDebugging();
        this.mv.visitMaxs(this.stacksize, this.maxlocals);
        this.mv.visitEnd();
        this.mv = this.cw.visitMethod(1, "getKnownEgressType", "()Ljava/lang/Class;", null, null);
        this.mv.visitCode();
        this.visitConstantClass(this.returnType);
        this.mv.visitInsn(176);
        this.mv.visitMaxs(1, 1);
        this.mv.visitEnd();
        if (this.propNull) {
            this.cw.visitField(1, "nullPropertyHandler", "L" + NAMESPACE + "integration/PropertyHandler;", null, null).visitEnd();
        }
        if (this.methNull) {
            this.cw.visitField(1, "nullMethodHandler", "L" + NAMESPACE + "integration/PropertyHandler;", null, null).visitEnd();
        }
        this.buildInputs();
        if (this.buildLog != null && this.buildLog.length() != 0 && this.expr != null) {
            this.mv = this.cw.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
            this.mv.visitCode();
            Label l0 = new Label();
            this.mv.visitLabel(l0);
            this.mv.visitLdcInsn(this.buildLog.toString() + "\n\n## { " + new String(this.expr) + " }");
            this.mv.visitInsn(176);
            Label l1 = new Label();
            this.mv.visitLabel(l1);
            this.mv.visitMaxs(1, 1);
            this.mv.visitEnd();
        }
        this.cw.visitEnd();
    }

    private void visitConstantClass(Class<?> clazz) {
        if (clazz == null) {
            clazz = Object.class;
        }
        if (clazz.isPrimitive()) {
            this.mv.visitFieldInsn(178, ReflectionUtil.toNonPrimitiveType(clazz).getName().replace(".", "/"), "TYPE", "Ljava/lang/Class;");
        } else {
            this.mv.visitLdcInsn(Type.getType(clazz));
        }
    }

    private Accessor _initializeAccessor() throws Exception {
        Object o;
        if (this.deferFinish) {
            return null;
        }
        Class cls = this.loadClass(this.className, this.cw.toByteArray());
        assert (this.debug("[MVEL JIT Completed Optimization <<" + (this.expr != null ? new String(this.expr) : "") + ">>]::" + cls + " (time: " + (System.currentTimeMillis() - this.time) + "ms)"));
        try {
            if (this.compiledInputs.size() == 0) {
                o = cls.newInstance();
            } else {
                Class[] parms = new Class[this.compiledInputs.size()];
                for (int i = 0; i < this.compiledInputs.size(); ++i) {
                    parms[i] = ExecutableStatement.class;
                }
                o = cls.getConstructor(parms).newInstance(this.compiledInputs.toArray(new ExecutableStatement[this.compiledInputs.size()]));
            }
            if (this.propNull) {
                cls.getField("nullPropertyHandler").set(o, PropertyHandlerFactory.getNullPropertyHandler());
            }
            if (this.methNull) {
                cls.getField("nullMethodHandler").set(o, PropertyHandlerFactory.getNullMethodHandler());
            }
        }
        catch (VerifyError e) {
            System.out.println("**** COMPILER BUG! REPORT THIS IMMEDIATELY AT http://jira.codehaus.org/browse/MVEL");
            System.out.println("Expression: " + (this.expr == null ? null : new String(this.expr)));
            throw e;
        }
        return (Accessor)o;
    }

    private Accessor compileAccessor() {
        assert (this.debug("<<INITIATE COMPILE>>"));
        Object curr = this.ctx;
        try {
            if (!MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING) {
                while (this.cursor < this.end) {
                    switch (this.nextSubToken()) {
                        case 0: {
                            curr = this.getBeanProperty(curr, this.capture());
                            break;
                        }
                        case 1: {
                            curr = this.getMethod(curr, this.capture());
                            break;
                        }
                        case 2: {
                            curr = this.getCollectionProperty(curr, this.capture());
                            break;
                        }
                        case 3: {
                            curr = this.getWithProperty(curr);
                        }
                    }
                    if (this.fields == -1) {
                        if (curr == null) {
                            if (this.nullSafe) {
                                throw new OptimizationNotSupported();
                            }
                            break;
                        }
                        this.fields = 0;
                    }
                    this.first = false;
                    if (!this.nullSafe || this.cursor >= this.end) continue;
                    assert (this.debug("DUP"));
                    this.mv.visitInsn(89);
                    Label j = new Label();
                    assert (this.debug("IFNONNULL : jump"));
                    this.mv.visitJumpInsn(199, j);
                    assert (this.debug("ARETURN"));
                    this.mv.visitInsn(176);
                    assert (this.debug("LABEL:jump"));
                    this.mv.visitLabel(j);
                }
            } else {
                while (this.cursor < this.end) {
                    switch (this.nextSubToken()) {
                        case 0: {
                            curr = this.getBeanPropertyAO(curr, this.capture());
                            break;
                        }
                        case 1: {
                            curr = this.getMethod(curr, this.capture());
                            break;
                        }
                        case 2: {
                            curr = this.getCollectionPropertyAO(curr, this.capture());
                            break;
                        }
                        case 3: {
                            curr = this.getWithProperty(curr);
                        }
                    }
                    if (this.fields == -1) {
                        if (curr == null) {
                            if (this.nullSafe) {
                                throw new OptimizationNotSupported();
                            }
                            break;
                        }
                        this.fields = 0;
                    }
                    this.first = false;
                    if (!this.nullSafe || this.cursor >= this.end) continue;
                    assert (this.debug("DUP"));
                    this.mv.visitInsn(89);
                    Label j = new Label();
                    assert (this.debug("IFNONNULL : jump"));
                    this.mv.visitJumpInsn(199, j);
                    assert (this.debug("ARETURN"));
                    this.mv.visitInsn(176);
                    assert (this.debug("LABEL:jump"));
                    this.mv.visitLabel(j);
                }
            }
            this.val = curr;
            this._finishJIT();
            return this._initializeAccessor();
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException(new String(this.expr), this.expr, this.st, e, this.pCtx);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException(new String(this.expr), this.expr, this.st, e, this.pCtx);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PropertyAccessException(new String(this.expr), this.expr, this.st, e, this.pCtx);
        }
        catch (PropertyAccessException e) {
            throw new CompileException(e.getMessage(), this.expr, this.st, e);
        }
        catch (CompileException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw new PropertyAccessException(new String(this.expr), this.expr, this.st, e, this.pCtx);
        }
        catch (OptimizationNotSupported e) {
            throw e;
        }
        catch (Exception e) {
            throw new CompileException(e.getMessage(), this.expr, this.st, e);
        }
    }

    private Object getWithProperty(Object ctx) {
        assert (this.debug("\n  ** ENTER -> {with}"));
        if (this.first) {
            assert (this.debug("ALOAD 1"));
            this.mv.visitVarInsn(25, 1);
            this.first = false;
        }
        String root = new String(this.expr, 0, this.cursor - 1).trim();
        int start = this.cursor + 1;
        this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, this.end, '{', this.pCtx);
        this.returnType = ctx != null ? ctx.getClass() : null;
        for (WithNode.ParmValuePair aPvp : WithNode.compileWithExpressions(this.expr, start, this.cursor++ - start, root, this.ingressType, this.pCtx)) {
            assert (this.debug("DUP"));
            this.mv.visitInsn(89);
            assert (this.debug("ASTORE " + (5 + this.compileDepth) + " (withctx)"));
            this.mv.visitVarInsn(58, 5 + this.compileDepth);
            aPvp.eval(ctx, this.variableFactory);
            if (aPvp.getSetExpression() == null) {
                this.addSubstatement(aPvp.getStatement());
                continue;
            }
            this.compiledInputs.add((ExecutableStatement)aPvp.getSetExpression());
            assert (this.debug("ALOAD 0"));
            this.mv.visitVarInsn(25, 0);
            assert (this.debug("GETFIELD p" + (this.compiledInputs.size() - 1)));
            this.mv.visitFieldInsn(180, this.className, "p" + (this.compiledInputs.size() - 1), "L" + NAMESPACE + "compiler/ExecutableStatement;");
            assert (this.debug("ALOAD " + (5 + this.compileDepth) + "(withctx)"));
            this.mv.visitVarInsn(25, 5 + this.compileDepth);
            assert (this.debug("ALOAD 2"));
            this.mv.visitVarInsn(25, 2);
            assert (this.debug("ALOAD 3"));
            this.mv.visitVarInsn(25, 3);
            this.addSubstatement(aPvp.getStatement());
            assert (this.debug("INVOKEINTERFACE Accessor.setValue"));
            this.mv.visitMethodInsn(185, NAMESPACE + "compiler/ExecutableStatement", "setValue", "(Ljava/lang/Object;Ljava/lang/Object;L" + NAMESPACE + "integration/VariableResolverFactory;Ljava/lang/Object;)Ljava/lang/Object;");
            assert (this.debug("POP"));
            this.mv.visitInsn(87);
        }
        return ctx;
    }

    private Object getBeanPropertyAO(Object ctx, String property) throws IllegalAccessException, InvocationTargetException {
        if (ctx != null && PropertyHandlerFactory.hasPropertyHandler(ctx.getClass())) {
            return this.propHandlerByteCode(property, ctx, ctx.getClass());
        }
        return this.getBeanProperty(ctx, property);
    }

    private Object getBeanProperty(Object ctx, String property) throws IllegalAccessException, InvocationTargetException {
        Member member;
        Class<?> cls;
        assert (this.debug("\n  **  ENTER -> {bean: " + property + "; ctx=" + ctx + "}"));
        if ((this.pCtx == null ? this.currType : this.pCtx.getVarOrInputTypeOrNull(property)) == Object.class && !this.pCtx.isStrongTyping()) {
            this.currType = null;
        }
        if (this.returnType != null && this.returnType.isPrimitive()) {
            this.wrapPrimitive(this.returnType);
        }
        boolean classRef = false;
        if (ctx instanceof Class) {
            if (MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS && "class".equals(property)) {
                this.ldcClassConstant((Class)ctx);
                return ctx;
            }
            cls = (Class<?>)ctx;
            classRef = true;
        } else {
            cls = ctx != null ? ctx.getClass() : null;
        }
        if (PropertyHandlerFactory.hasPropertyHandler(cls)) {
            PropertyHandler prop = PropertyHandlerFactory.getPropertyHandler(cls);
            if (prop instanceof ProducesBytecode) {
                ((ProducesBytecode)((Object)prop)).produceBytecodeGet(this.mv, property, this.variableFactory);
                return prop.getProperty(property, ctx, this.variableFactory);
            }
            throw new RuntimeException("unable to compileShared: custom accessor does not support producing bytecode: " + prop.getClass().getName());
        }
        Member member2 = member = cls != null ? PropertyTools.getFieldOrAccessor(cls, property) : null;
        if (member != null && classRef && (member.getModifiers() & 8) == 0) {
            member = null;
        }
        if (member != null && GlobalListenerFactory.hasGetListeners()) {
            this.mv.visitVarInsn(25, 1);
            this.mv.visitLdcInsn(member.getName());
            this.mv.visitVarInsn(25, 3);
            this.mv.visitMethodInsn(184, NAMESPACE + "integration/GlobalListenerFactory", "notifyGetListeners", "(Ljava/lang/Object;Ljava/lang/String;L" + NAMESPACE + "integration/VariableResolverFactory;)V");
            GlobalListenerFactory.notifyGetListeners(ctx, member.getName(), this.variableFactory);
        }
        if (this.first) {
            if ("this".equals(property)) {
                assert (this.debug("ALOAD 2"));
                this.mv.visitVarInsn(25, 2);
                return this.thisRef;
            }
            if (this.variableFactory != null && this.variableFactory.isResolveable(property)) {
                if (this.variableFactory.isIndexedFactory() && this.variableFactory.isTarget(property)) {
                    int idx;
                    try {
                        idx = this.variableFactory.variableIndexOf(property);
                        this.loadVariableByIndex(idx);
                    }
                    catch (Exception e) {
                        throw new OptimizationFailure(property);
                    }
                    return this.variableFactory.getIndexedVariableResolver(idx).getValue();
                }
                try {
                    this.loadVariableByName(property);
                }
                catch (Exception e) {
                    throw new OptimizationFailure("critical error in JIT", e);
                }
                return this.variableFactory.getVariableResolver(property).getValue();
            }
            assert (this.debug("ALOAD 1"));
            this.mv.visitVarInsn(25, 1);
        }
        if (member instanceof Field) {
            return this.optimizeFieldMethodProperty(ctx, property, cls, member);
        }
        if (member != null) {
            Object o;
            if (this.first) {
                assert (this.debug("ALOAD 1 (B)"));
                this.mv.visitVarInsn(25, 1);
            }
            try {
                o = ((Method)member).invoke(ctx, EMPTYARG);
                if (this.returnType != member.getDeclaringClass()) {
                    assert (this.debug("CHECKCAST " + Type.getInternalName(member.getDeclaringClass())));
                    this.mv.visitTypeInsn(192, Type.getInternalName(member.getDeclaringClass()));
                }
                this.returnType = ((Method)member).getReturnType();
                if (member.getDeclaringClass().isInterface()) {
                    assert (this.debug("INVOKEINTERFACE " + member.getName() + ":" + this.returnType));
                    this.mv.visitMethodInsn(185, Type.getInternalName(member.getDeclaringClass()), member.getName(), Type.getMethodDescriptor((Method)member));
                } else {
                    assert (this.debug("INVOKEVIRTUAL " + member.getName() + ":" + this.returnType));
                    this.mv.visitMethodInsn(182, Type.getInternalName(member.getDeclaringClass()), member.getName(), Type.getMethodDescriptor((Method)member));
                }
            }
            catch (IllegalAccessException e) {
                Method iFaceMeth = ParseTools.determineActualTargetMethod((Method)member);
                if (iFaceMeth == null) {
                    throw new PropertyAccessException("could not access field: " + cls.getName() + "." + property, this.expr, this.st, e, this.pCtx);
                }
                assert (this.debug("CHECKCAST " + Type.getInternalName(iFaceMeth.getDeclaringClass())));
                this.mv.visitTypeInsn(192, Type.getInternalName(iFaceMeth.getDeclaringClass()));
                this.returnType = iFaceMeth.getReturnType();
                assert (this.debug("INVOKEINTERFACE " + member.getName() + ":" + this.returnType));
                this.mv.visitMethodInsn(185, Type.getInternalName(iFaceMeth.getDeclaringClass()), member.getName(), Type.getMethodDescriptor((Method)member));
                o = iFaceMeth.invoke(ctx, EMPTYARG);
            }
            catch (IllegalArgumentException e) {
                if (member.getDeclaringClass().equals(ctx)) {
                    try {
                        Class<?> c = Class.forName(member.getDeclaringClass().getName() + "$" + property);
                        throw new CompileException("name collision between innerclass: " + c.getCanonicalName() + "; and bean accessor: " + property + " (" + member.toString() + ")", this.expr, this.tkStart);
                    }
                    catch (ClassNotFoundException c) {
                        // empty catch block
                    }
                }
                throw e;
            }
            if (PropertyHandlerFactory.hasNullPropertyHandler()) {
                if (o == null) {
                    o = PropertyHandlerFactory.getNullPropertyHandler().getProperty(member.getName(), ctx, this.variableFactory);
                }
                this.writeOutNullHandler(member, 0);
            }
            this.currType = ReflectionUtil.toNonPrimitiveType(this.returnType);
            return o;
        }
        if (ctx instanceof Map && (((Map)ctx).containsKey(property) || this.nullSafe)) {
            assert (this.debug("CHECKCAST java/util/Map"));
            this.mv.visitTypeInsn(192, "java/util/Map");
            assert (this.debug("LDC: \"" + property + "\""));
            this.mv.visitLdcInsn(property);
            assert (this.debug("INVOKEINTERFACE: get"));
            this.mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
            return ((Map)ctx).get(property);
        }
        if (this.first && "this".equals(property)) {
            assert (this.debug("ALOAD 2"));
            this.mv.visitVarInsn(25, 2);
            return this.thisRef;
        }
        if ("length".equals(property) && ctx.getClass().isArray()) {
            this.anyArrayCheck(ctx.getClass());
            assert (this.debug("ARRAYLENGTH"));
            this.mv.visitInsn(190);
            this.wrapPrimitive(Integer.TYPE);
            return Array.getLength(ctx);
        }
        if (LITERALS.containsKey(property)) {
            Object lit = LITERALS.get(property);
            if (lit instanceof Class) {
                this.ldcClassConstant((Class)lit);
            }
            return lit;
        }
        Object ts = this.tryStaticAccess();
        if (ts != null) {
            if (ts instanceof Class) {
                this.ldcClassConstant((Class)ts);
                return ts;
            }
            if (ts instanceof Method) {
                this.writeFunctionPointerStub(((Method)ts).getDeclaringClass(), (Method)ts);
                return ts;
            }
            Field f = (Field)ts;
            return this.optimizeFieldMethodProperty(ctx, property, cls, f);
        }
        if (ctx instanceof Class) {
            Class c = (Class)ctx;
            for (Method m : c.getMethods()) {
                if (!property.equals(m.getName())) continue;
                if (this.pCtx != null && this.pCtx.getParserConfiguration() != null ? this.pCtx.getParserConfiguration().isAllowNakedMethCall() : MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL) {
                    assert (this.debug("POP"));
                    this.mv.visitInsn(87);
                    assert (this.debug("INVOKESTATIC " + m.getName()));
                    this.mv.visitMethodInsn(184, Type.getInternalName(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor(m));
                    this.returnType = m.getReturnType();
                    return m.invoke(null, ParseTools.EMPTY_OBJ_ARR);
                }
                this.writeFunctionPointerStub(c, m);
                return m;
            }
            try {
                Class subClass = ParseTools.findClass(this.variableFactory, c.getName() + "$" + property, this.pCtx);
                this.ldcClassConstant(subClass);
                return subClass;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else if (this.pCtx != null && this.pCtx.getParserConfiguration() != null ? this.pCtx.getParserConfiguration().isAllowNakedMethCall() : MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL) {
            return this.getMethod(ctx, property);
        }
        if (ctx == null) {
            throw new PropertyAccessException("unresolvable property or identifier: " + property, this.expr, this.st, this.pCtx);
        }
        throw new PropertyAccessException("could not access: " + property + "; in class: " + ctx.getClass().getName(), this.expr, this.st, this.pCtx);
    }

    private Object optimizeFieldMethodProperty(Object ctx, String property, Class<?> cls, Member member) throws IllegalAccessException {
        Object o = ((Field)member).get(ctx);
        if ((member.getModifiers() & 8) != 0) {
            if ((member.getModifiers() & 0x10) != 0 && (o instanceof String || ((Field)member).getType().isPrimitive())) {
                o = ((Field)member).get(null);
                assert (this.debug("LDC " + String.valueOf(o)));
                this.mv.visitLdcInsn(o);
                this.wrapPrimitive(o.getClass());
                if (PropertyHandlerFactory.hasNullPropertyHandler()) {
                    if (o == null) {
                        o = PropertyHandlerFactory.getNullPropertyHandler().getProperty(member.getName(), ctx, this.variableFactory);
                    }
                    this.writeOutNullHandler(member, 0);
                }
                return o;
            }
            assert (this.debug("GETSTATIC " + Type.getDescriptor(member.getDeclaringClass()) + "." + member.getName() + "::" + Type.getDescriptor(((Field)member).getType())));
            this.returnType = ((Field)member).getType();
            this.mv.visitFieldInsn(178, Type.getInternalName(member.getDeclaringClass()), member.getName(), Type.getDescriptor(this.returnType));
        } else {
            assert (this.debug("CHECKCAST " + Type.getInternalName(cls)));
            this.mv.visitTypeInsn(192, Type.getInternalName(cls));
            assert (this.debug("GETFIELD " + property + ":" + Type.getDescriptor(((Field)member).getType())));
            this.returnType = ((Field)member).getType();
            this.mv.visitFieldInsn(180, Type.getInternalName(cls), property, Type.getDescriptor(this.returnType));
        }
        this.returnType = ((Field)member).getType();
        if (PropertyHandlerFactory.hasNullPropertyHandler()) {
            if (o == null) {
                o = PropertyHandlerFactory.getNullPropertyHandler().getProperty(member.getName(), ctx, this.variableFactory);
            }
            this.writeOutNullHandler(member, 0);
        }
        this.currType = ReflectionUtil.toNonPrimitiveType(this.returnType);
        return o;
    }

    private void writeFunctionPointerStub(Class c, Method m) {
        this.ldcClassConstant(c);
        this.mv.visitMethodInsn(182, "java/lang/Class", "getMethods", "()[Ljava/lang/reflect/Method;");
        this.mv.visitVarInsn(58, 7);
        this.mv.visitInsn(3);
        this.mv.visitVarInsn(54, 5);
        this.mv.visitVarInsn(25, 7);
        this.mv.visitInsn(190);
        this.mv.visitVarInsn(54, 6);
        Label l1 = new Label();
        this.mv.visitJumpInsn(167, l1);
        Label l2 = new Label();
        this.mv.visitLabel(l2);
        this.mv.visitVarInsn(25, 7);
        this.mv.visitVarInsn(21, 5);
        this.mv.visitInsn(50);
        this.mv.visitVarInsn(58, 4);
        Label l3 = new Label();
        this.mv.visitLabel(l3);
        this.mv.visitLdcInsn(m.getName());
        this.mv.visitVarInsn(25, 4);
        this.mv.visitMethodInsn(182, "java/lang/reflect/Method", "getName", "()Ljava/lang/String;");
        this.mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z");
        Label l4 = new Label();
        this.mv.visitJumpInsn(153, l4);
        Label l5 = new Label();
        this.mv.visitLabel(l5);
        this.mv.visitVarInsn(25, 4);
        this.mv.visitInsn(176);
        this.mv.visitLabel(l4);
        this.mv.visitIincInsn(5, 1);
        this.mv.visitLabel(l1);
        this.mv.visitVarInsn(21, 5);
        this.mv.visitVarInsn(21, 6);
        this.mv.visitJumpInsn(161, l2);
        Label l6 = new Label();
        this.mv.visitLabel(l6);
        this.mv.visitInsn(1);
        this.mv.visitInsn(176);
    }

    private Object getCollectionProperty(Object ctx, String prop) throws IllegalAccessException, InvocationTargetException {
        if (prop.trim().length() > 0) {
            ctx = this.getBeanProperty(ctx, prop);
            this.first = false;
        }
        this.currType = null;
        assert (this.debug("\n  **  ENTER -> {collection:<<" + prop + ">>; ctx=" + ctx + "}"));
        int start = ++this.cursor;
        this.skipWhitespace();
        if (this.cursor == this.end) {
            throw new CompileException("unterminated '['", this.expr, this.st);
        }
        if (this.scanTo(']')) {
            throw new CompileException("unterminated '['", this.expr, this.st);
        }
        String tk = new String(this.expr, start, this.cursor - start);
        assert (this.debug("{collection token: [" + tk + "]}"));
        if (ctx == null) {
            return null;
        }
        if (this.first) {
            assert (this.debug("ALOAD 1"));
            this.mv.visitVarInsn(25, 1);
        }
        ExecutableStatement compiled = (ExecutableStatement)ParseTools.subCompileExpression(tk.toCharArray(), this.pCtx);
        Object item = compiled.getValue(this.ctx, this.variableFactory);
        ++this.cursor;
        if (ctx instanceof Map) {
            assert (this.debug("CHECKCAST java/util/Map"));
            this.mv.visitTypeInsn(192, "java/util/Map");
            Class c = this.writeLiteralOrSubexpression(compiled);
            if (c != null && c.isPrimitive()) {
                this.wrapPrimitive(c);
            }
            assert (this.debug("INVOKEINTERFACE: get"));
            this.mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
            return ((Map)ctx).get(item);
        }
        if (ctx instanceof List) {
            assert (this.debug("CHECKCAST java/util/List"));
            this.mv.visitTypeInsn(192, "java/util/List");
            this.writeLiteralOrSubexpression(compiled, Integer.TYPE);
            assert (this.debug("INVOKEINTERFACE: java/util/List.get"));
            this.mv.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;");
            return ((List)ctx).get(DataConversion.convert(item, Integer.class));
        }
        if (ctx.getClass().isArray()) {
            assert (this.debug("CHECKCAST " + Type.getDescriptor(ctx.getClass())));
            this.mv.visitTypeInsn(192, Type.getDescriptor(ctx.getClass()));
            this.writeLiteralOrSubexpression(compiled, Integer.TYPE, item.getClass());
            Class cls = ParseTools.getBaseComponentType(ctx.getClass());
            if (cls.isPrimitive()) {
                if (cls == Integer.TYPE) {
                    assert (this.debug("IALOAD"));
                    this.mv.visitInsn(46);
                } else if (cls == Character.TYPE) {
                    assert (this.debug("CALOAD"));
                    this.mv.visitInsn(52);
                } else if (cls == Boolean.TYPE) {
                    assert (this.debug("BALOAD"));
                    this.mv.visitInsn(51);
                } else if (cls == Double.TYPE) {
                    assert (this.debug("DALOAD"));
                    this.mv.visitInsn(49);
                } else if (cls == Float.TYPE) {
                    assert (this.debug("FALOAD"));
                    this.mv.visitInsn(48);
                } else if (cls == Short.TYPE) {
                    assert (this.debug("SALOAD"));
                    this.mv.visitInsn(53);
                } else if (cls == Long.TYPE) {
                    assert (this.debug("LALOAD"));
                    this.mv.visitInsn(47);
                } else if (cls == Byte.TYPE) {
                    assert (this.debug("BALOAD"));
                    this.mv.visitInsn(51);
                }
                this.wrapPrimitive(cls);
            } else {
                assert (this.debug("AALOAD"));
                this.mv.visitInsn(50);
            }
            return Array.get(ctx, DataConversion.convert(item, Integer.class));
        }
        if (ctx instanceof CharSequence) {
            assert (this.debug("CHECKCAST java/lang/CharSequence"));
            this.mv.visitTypeInsn(192, "java/lang/CharSequence");
            if (item instanceof Integer) {
                this.intPush((Integer)item);
                assert (this.debug("INVOKEINTERFACE java/lang/CharSequence.charAt"));
                this.mv.visitMethodInsn(185, "java/lang/CharSequence", "charAt", "(I)C");
                this.wrapPrimitive(Character.TYPE);
                return Character.valueOf(((CharSequence)ctx).charAt((Integer)item));
            }
            this.writeLiteralOrSubexpression(compiled, Integer.class);
            this.unwrapPrimitive(Integer.TYPE);
            assert (this.debug("INVOKEINTERFACE java/lang/CharSequence.charAt"));
            this.mv.visitMethodInsn(185, "java/lang/CharSequence", "charAt", "(I)C");
            this.wrapPrimitive(Character.TYPE);
            return Character.valueOf(((CharSequence)ctx).charAt(DataConversion.convert(item, Integer.class)));
        }
        TypeDescriptor tDescr = new TypeDescriptor(this.expr, this.start, this.length, 0);
        if (tDescr.isArray()) {
            try {
                Class cls = TypeDescriptor.getClassReference((Class)ctx, tDescr, this.variableFactory, this.pCtx);
                this.ldcClassConstant(cls);
                return cls;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new CompileException("illegal use of []: unknown type: " + (ctx == null ? null : ctx.getClass().getName()), this.expr, this.st);
    }

    private Object getCollectionPropertyAO(Object ctx, String prop) throws IllegalAccessException, InvocationTargetException {
        if (prop.length() > 0) {
            ctx = this.getBeanProperty(ctx, prop);
            this.first = false;
        }
        this.currType = null;
        assert (this.debug("\n  **  ENTER -> {collection:<<" + prop + ">>; ctx=" + ctx + "}"));
        int _start = ++this.cursor;
        this.skipWhitespace();
        if (this.cursor == this.end) {
            throw new CompileException("unterminated '['", this.expr, this.st);
        }
        if (this.scanTo(']')) {
            throw new CompileException("unterminated '['", this.expr, this.st);
        }
        String tk = new String(this.expr, _start, this.cursor - _start);
        assert (this.debug("{collection token:<<" + tk + ">>}"));
        if (ctx == null) {
            return null;
        }
        ExecutableStatement compiled = (ExecutableStatement)ParseTools.subCompileExpression(tk.toCharArray());
        Object item = compiled.getValue(this.ctx, this.variableFactory);
        ++this.cursor;
        if (ctx instanceof Map) {
            if (PropertyHandlerFactory.hasPropertyHandler(Map.class)) {
                return this.propHandlerByteCode(tk, ctx, Map.class);
            }
            if (this.first) {
                assert (this.debug("ALOAD 1"));
                this.mv.visitVarInsn(25, 1);
            }
            assert (this.debug("CHECKCAST java/util/Map"));
            this.mv.visitTypeInsn(192, "java/util/Map");
            Class c = this.writeLiteralOrSubexpression(compiled);
            if (c != null && c.isPrimitive()) {
                this.wrapPrimitive(c);
            }
            assert (this.debug("INVOKEINTERFACE: Map.get"));
            this.mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
            return ((Map)ctx).get(item);
        }
        if (ctx instanceof List) {
            if (PropertyHandlerFactory.hasPropertyHandler(List.class)) {
                return this.propHandlerByteCode(tk, ctx, List.class);
            }
            if (this.first) {
                assert (this.debug("ALOAD 1"));
                this.mv.visitVarInsn(25, 1);
            }
            assert (this.debug("CHECKCAST java/util/List"));
            this.mv.visitTypeInsn(192, "java/util/List");
            this.writeLiteralOrSubexpression(compiled, Integer.TYPE);
            assert (this.debug("INVOKEINTERFACE: java/util/List.get"));
            this.mv.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;");
            return ((List)ctx).get(DataConversion.convert(item, Integer.class));
        }
        if (ctx.getClass().isArray()) {
            if (PropertyHandlerFactory.hasPropertyHandler(Array.class)) {
                return this.propHandlerByteCode(tk, ctx, Array.class);
            }
            if (this.first) {
                assert (this.debug("ALOAD 1"));
                this.mv.visitVarInsn(25, 1);
            }
            assert (this.debug("CHECKCAST " + Type.getDescriptor(ctx.getClass())));
            this.mv.visitTypeInsn(192, Type.getDescriptor(ctx.getClass()));
            this.writeLiteralOrSubexpression(compiled, Integer.TYPE, item.getClass());
            Class cls = ParseTools.getBaseComponentType(ctx.getClass());
            if (cls.isPrimitive()) {
                if (cls == Integer.TYPE) {
                    assert (this.debug("IALOAD"));
                    this.mv.visitInsn(46);
                } else if (cls == Character.TYPE) {
                    assert (this.debug("CALOAD"));
                    this.mv.visitInsn(52);
                } else if (cls == Boolean.TYPE) {
                    assert (this.debug("BALOAD"));
                    this.mv.visitInsn(51);
                } else if (cls == Double.TYPE) {
                    assert (this.debug("DALOAD"));
                    this.mv.visitInsn(49);
                } else if (cls == Float.TYPE) {
                    assert (this.debug("FALOAD"));
                    this.mv.visitInsn(48);
                } else if (cls == Short.TYPE) {
                    assert (this.debug("SALOAD"));
                    this.mv.visitInsn(53);
                } else if (cls == Long.TYPE) {
                    assert (this.debug("LALOAD"));
                    this.mv.visitInsn(47);
                } else if (cls == Byte.TYPE) {
                    assert (this.debug("BALOAD"));
                    this.mv.visitInsn(51);
                }
                this.wrapPrimitive(cls);
            } else {
                assert (this.debug("AALOAD"));
                this.mv.visitInsn(50);
            }
            return Array.get(ctx, DataConversion.convert(item, Integer.class));
        }
        if (ctx instanceof CharSequence) {
            if (PropertyHandlerFactory.hasPropertyHandler(CharSequence.class)) {
                return this.propHandlerByteCode(tk, ctx, CharSequence.class);
            }
            if (this.first) {
                assert (this.debug("ALOAD 1"));
                this.mv.visitVarInsn(25, 1);
            }
            assert (this.debug("CHECKCAST java/lang/CharSequence"));
            this.mv.visitTypeInsn(192, "java/lang/CharSequence");
            if (item instanceof Integer) {
                this.intPush((Integer)item);
                assert (this.debug("INVOKEINTERFACE java/lang/CharSequence.charAt"));
                this.mv.visitMethodInsn(185, "java/lang/CharSequence", "charAt", "(I)C");
                this.wrapPrimitive(Character.TYPE);
                return Character.valueOf(((CharSequence)ctx).charAt((Integer)item));
            }
            this.writeLiteralOrSubexpression(compiled, Integer.class);
            this.unwrapPrimitive(Integer.TYPE);
            assert (this.debug("INVOKEINTERFACE java/lang/CharSequence.charAt"));
            this.mv.visitMethodInsn(185, "java/lang/CharSequence", "charAt", "(I)C");
            this.wrapPrimitive(Character.TYPE);
            return Character.valueOf(((CharSequence)ctx).charAt(DataConversion.convert(item, Integer.class)));
        }
        TypeDescriptor tDescr = new TypeDescriptor(this.expr, this.start, this.end - this.start, 0);
        if (tDescr.isArray()) {
            try {
                Class cls = TypeDescriptor.getClassReference((Class)ctx, tDescr, this.variableFactory, this.pCtx);
                this.ldcClassConstant(cls);
                return cls;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new CompileException("illegal use of []: unknown type: " + (ctx == null ? null : ctx.getClass().getName()), this.expr, this.st);
    }

    private Object getMethod(Object ctx, String name) throws IllegalAccessException, InvocationTargetException {
        List<char[]> subtokens;
        ExecutableStatement[] es;
        Class[] argTypes;
        Object[] args;
        Object[] preConvArgs;
        assert (this.debug("\n  **  {method: " + name + "}"));
        int st = this.cursor;
        String tk = this.cursor != this.end && this.expr[this.cursor] == '(' && (this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, '(')) - st > 1 ? new String(this.expr, st + 1, this.cursor - st - 1) : "";
        ++this.cursor;
        if (tk.length() == 0) {
            preConvArgs = ParseTools.EMPTY_OBJ_ARR;
            args = ParseTools.EMPTY_OBJ_ARR;
            argTypes = ParseTools.EMPTY_CLS_ARR;
            es = null;
            subtokens = null;
        } else {
            int i;
            subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
            es = new ExecutableStatement[subtokens.size()];
            args = new Object[subtokens.size()];
            argTypes = new Class[subtokens.size()];
            preConvArgs = new Object[es.length];
            for (i = 0; i < subtokens.size(); ++i) {
                assert (this.debug("subtoken[" + i + "] { " + new String(subtokens.get(i)) + " }"));
                es[i] = (ExecutableStatement)ParseTools.subCompileExpression(subtokens.get(i), this.pCtx);
                preConvArgs[i] = args[i] = es[i].getValue(this.thisRef, this.thisRef, this.variableFactory);
                if (!es[i].isExplicitCast()) continue;
                argTypes[i] = es[i].getKnownEgressType();
            }
            if (this.pCtx.isStrictTypeEnforcement()) {
                for (i = 0; i < args.length; ++i) {
                    argTypes[i] = es[i].getKnownEgressType();
                    if (!(es[i] instanceof ExecutableLiteral) || ((ExecutableLiteral)es[i]).getLiteral() != null) continue;
                    argTypes[i] = NullType.class;
                }
            } else {
                for (i = 0; i < args.length; ++i) {
                    if (argTypes[i] != null) continue;
                    argTypes[i] = es[i].getKnownEgressType() == Object.class ? (args[i] == null ? null : args[i].getClass()) : es[i].getKnownEgressType();
                }
            }
        }
        if (this.first && this.variableFactory != null && this.variableFactory.isResolveable(name)) {
            Object ptr = this.variableFactory.getVariableResolver(name).getValue();
            if (ptr instanceof Method) {
                ctx = ((Method)ptr).getDeclaringClass();
                name = ((Method)ptr).getName();
            } else if (ptr instanceof MethodStub) {
                ctx = ((MethodStub)ptr).getClassReference();
                name = ((MethodStub)ptr).getMethodName();
            } else {
                if (ptr instanceof FunctionInstance) {
                    if (es != null && es.length != 0) {
                        this.compiledInputs.addAll(Arrays.asList(es));
                        this.intPush(es.length);
                        assert (this.debug("ANEWARRAY [" + es.length + "]"));
                        this.mv.visitTypeInsn(189, "java/lang/Object");
                        assert (this.debug("ASTORE 4"));
                        this.mv.visitVarInsn(58, 4);
                        for (int i = 0; i < es.length; ++i) {
                            assert (this.debug("ALOAD 4"));
                            this.mv.visitVarInsn(25, 4);
                            this.intPush(i);
                            this.loadField(i);
                            assert (this.debug("ALOAD 1"));
                            this.mv.visitVarInsn(25, 1);
                            assert (this.debug("ALOAD 3"));
                            this.mv.visitIntInsn(25, 3);
                            assert (this.debug("INVOKEINTERFACE ExecutableStatement.getValue"));
                            this.mv.visitMethodInsn(185, NAMESPACE + "compiler/ExecutableStatement", "getValue", "(Ljava/lang/Object;L" + NAMESPACE + "integration/VariableResolverFactory;)Ljava/lang/Object;");
                            assert (this.debug("AASTORE"));
                            this.mv.visitInsn(83);
                        }
                    } else {
                        assert (this.debug("ACONST_NULL"));
                        this.mv.visitInsn(1);
                        assert (this.debug("CHECKCAST java/lang/Object"));
                        this.mv.visitTypeInsn(192, "[Ljava/lang/Object;");
                        assert (this.debug("ASTORE 4"));
                        this.mv.visitVarInsn(58, 4);
                    }
                    if (this.variableFactory.isIndexedFactory() && this.variableFactory.isTarget(name)) {
                        this.loadVariableByIndex(this.variableFactory.variableIndexOf(name));
                    } else {
                        this.loadVariableByName(name);
                    }
                    this.checkcast(FunctionInstance.class);
                    assert (this.debug("ALOAD 1"));
                    this.mv.visitVarInsn(25, 1);
                    assert (this.debug("ALOAD 2"));
                    this.mv.visitVarInsn(25, 2);
                    assert (this.debug("ALOAD 3"));
                    this.mv.visitVarInsn(25, 3);
                    assert (this.debug("ALOAD 4"));
                    this.mv.visitVarInsn(25, 4);
                    assert (this.debug("INVOKEVIRTUAL Function.call"));
                    this.mv.visitMethodInsn(182, Type.getInternalName(FunctionInstance.class), "call", "(Ljava/lang/Object;Ljava/lang/Object;L" + NAMESPACE + "integration/VariableResolverFactory;[Ljava/lang/Object;)Ljava/lang/Object;");
                    return ((FunctionInstance)ptr).call(ctx, this.thisRef, this.variableFactory, args);
                }
                throw new OptimizationFailure("attempt to optimize a method call for a reference that does not point to a method: " + name + " (reference is type: " + (ctx != null ? ctx.getClass().getName() : null) + ")");
            }
            this.first = false;
        } else if (this.returnType != null && this.returnType.isPrimitive()) {
            this.wrapPrimitive(this.returnType);
        }
        boolean classTarget = false;
        Class<?> cls = this.currType != null ? this.currType : ((classTarget = ctx instanceof Class) ? (Class)ctx : ctx.getClass());
        this.currType = null;
        Class<?>[] parameterTypes = null;
        Method m = ParseTools.getBestCandidate(argTypes, name, cls, cls.getMethods(), false, classTarget);
        if (m != null) {
            parameterTypes = m.getParameterTypes();
        }
        if (m == null && classTarget && (m = ParseTools.getBestCandidate(argTypes, name, cls, Class.class.getMethods(), false)) != null) {
            parameterTypes = m.getParameterTypes();
        }
        if (m == null && cls != ctx.getClass() && !(ctx instanceof Class) && (m = ParseTools.getBestCandidate(argTypes, name, cls = ctx.getClass(), cls.getMethods(), false, classTarget)) != null) {
            parameterTypes = m.getParameterTypes();
        }
        if (es != null && m != null && m.isVarArgs() && (es.length != parameterTypes.length || !(es[es.length - 1] instanceof ExecutableAccessor))) {
            String varArgExpr;
            ExecutableStatement[] varArgEs = new ExecutableStatement[parameterTypes.length];
            int varArgStart = parameterTypes.length - 1;
            for (int i = 0; i < varArgStart; ++i) {
                varArgEs[i] = es[i];
            }
            String varargsTypeName = parameterTypes[parameterTypes.length - 1].getComponentType().getName();
            if ("null".equals(tk)) {
                varArgExpr = tk;
            } else {
                StringBuilder sb = new StringBuilder("new ").append(varargsTypeName).append("[] {");
                for (int i = varArgStart; i < subtokens.size(); ++i) {
                    sb.append(subtokens.get(i));
                    if (i >= subtokens.size() - 1) continue;
                    sb.append(",");
                }
                varArgExpr = sb.append("}").toString();
            }
            char[] token = varArgExpr.toCharArray();
            varArgEs[varArgStart] = (ExecutableStatement)ParseTools.subCompileExpression(token, this.pCtx);
            es = varArgEs;
            if (preConvArgs.length == parameterTypes.length - 1) {
                Object[] preConvArgsForVarArg = new Object[parameterTypes.length];
                for (int i = 0; i < preConvArgs.length; ++i) {
                    preConvArgsForVarArg[i] = preConvArgs[i];
                }
                preConvArgsForVarArg[parameterTypes.length - 1] = Array.newInstance(parameterTypes[parameterTypes.length - 1].getComponentType(), 0);
                preConvArgs = preConvArgsForVarArg;
            }
        }
        int inputsOffset = this.compiledInputs.size();
        if (es != null) {
            for (ExecutableStatement e : es) {
                if (e instanceof ExecutableLiteral) continue;
                this.compiledInputs.add(e);
            }
        }
        if (this.first) {
            assert (this.debug("ALOAD 1 (D) "));
            this.mv.visitVarInsn(25, 1);
        }
        if (m == null) {
            StringAppender errorBuild = new StringAppender();
            if (parameterTypes != null) {
                for (int i = 0; i < args.length; ++i) {
                    errorBuild.append(parameterTypes[i] != null ? parameterTypes[i].getClass().getName() : null);
                    if (i >= args.length - 1) continue;
                    errorBuild.append(", ");
                }
            }
            if ("size".equals(name) && args.length == 0 && cls.isArray()) {
                this.anyArrayCheck(cls);
                assert (this.debug("ARRAYLENGTH"));
                this.mv.visitInsn(190);
                this.wrapPrimitive(Integer.TYPE);
                return Array.getLength(ctx);
            }
            throw new CompileException("unable to resolve method: " + cls.getName() + "." + name + "(" + errorBuild.toString() + ") [arglength=" + args.length + "]", this.expr, st);
        }
        m = ParseTools.getWidenedTarget(m);
        if (es != null) {
            for (int i = 0; i < es.length; ++i) {
                ExecutableStatement cExpr = es[i];
                if (cExpr.getKnownIngressType() == null) {
                    cExpr.setKnownIngressType(parameterTypes[i]);
                    cExpr.computeTypeConversionRule();
                }
                if (cExpr.isConvertableIngressEgress() || i >= args.length) continue;
                args[i] = DataConversion.convert(args[i], Varargs.paramTypeVarArgsSafe(parameterTypes, i, m.isVarArgs()));
            }
        } else {
            for (int i = 0; i < args.length; ++i) {
                args[i] = DataConversion.convert(args[i], Varargs.paramTypeVarArgsSafe(parameterTypes, i, m.isVarArgs()));
            }
        }
        Class<?> declaringClass = m.getDeclaringClass();
        if (m.getParameterTypes().length == 0) {
            if ((m.getModifiers() & 8) != 0) {
                assert (this.debug("INVOKESTATIC " + m.getName()));
                this.mv.visitMethodInsn(184, Type.getInternalName(declaringClass), m.getName(), Type.getMethodDescriptor(m));
            } else {
                assert (this.debug("CHECKCAST " + Type.getInternalName(declaringClass)));
                this.mv.visitTypeInsn(192, Type.getInternalName(declaringClass));
                if (declaringClass.isInterface()) {
                    assert (this.debug("INVOKEINTERFACE " + m.getName()));
                    this.mv.visitMethodInsn(185, Type.getInternalName(declaringClass), m.getName(), Type.getMethodDescriptor(m));
                } else {
                    assert (this.debug("INVOKEVIRTUAL " + m.getName()));
                    this.mv.visitMethodInsn(182, Type.getInternalName(declaringClass), m.getName(), Type.getMethodDescriptor(m));
                }
            }
            this.returnType = m.getReturnType();
            ++this.stacksize;
        } else {
            if ((m.getModifiers() & 8) == 0) {
                assert (this.debug("CHECKCAST " + Type.getInternalName(declaringClass)));
                this.mv.visitTypeInsn(192, Type.getInternalName(declaringClass));
            }
            for (int i = 0; es != null && i < es.length; ++i) {
                if (es[i] instanceof ExecutableLiteral) {
                    ExecutableLiteral literal = (ExecutableLiteral)es[i];
                    if (literal.getLiteral() == null) {
                        assert (this.debug("ICONST_NULL"));
                        this.mv.visitInsn(1);
                        continue;
                    }
                    if (parameterTypes[i] == Integer.TYPE && literal.intOptimized()) {
                        this.intPush(literal.getInteger32());
                        continue;
                    }
                    if (parameterTypes[i] == Integer.TYPE && preConvArgs[i] instanceof Integer) {
                        this.intPush((Integer)preConvArgs[i]);
                        continue;
                    }
                    if (parameterTypes[i] == Boolean.TYPE) {
                        boolean bool = DataConversion.convert(literal.getLiteral(), Boolean.class);
                        assert (this.debug(bool ? "ICONST_1" : "ICONST_0"));
                        this.mv.visitInsn(bool ? 4 : 3);
                        continue;
                    }
                    Object lit = literal.getLiteral();
                    if (parameterTypes[i] == Object.class) {
                        if (ParseTools.isPrimitiveWrapper(lit.getClass())) {
                            if (lit.getClass() == Integer.class) {
                                this.intPush((Integer)lit);
                            } else {
                                assert (this.debug("LDC " + lit));
                                this.mv.visitLdcInsn(lit);
                            }
                            this.wrapPrimitive(lit.getClass());
                            continue;
                        }
                        if (!(lit instanceof String)) continue;
                        this.mv.visitLdcInsn(lit);
                        this.checkcast(Object.class);
                        continue;
                    }
                    if (DataConversion.canConvert(parameterTypes[i], lit.getClass())) {
                        Object c = DataConversion.convert(lit, parameterTypes[i]);
                        if (c instanceof Class) {
                            this.ldcClassConstant((Class)c);
                            continue;
                        }
                        assert (this.debug("LDC " + lit + " (" + lit.getClass().getName() + ")"));
                        this.mv.visitLdcInsn(c);
                        if (!ParseTools.isPrimitiveWrapper(parameterTypes[i])) continue;
                        this.wrapPrimitive(lit.getClass());
                        continue;
                    }
                    throw new OptimizationNotSupported();
                }
                assert (this.debug("ALOAD 0"));
                this.mv.visitVarInsn(25, 0);
                assert (this.debug("GETFIELD p" + inputsOffset));
                this.mv.visitFieldInsn(180, this.className, "p" + inputsOffset, "L" + NAMESPACE + "compiler/ExecutableStatement;");
                ++inputsOffset;
                assert (this.debug("ALOAD 2"));
                this.mv.visitVarInsn(25, 2);
                assert (this.debug("ALOAD 3"));
                this.mv.visitVarInsn(25, 3);
                assert (this.debug("INVOKEINTERFACE ExecutableStatement.getValue"));
                this.mv.visitMethodInsn(185, Type.getInternalName(ExecutableStatement.class), "getValue", "(Ljava/lang/Object;L" + NAMESPACE + "integration/VariableResolverFactory;)Ljava/lang/Object;");
                if (parameterTypes[i].isPrimitive()) {
                    if (preConvArgs[i] == null || parameterTypes[i] != String.class && !parameterTypes[i].isAssignableFrom(preConvArgs[i].getClass())) {
                        this.ldcClassConstant(this.getWrapperClass(parameterTypes[i]));
                        assert (this.debug("INVOKESTATIC DataConversion.convert"));
                        this.mv.visitMethodInsn(184, NAMESPACE + "DataConversion", "convert", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
                    }
                    this.unwrapPrimitive(parameterTypes[i]);
                    continue;
                }
                if (preConvArgs[i] == null || parameterTypes[i] != String.class && !parameterTypes[i].isAssignableFrom(preConvArgs[i].getClass())) {
                    this.ldcClassConstant(parameterTypes[i]);
                    assert (this.debug("INVOKESTATIC DataConversion.convert"));
                    this.mv.visitMethodInsn(184, NAMESPACE + "DataConversion", "convert", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
                    assert (this.debug("CHECKCAST " + Type.getInternalName(parameterTypes[i])));
                    this.mv.visitTypeInsn(192, Type.getInternalName(parameterTypes[i]));
                    continue;
                }
                if (parameterTypes[i] == String.class) {
                    assert (this.debug("<<<DYNAMIC TYPE OPTIMIZATION STRING>>"));
                    this.mv.visitVarInsn(58, 4);
                    Label jmp = new Label();
                    this.mv.visitVarInsn(25, 4);
                    this.mv.visitJumpInsn(199, jmp);
                    this.mv.visitInsn(1);
                    Label jmp2 = new Label();
                    this.mv.visitJumpInsn(167, jmp2);
                    this.mv.visitLabel(jmp);
                    this.mv.visitVarInsn(25, 4);
                    this.mv.visitMethodInsn(184, "java/lang/String", "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;");
                    this.mv.visitLabel(jmp2);
                    continue;
                }
                assert (this.debug("<<<DYNAMIC TYPING BYPASS>>>"));
                assert (this.debug("<<<OPT. JUSTIFICATION " + parameterTypes[i] + "=" + preConvArgs[i].getClass() + ">>>"));
                assert (this.debug("CHECKCAST " + Type.getInternalName(parameterTypes[i])));
                this.mv.visitTypeInsn(192, Type.getInternalName(parameterTypes[i]));
            }
            if (m.isVarArgs() && (es == null || es.length == parameterTypes.length - 1)) {
                this.createArray(ParseTools.getBaseComponentType(parameterTypes[parameterTypes.length - 1]), 0);
            }
            if ((m.getModifiers() & 8) != 0) {
                assert (this.debug("INVOKESTATIC: " + m.getName()));
                this.mv.visitMethodInsn(184, Type.getInternalName(declaringClass), m.getName(), Type.getMethodDescriptor(m));
            } else if (declaringClass.isInterface()) {
                assert (this.debug("INVOKEINTERFACE: " + Type.getInternalName(declaringClass) + "." + m.getName()));
                this.mv.visitMethodInsn(185, Type.getInternalName(declaringClass), m.getName(), Type.getMethodDescriptor(m));
            } else {
                assert (this.debug("INVOKEVIRTUAL: " + Type.getInternalName(declaringClass) + "." + m.getName()));
                this.mv.visitMethodInsn(182, Type.getInternalName(declaringClass), m.getName(), Type.getMethodDescriptor(m));
            }
            this.returnType = m.getReturnType();
            ++this.stacksize;
        }
        Object o = m.invoke((Object)ctx, Varargs.normalizeArgsForVarArgs(parameterTypes, args, m.isVarArgs()));
        if (PropertyHandlerFactory.hasNullMethodHandler()) {
            this.writeOutNullHandler(m, 1);
            if (o == null) {
                o = PropertyHandlerFactory.getNullMethodHandler().getProperty(m.getName(), ctx, this.variableFactory);
            }
        }
        this.currType = ReflectionUtil.toNonPrimitiveType(m.getReturnType());
        return o;
    }

    private void dataConversion(Class target) {
        if (target.equals(Object.class)) {
            return;
        }
        this.ldcClassConstant(target);
        assert (this.debug("INVOKESTATIC " + NAMESPACE + "DataConversion.convert"));
        this.mv.visitMethodInsn(184, NAMESPACE + "DataConversion", "convert", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
    }

    public static void setMVELClassLoader(MVELClassLoader cl) {
        classLoader = cl;
    }

    public static MVELClassLoader getMVELClassLoader() {
        return classLoader;
    }

    @Override
    public void init() {
        try {
            classLoader = new JITClassLoader(Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ContextClassLoader getContextClassLoader() {
        return this.pCtx == null ? null : new ContextClassLoader(this.pCtx.getClassLoader());
    }

    private Class loadClass(String className, byte[] b) throws Exception {
        ContextClassLoader contextClassLoader = this.getContextClassLoader();
        return contextClassLoader == null ? classLoader.defineClassX(className, b, 0, b.length) : contextClassLoader.defineClass(className, b);
    }

    private boolean debug(String instruction) {
        if (this.buildLog != null) {
            this.buildLog.append(instruction).append("\n");
        }
        return true;
    }

    public String getName() {
        return "ASM";
    }

    @Override
    public Object getResultOptPass() {
        return this.val;
    }

    private Class getWrapperClass(Class cls) {
        if (cls == Boolean.TYPE) {
            return Boolean.class;
        }
        if (cls == Integer.TYPE) {
            return Integer.class;
        }
        if (cls == Float.TYPE) {
            return Float.class;
        }
        if (cls == Double.TYPE) {
            return Double.class;
        }
        if (cls == Short.TYPE) {
            return Short.class;
        }
        if (cls == Long.TYPE) {
            return Long.class;
        }
        if (cls == Byte.TYPE) {
            return Byte.class;
        }
        if (cls == Character.TYPE) {
            return Character.class;
        }
        return cls;
    }

    private void unwrapPrimitive(Class cls) {
        if (cls == Boolean.TYPE) {
            assert (this.debug("CHECKCAST java/lang/Boolean"));
            this.mv.visitTypeInsn(192, "java/lang/Boolean");
            assert (this.debug("INVOKEVIRTUAL java/lang/Boolean.booleanValue"));
            this.mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
        } else if (cls == Integer.TYPE) {
            assert (this.debug("CHECKCAST java/lang/Integer"));
            this.mv.visitTypeInsn(192, "java/lang/Integer");
            assert (this.debug("INVOKEVIRTUAL java/lang/Integer.intValue"));
            this.mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
        } else if (cls == Float.TYPE) {
            assert (this.debug("CHECKCAST java/lang/Float"));
            this.mv.visitTypeInsn(192, "java/lang/Float");
            assert (this.debug("INVOKEVIRTUAL java/lang/Float.floatValue"));
            this.mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
        } else if (cls == Double.TYPE) {
            assert (this.debug("CHECKCAST java/lang/Double"));
            this.mv.visitTypeInsn(192, "java/lang/Double");
            assert (this.debug("INVOKEVIRTUAL java/lang/Double.doubleValue"));
            this.mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
        } else if (cls == Short.TYPE) {
            assert (this.debug("CHECKCAST java/lang/Short"));
            this.mv.visitTypeInsn(192, "java/lang/Short");
            assert (this.debug("INVOKEVIRTUAL java/lang/Short.shortValue"));
            this.mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
        } else if (cls == Long.TYPE) {
            assert (this.debug("CHECKCAST java/lang/Long"));
            this.mv.visitTypeInsn(192, "java/lang/Long");
            assert (this.debug("INVOKEVIRTUAL java/lang/Long.longValue"));
            this.mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
        } else if (cls == Byte.TYPE) {
            assert (this.debug("CHECKCAST java/lang/Byte"));
            this.mv.visitTypeInsn(192, "java/lang/Byte");
            assert (this.debug("INVOKEVIRTUAL java/lang/Byte.byteValue"));
            this.mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
        } else if (cls == Character.TYPE) {
            assert (this.debug("CHECKCAST java/lang/Character"));
            this.mv.visitTypeInsn(192, "java/lang/Character");
            assert (this.debug("INVOKEVIRTUAL java/lang/Character.charValue"));
            this.mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
        }
    }

    private void wrapPrimitive(Class<? extends Object> cls) {
        if (OPCODES_VERSION == 48) {
            this.debug("** Using 1.4 Bytecode **");
            if (cls == Boolean.TYPE || cls == Boolean.class) {
                this.debug("NEW java/lang/Boolean");
                this.mv.visitTypeInsn(187, "java/lang/Boolean");
                this.debug("DUP X1");
                this.mv.visitInsn(90);
                this.debug("SWAP");
                this.mv.visitInsn(95);
                this.debug("INVOKESPECIAL java/lang/Boolean.<init>::(Z)V");
                this.mv.visitMethodInsn(183, "java/lang/Boolean", "<init>", "(Z)V");
            } else if (cls == Integer.TYPE || cls == Integer.class) {
                this.debug("NEW java/lang/Integer");
                this.mv.visitTypeInsn(187, "java/lang/Integer");
                this.debug("DUP X1");
                this.mv.visitInsn(90);
                this.debug("SWAP");
                this.mv.visitInsn(95);
                this.debug("INVOKESPECIAL java/lang/Integer.<init>::(I)V");
                this.mv.visitMethodInsn(183, "java/lang/Integer", "<init>", "(I)V");
            } else if (cls == Float.TYPE || cls == Float.class) {
                this.debug("NEW java/lang/Float");
                this.mv.visitTypeInsn(187, "java/lang/Float");
                this.debug("DUP X1");
                this.mv.visitInsn(90);
                this.debug("SWAP");
                this.mv.visitInsn(95);
                this.debug("INVOKESPECIAL java/lang/Float.<init>::(F)V");
                this.mv.visitMethodInsn(183, "java/lang/Float", "<init>", "(F)V");
            } else if (cls == Double.TYPE || cls == Double.class) {
                this.debug("NEW java/lang/Double");
                this.mv.visitTypeInsn(187, "java/lang/Double");
                this.debug("DUP X2");
                this.mv.visitInsn(91);
                this.debug("DUP X2");
                this.mv.visitInsn(91);
                this.debug("POP");
                this.mv.visitInsn(87);
                this.debug("INVOKESPECIAL java/lang/Double.<init>::(D)V");
                this.mv.visitMethodInsn(183, "java/lang/Double", "<init>", "(D)V");
            } else if (cls == Short.TYPE || cls == Short.class) {
                this.debug("NEW java/lang/Short");
                this.mv.visitTypeInsn(187, "java/lang/Short");
                this.debug("DUP X1");
                this.mv.visitInsn(90);
                this.debug("SWAP");
                this.mv.visitInsn(95);
                this.debug("INVOKESPECIAL java/lang/Short.<init>::(S)V");
                this.mv.visitMethodInsn(183, "java/lang/Short", "<init>", "(S)V");
            } else if (cls == Long.TYPE || cls == Long.class) {
                this.debug("NEW java/lang/Long");
                this.mv.visitTypeInsn(187, "java/lang/Long");
                this.debug("DUP X1");
                this.mv.visitInsn(90);
                this.debug("SWAP");
                this.mv.visitInsn(95);
                this.debug("INVOKESPECIAL java/lang/Long.<init>::(L)V");
                this.mv.visitMethodInsn(183, "java/lang/Float", "<init>", "(L)V");
            } else if (cls == Byte.TYPE || cls == Byte.class) {
                this.debug("NEW java/lang/Byte");
                this.mv.visitTypeInsn(187, "java/lang/Byte");
                this.debug("DUP X1");
                this.mv.visitInsn(90);
                this.debug("SWAP");
                this.mv.visitInsn(95);
                this.debug("INVOKESPECIAL java/lang/Byte.<init>::(B)V");
                this.mv.visitMethodInsn(183, "java/lang/Byte", "<init>", "(B)V");
            } else if (cls == Character.TYPE || cls == Character.class) {
                this.debug("NEW java/lang/Character");
                this.mv.visitTypeInsn(187, "java/lang/Character");
                this.debug("DUP X1");
                this.mv.visitInsn(90);
                this.debug("SWAP");
                this.mv.visitInsn(95);
                this.debug("INVOKESPECIAL java/lang/Character.<init>::(C)V");
                this.mv.visitMethodInsn(183, "java/lang/Character", "<init>", "(C)V");
            }
        } else if (cls == Boolean.TYPE || cls == Boolean.class) {
            this.debug("INVOKESTATIC java/lang/Boolean.valueOf");
            this.mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
        } else if (cls == Integer.TYPE || cls == Integer.class) {
            this.debug("INVOKESTATIC java/lang/Integer.valueOf");
            this.mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        } else if (cls == Float.TYPE || cls == Float.class) {
            this.debug("INVOKESTATIC java/lang/Float.valueOf");
            this.mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
        } else if (cls == Double.TYPE || cls == Double.class) {
            this.debug("INVOKESTATIC java/lang/Double.valueOf");
            this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
        } else if (cls == Short.TYPE || cls == Short.class) {
            this.debug("INVOKESTATIC java/lang/Short.valueOf");
            this.mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
        } else if (cls == Long.TYPE || cls == Long.class) {
            this.debug("INVOKESTATIC java/lang/Long.valueOf");
            this.mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        } else if (cls == Byte.TYPE || cls == Byte.class) {
            this.debug("INVOKESTATIC java/lang/Byte.valueOf");
            this.mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
        } else if (cls == Character.TYPE || cls == Character.class) {
            this.debug("INVOKESTATIC java/lang/Character.valueOf");
            this.mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
        }
    }

    private void anyArrayCheck(Class cls) {
        if (cls == boolean[].class) {
            assert (this.debug("CHECKCAST [Z"));
            this.mv.visitTypeInsn(192, "[Z");
        } else if (cls == int[].class) {
            assert (this.debug("CHECKCAST [I"));
            this.mv.visitTypeInsn(192, "[I");
        } else if (cls == float[].class) {
            assert (this.debug("CHECKCAST [F"));
            this.mv.visitTypeInsn(192, "[F");
        } else if (cls == double[].class) {
            assert (this.debug("CHECKCAST [D"));
            this.mv.visitTypeInsn(192, "[D");
        } else if (cls == short[].class) {
            assert (this.debug("CHECKCAST [S"));
            this.mv.visitTypeInsn(192, "[S");
        } else if (cls == long[].class) {
            assert (this.debug("CHECKCAST [J"));
            this.mv.visitTypeInsn(192, "[J");
        } else if (cls == byte[].class) {
            assert (this.debug("CHECKCAST [B"));
            this.mv.visitTypeInsn(192, "[B");
        } else if (cls == char[].class) {
            assert (this.debug("CHECKCAST [C"));
            this.mv.visitTypeInsn(192, "[C");
        } else {
            assert (this.debug("CHECKCAST [Ljava/lang/Object;"));
            this.mv.visitTypeInsn(192, "[Ljava/lang/Object;");
        }
    }

    private void writeOutLiteralWrapped(Object lit) {
        if (lit instanceof Integer) {
            this.intPush((Integer)lit);
            this.wrapPrimitive(Integer.TYPE);
            return;
        }
        assert (this.debug("LDC " + lit));
        if (lit instanceof String) {
            this.mv.visitLdcInsn(lit);
        } else if (lit instanceof Long) {
            this.mv.visitLdcInsn(lit);
            this.wrapPrimitive(Long.TYPE);
        } else if (lit instanceof Float) {
            this.mv.visitLdcInsn(lit);
            this.wrapPrimitive(Float.TYPE);
        } else if (lit instanceof Double) {
            this.mv.visitLdcInsn(lit);
            this.wrapPrimitive(Double.TYPE);
        } else if (lit instanceof Short) {
            this.mv.visitLdcInsn(lit);
            this.wrapPrimitive(Short.TYPE);
        } else if (lit instanceof Character) {
            this.mv.visitLdcInsn(lit);
            this.wrapPrimitive(Character.TYPE);
        } else if (lit instanceof Boolean) {
            this.mv.visitLdcInsn(lit);
            this.wrapPrimitive(Boolean.TYPE);
        } else if (lit instanceof Byte) {
            this.mv.visitLdcInsn(lit);
            this.wrapPrimitive(Byte.TYPE);
        }
    }

    public static int toPrimitiveTypeOperand(Class<?> c) {
        if (c == Integer.TYPE) {
            return 10;
        }
        if (c == Long.TYPE) {
            return 11;
        }
        if (c == Double.TYPE) {
            return 7;
        }
        if (c == Float.TYPE) {
            return 6;
        }
        if (c == Short.TYPE) {
            return 9;
        }
        if (c == Byte.TYPE) {
            return 8;
        }
        if (c == Character.TYPE) {
            return 5;
        }
        if (c == Boolean.TYPE) {
            return 4;
        }
        throw new IllegalStateException("Non-primitive type passed to toPrimitiveTypeOperand: " + c);
    }

    private void createArray(Class componentType, int length) {
        this.intPush(length);
        if (componentType.isPrimitive()) {
            assert (this.debug("NEWARRAY " + Type.getInternalName(componentType) + " (" + length + ")"));
            this.mv.visitIntInsn(188, ASMAccessorOptimizer.toPrimitiveTypeOperand(componentType));
        } else {
            assert (this.debug("ANEWARRAY " + Type.getInternalName(componentType) + " (" + length + ")"));
            this.mv.visitTypeInsn(189, Type.getInternalName(componentType));
        }
    }

    public void arrayStore(Class cls) {
        if (cls.isPrimitive()) {
            if (cls == Integer.TYPE) {
                assert (this.debug("IASTORE"));
                this.mv.visitInsn(79);
            } else if (cls == Character.TYPE) {
                assert (this.debug("CASTORE"));
                this.mv.visitInsn(85);
            } else if (cls == Boolean.TYPE) {
                assert (this.debug("BASTORE"));
                this.mv.visitInsn(84);
            } else if (cls == Double.TYPE) {
                assert (this.debug("DASTORE"));
                this.mv.visitInsn(82);
            } else if (cls == Float.TYPE) {
                assert (this.debug("FASTORE"));
                this.mv.visitInsn(81);
            } else if (cls == Short.TYPE) {
                assert (this.debug("SASTORE"));
                this.mv.visitInsn(86);
            } else if (cls == Long.TYPE) {
                assert (this.debug("LASTORE"));
                this.mv.visitInsn(80);
            } else if (cls == Byte.TYPE) {
                assert (this.debug("BASTORE"));
                this.mv.visitInsn(84);
            }
        } else {
            assert (this.debug("AASTORE"));
            this.mv.visitInsn(83);
        }
    }

    public void wrapRuntimeConverstion(Class toType) {
        this.ldcClassConstant(this.getWrapperClass(toType));
        assert (this.debug("INVOKESTATIC DataConversion.convert"));
        this.mv.visitMethodInsn(184, "" + NAMESPACE + "DataConversion", "convert", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
    }

    private Object addSubstatement(ExecutableStatement stmt) {
        this.compiledInputs.add(stmt);
        assert (this.debug("ALOAD 0"));
        this.mv.visitVarInsn(25, 0);
        assert (this.debug("GETFIELD p" + (this.compiledInputs.size() - 1)));
        this.mv.visitFieldInsn(180, this.className, "p" + (this.compiledInputs.size() - 1), "L" + NAMESPACE + "compiler/ExecutableStatement;");
        assert (this.debug("ALOAD 2"));
        this.mv.visitVarInsn(25, 2);
        assert (this.debug("ALOAD 3"));
        this.mv.visitVarInsn(25, 3);
        assert (this.debug("INVOKEINTERFACE ExecutableStatement.getValue"));
        this.mv.visitMethodInsn(185, Type.getInternalName(ExecutableStatement.class), "getValue", "(Ljava/lang/Object;L" + NAMESPACE + "integration/VariableResolverFactory;)Ljava/lang/Object;");
        return null;
    }

    private void loadVariableByName(String name) {
        assert (this.debug("ALOAD 3"));
        this.mv.visitVarInsn(25, 3);
        assert (this.debug("LDC \"" + name + "\""));
        this.mv.visitLdcInsn(name);
        assert (this.debug("INVOKEINTERFACE " + NAMESPACE + "integration/VariableResolverFactory.getVariableResolver"));
        this.mv.visitMethodInsn(185, "" + NAMESPACE + "integration/VariableResolverFactory", "getVariableResolver", "(Ljava/lang/String;)L" + NAMESPACE + "integration/VariableResolver;");
        assert (this.debug("INVOKEINTERFACE " + NAMESPACE + "integration/VariableResolver.getValue"));
        this.mv.visitMethodInsn(185, "" + NAMESPACE + "integration/VariableResolver", "getValue", "()Ljava/lang/Object;");
        this.returnType = Object.class;
    }

    private void loadVariableByIndex(int pos) {
        assert (this.debug("ALOAD 3"));
        this.mv.visitVarInsn(25, 3);
        assert (this.debug("PUSH IDX VAL =" + pos));
        this.intPush(pos);
        assert (this.debug("INVOKEINTERFACE " + NAMESPACE + "integration/VariableResolverFactory.getIndexedVariableResolver"));
        this.mv.visitMethodInsn(185, "" + NAMESPACE + "integration/VariableResolverFactory", "getIndexedVariableResolver", "(I)L" + NAMESPACE + "integration/VariableResolver;");
        assert (this.debug("INVOKEINTERFACE " + NAMESPACE + "integration/VariableResolver.getValue"));
        this.mv.visitMethodInsn(185, "" + NAMESPACE + "integration/VariableResolver", "getValue", "()Ljava/lang/Object;");
        this.returnType = Object.class;
    }

    private void loadField(int number) {
        assert (this.debug("ALOAD 0"));
        this.mv.visitVarInsn(25, 0);
        assert (this.debug("GETFIELD p" + number));
        this.mv.visitFieldInsn(180, this.className, "p" + number, "L" + NAMESPACE + "compiler/ExecutableStatement;");
    }

    private void ldcClassConstant(Class cls) {
        if (OPCODES_VERSION == 48) {
            assert (this.debug("LDC \"" + cls.getName() + "\""));
            this.mv.visitLdcInsn(cls.getName());
            this.mv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
            Label l4 = new Label();
            this.mv.visitJumpInsn(167, l4);
            this.mv.visitTypeInsn(187, "java/lang/NoClassDefFoundError");
            this.mv.visitInsn(90);
            this.mv.visitInsn(95);
            this.mv.visitMethodInsn(182, "java/lang/Throwable", "getMessage", "()Ljava/lang/String;");
            this.mv.visitMethodInsn(183, "java/lang/NoClassDefFoundError", "<init>", "(Ljava/lang/String;)V");
            this.mv.visitInsn(191);
            this.mv.visitLabel(l4);
        } else {
            assert (this.debug("LDC " + Type.getType(cls)));
            this.mv.visitLdcInsn(Type.getType(cls));
        }
    }

    private void buildInputs() {
        if (this.compiledInputs.size() == 0) {
            return;
        }
        assert (this.debug("\n{SETTING UP MEMBERS...}\n"));
        StringAppender constSig = new StringAppender("(");
        int size = this.compiledInputs.size();
        for (int i = 0; i < size; ++i) {
            assert (this.debug("ACC_PRIVATE p" + i));
            this.cw.visitField(2, "p" + i, "L" + NAMESPACE + "compiler/ExecutableStatement;", null, null).visitEnd();
            constSig.append("L" + NAMESPACE + "compiler/ExecutableStatement;");
        }
        constSig.append(")V");
        assert (this.debug("\n{CREATING INJECTION CONSTRUCTOR}\n"));
        MethodVisitor cv = this.cw.visitMethod(1, "<init>", constSig.toString(), null, null);
        cv.visitCode();
        assert (this.debug("ALOAD 0"));
        cv.visitVarInsn(25, 0);
        assert (this.debug("INVOKESPECIAL java/lang/Object.<init>"));
        cv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        for (int i = 0; i < size; ++i) {
            assert (this.debug("ALOAD 0"));
            cv.visitVarInsn(25, 0);
            assert (this.debug("ALOAD " + (i + 1)));
            cv.visitVarInsn(25, i + 1);
            assert (this.debug("PUTFIELD p" + i));
            cv.visitFieldInsn(181, this.className, "p" + i, "L" + NAMESPACE + "compiler/ExecutableStatement;");
        }
        assert (this.debug("RETURN"));
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
        cv.visitEnd();
        assert (this.debug("}"));
    }

    private int _getAccessor(Object o, Class type) {
        if (o instanceof List) {
            assert (this.debug("NEW " + LIST_IMPL));
            this.mv.visitTypeInsn(187, LIST_IMPL);
            assert (this.debug("DUP"));
            this.mv.visitInsn(89);
            assert (this.debug("DUP"));
            this.mv.visitInsn(89);
            this.intPush(((List)o).size());
            assert (this.debug("INVOKESPECIAL " + LIST_IMPL + ".<init>"));
            this.mv.visitMethodInsn(183, LIST_IMPL, "<init>", "(I)V");
            for (Object item : (List)o) {
                if (this._getAccessor(item, type) != 3) {
                    assert (this.debug("POP"));
                    this.mv.visitInsn(87);
                }
                assert (this.debug("INVOKEINTERFACE java/util/List.add"));
                this.mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z");
                assert (this.debug("POP"));
                this.mv.visitInsn(87);
                assert (this.debug("DUP"));
                this.mv.visitInsn(89);
            }
            this.returnType = List.class;
            return 1;
        }
        if (o instanceof Map) {
            assert (this.debug("NEW java/util/HashMap"));
            this.mv.visitTypeInsn(187, MAP_IMPL);
            assert (this.debug("DUP"));
            this.mv.visitInsn(89);
            assert (this.debug("DUP"));
            this.mv.visitInsn(89);
            this.intPush(((Map)o).size());
            assert (this.debug("INVOKESPECIAL java/util/HashMap.<init>"));
            this.mv.visitMethodInsn(183, MAP_IMPL, "<init>", "(I)V");
            for (Object item : ((Map)o).keySet()) {
                this.mv.visitTypeInsn(192, "java/util/Map");
                if (this._getAccessor(item, type) != 3) {
                    assert (this.debug("POP"));
                    this.mv.visitInsn(87);
                }
                if (this._getAccessor(((Map)o).get(item), type) != 3) {
                    assert (this.debug("POP"));
                    this.mv.visitInsn(87);
                }
                assert (this.debug("INVOKEINTERFACE java/util/Map.put"));
                this.mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                assert (this.debug("POP"));
                this.mv.visitInsn(87);
                assert (this.debug("DUP"));
                this.mv.visitInsn(89);
            }
            this.returnType = Map.class;
            return 2;
        }
        if (o instanceof Object[]) {
            Accessor[] a = new Accessor[((Object[])o).length];
            int i = 0;
            int dim = 0;
            if (type != null) {
                String nm = type.getName();
                while (nm.charAt(dim) == '[') {
                    ++dim;
                }
            } else {
                type = Object[].class;
                dim = 1;
            }
            try {
                Class cls;
                Class componentType = ParseTools.getSubComponentType(type);
                this.createArray(componentType, ((Object[])o).length);
                Class clazz = cls = dim > 1 ? ParseTools.findClass(null, ParseTools.repeatChar('[', dim - 1) + "L" + ParseTools.getBaseComponentType(type).getName() + ";", this.pCtx) : ReflectionUtil.toNonPrimitiveArray(type);
                assert (this.debug("DUP"));
                this.mv.visitInsn(89);
                for (Object item : (Object[])o) {
                    this.intPush(i);
                    if (this._getAccessor(item, cls) != 3) {
                        assert (this.debug("POP"));
                        this.mv.visitInsn(87);
                    }
                    if (componentType.isPrimitive()) {
                        this.unwrapPrimitive(componentType);
                    }
                    this.arrayStore(componentType);
                    assert (this.debug("DUP"));
                    this.mv.visitInsn(89);
                    ++i;
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("this error should never throw:" + ParseTools.getBaseComponentType(type).getName(), e);
            }
            return 0;
        }
        if (type.isArray()) {
            this.writeLiteralOrSubexpression(ParseTools.subCompileExpression(((String)o).toCharArray(), this.pCtx), ParseTools.getSubComponentType(type));
        } else {
            this.writeLiteralOrSubexpression(ParseTools.subCompileExpression(((String)o).toCharArray(), this.pCtx));
        }
        return 3;
    }

    private Class writeLiteralOrSubexpression(Object stmt) {
        return this.writeLiteralOrSubexpression(stmt, null, null);
    }

    private Class writeLiteralOrSubexpression(Object stmt, Class desiredTarget) {
        return this.writeLiteralOrSubexpression(stmt, desiredTarget, null);
    }

    private Class writeLiteralOrSubexpression(Object stmt, Class desiredTarget, Class knownIngressType) {
        if (stmt instanceof ExecutableLiteral) {
            Class<Object> type;
            Object literalValue = ((ExecutableLiteral)stmt).getLiteral();
            if (literalValue == null) {
                this.mv.visitInsn(1);
                return null;
            }
            Class<Object> clazz = type = literalValue == null ? desiredTarget : literalValue.getClass();
            assert (this.debug("*** type:" + type + ";desired:" + desiredTarget));
            if (type == Integer.class && desiredTarget == Integer.TYPE) {
                this.intPush(((ExecutableLiteral)stmt).getInteger32());
                type = Integer.TYPE;
            } else if (desiredTarget != null && desiredTarget != type) {
                assert (this.debug("*** Converting because desiredType(" + desiredTarget.getClass() + ") is not: " + type));
                if (!DataConversion.canConvert(type, desiredTarget)) {
                    throw new CompileException("was expecting type: " + desiredTarget.getName() + "; but found type: " + type.getName(), this.expr, this.st);
                }
                this.writeOutLiteralWrapped(DataConversion.convert(literalValue, desiredTarget));
            } else {
                this.writeOutLiteralWrapped(literalValue);
            }
            return type;
        }
        this.literal = false;
        this.addSubstatement((ExecutableStatement)stmt);
        Class type = knownIngressType == null ? ((ExecutableStatement)stmt).getKnownEgressType() : knownIngressType;
        if (desiredTarget != null && type != desiredTarget && desiredTarget.isPrimitive()) {
            if (type == null) {
                throw new OptimizationFailure("cannot optimize expression: " + new String(this.expr) + ": cannot determine ingress type for primitive output");
            }
            this.checkcast(type);
            this.unwrapPrimitive(desiredTarget);
        }
        return type;
    }

    private void addPrintOut(String text) {
        this.mv.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
        this.mv.visitLdcInsn(text);
        this.mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V");
    }

    @Override
    public Accessor optimizeCollection(ParserContext pCtx, Object o, Class type, char[] property, int start, int offset, Object ctx, Object thisRef, VariableResolverFactory factory) {
        this.expr = property;
        this.cursor = this.start = start;
        this.end = start + offset;
        this.length = offset;
        this.returnType = type;
        this.compiledInputs = new ArrayList();
        this.ctx = ctx;
        this.thisRef = thisRef;
        this.variableFactory = factory;
        this.pCtx = pCtx;
        this._initJIT();
        this.literal = true;
        this._getAccessor(o, type);
        this._finishJIT();
        try {
            Accessor compiledAccessor = this._initializeAccessor();
            if (property != null && this.length > start) {
                return new Union(pCtx, compiledAccessor, property, start, this.length);
            }
            return compiledAccessor;
        }
        catch (Exception e) {
            throw new OptimizationFailure("could not optimize collection", e);
        }
    }

    private void checkcast(Class cls) {
        assert (this.debug("CHECKCAST " + Type.getInternalName(cls)));
        this.mv.visitTypeInsn(192, Type.getInternalName(cls));
    }

    private void intPush(int index) {
        if (index >= 0 && index < 6) {
            switch (index) {
                case 0: {
                    assert (this.debug("ICONST_0"));
                    this.mv.visitInsn(3);
                    break;
                }
                case 1: {
                    assert (this.debug("ICONST_1"));
                    this.mv.visitInsn(4);
                    break;
                }
                case 2: {
                    assert (this.debug("ICONST_2"));
                    this.mv.visitInsn(5);
                    break;
                }
                case 3: {
                    assert (this.debug("ICONST_3"));
                    this.mv.visitInsn(6);
                    break;
                }
                case 4: {
                    assert (this.debug("ICONST_4"));
                    this.mv.visitInsn(7);
                    break;
                }
                case 5: {
                    assert (this.debug("ICONST_5"));
                    this.mv.visitInsn(8);
                }
            }
        } else if (index > -127 && index < 128) {
            assert (this.debug("BIPUSH " + index));
            this.mv.visitIntInsn(16, index);
        } else if (index > Short.MAX_VALUE) {
            assert (this.debug("LDC " + index));
            this.mv.visitLdcInsn(index);
        } else {
            assert (this.debug("SIPUSH " + index));
            this.mv.visitIntInsn(17, index);
        }
    }

    @Override
    public Accessor optimizeObjectCreation(ParserContext pCtx, char[] property, int start, int offset, Object ctx, Object thisRef, VariableResolverFactory factory) {
        this._initJIT();
        this.compiledInputs = new ArrayList();
        this.start = this.cursor = start;
        this.end = start + offset;
        this.length = this.end - this.start;
        this.ctx = ctx;
        this.thisRef = thisRef;
        this.variableFactory = factory;
        this.pCtx = pCtx;
        String[] cnsRes = ParseTools.captureContructorAndResidual(property, start, offset);
        List<char[]> constructorParms = ParseTools.parseMethodOrConstructor(cnsRes[0].toCharArray());
        try {
            if (constructorParms != null) {
                for (char[] constructorParm : constructorParms) {
                    this.compiledInputs.add((ExecutableStatement)ParseTools.subCompileExpression(constructorParm, pCtx));
                }
                Class cls = ParseTools.findClass(factory, new String(ParseTools.subset(property, 0, ArrayTools.findFirst('(', start, this.length, property))), pCtx);
                assert (this.debug("NEW " + Type.getInternalName(cls)));
                this.mv.visitTypeInsn(187, Type.getInternalName(cls));
                assert (this.debug("DUP"));
                this.mv.visitInsn(89);
                Object[] parms = new Object[constructorParms.size()];
                int i = 0;
                for (ExecutableStatement es : this.compiledInputs) {
                    parms[i++] = es.getValue(ctx, factory);
                }
                Constructor cns = ParseTools.getBestConstructorCandidate(parms, cls, pCtx.isStrongTyping());
                if (cns == null) {
                    StringBuilder error = new StringBuilder();
                    for (int x = 0; x < parms.length; ++x) {
                        error.append(parms[x].getClass().getName());
                        if (x + 1 >= parms.length) continue;
                        error.append(", ");
                    }
                    throw new CompileException("unable to find constructor: " + cls.getName() + "(" + error.toString() + ")", this.expr, this.st);
                }
                this.returnType = cns.getDeclaringClass();
                Class<?>[] parameterTypes = cns.getParameterTypes();
                Class paramType = null;
                int vaStart = -1;
                for (i = 0; i < constructorParms.size(); ++i) {
                    Class tg;
                    if (i < parameterTypes.length) {
                        paramType = parameterTypes[i];
                        if (cns.isVarArgs() && i == parameterTypes.length - 1) {
                            paramType = ParseTools.getBaseComponentType(paramType);
                            vaStart = i;
                            this.createArray(paramType, constructorParms.size() - vaStart);
                        }
                    } else if (vaStart < 0 || paramType == null) {
                        throw new IllegalStateException("Incorrect argument count " + i);
                    }
                    if (vaStart >= 0) {
                        assert (this.debug("DUP"));
                        this.mv.visitInsn(89);
                        this.intPush(i - vaStart);
                    }
                    assert (this.debug("ALOAD 0"));
                    this.mv.visitVarInsn(25, 0);
                    assert (this.debug("GETFIELD p" + i));
                    this.mv.visitFieldInsn(180, this.className, "p" + i, "L" + NAMESPACE + "compiler/ExecutableStatement;");
                    assert (this.debug("ALOAD 2"));
                    this.mv.visitVarInsn(25, 2);
                    assert (this.debug("ALOAD 3"));
                    this.mv.visitVarInsn(25, 3);
                    assert (this.debug("INVOKEINTERFACE " + NAMESPACE + "compiler/ExecutableStatement.getValue"));
                    this.mv.visitMethodInsn(185, "" + NAMESPACE + "compiler/ExecutableStatement", "getValue", "(Ljava/lang/Object;L" + NAMESPACE + "integration/VariableResolverFactory;)Ljava/lang/Object;");
                    Class clazz = tg = paramType.isPrimitive() ? this.getWrapperClass(paramType) : paramType;
                    if (parms[i] != null && !parms[i].getClass().isAssignableFrom(paramType)) {
                        this.ldcClassConstant(tg);
                        assert (this.debug("INVOKESTATIC " + NAMESPACE + "DataConversion.convert"));
                        this.mv.visitMethodInsn(184, "" + NAMESPACE + "DataConversion", "convert", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
                        if (paramType.isPrimitive()) {
                            this.unwrapPrimitive(paramType);
                        } else {
                            assert (this.debug("CHECKCAST " + Type.getInternalName(tg)));
                            this.mv.visitTypeInsn(192, Type.getInternalName(tg));
                        }
                    } else {
                        assert (this.debug("CHECKCAST " + Type.getInternalName(paramType)));
                        this.mv.visitTypeInsn(192, Type.getInternalName(paramType));
                    }
                    if (vaStart < 0) continue;
                    this.arrayStore(paramType);
                }
                if (i < parameterTypes.length && cns.isVarArgs()) {
                    this.createArray(ParseTools.getBaseComponentType(parameterTypes[i]), 0);
                }
                assert (this.debug("INVOKESPECIAL " + Type.getInternalName(cls) + ".<init> : " + Type.getConstructorDescriptor(cns)));
                this.mv.visitMethodInsn(183, Type.getInternalName(cls), "<init>", Type.getConstructorDescriptor(cns));
                this._finishJIT();
                Accessor acc = this._initializeAccessor();
                if (cnsRes.length > 1 && cnsRes[1] != null && !cnsRes[1].trim().equals("")) {
                    return new Union(pCtx, acc, cnsRes[1].toCharArray(), 0, cnsRes[1].length());
                }
                return acc;
            }
            Class cls = ParseTools.findClass(factory, new String(property), pCtx);
            assert (this.debug("NEW " + Type.getInternalName(cls)));
            this.mv.visitTypeInsn(187, Type.getInternalName(cls));
            assert (this.debug("DUP"));
            this.mv.visitInsn(89);
            Constructor cns = cls.getConstructor(EMPTYCLS);
            assert (this.debug("INVOKESPECIAL <init>"));
            this.mv.visitMethodInsn(183, Type.getInternalName(cls), "<init>", Type.getConstructorDescriptor(cns));
            this._finishJIT();
            Accessor acc = this._initializeAccessor();
            if (cnsRes.length > 1 && cnsRes[1] != null && !cnsRes[1].trim().equals("")) {
                return new Union(pCtx, acc, cnsRes[1].toCharArray(), 0, cnsRes[1].length());
            }
            return acc;
        }
        catch (ClassNotFoundException e) {
            throw new CompileException("class or class reference not found: " + new String(property), property, this.st);
        }
        catch (Exception e) {
            throw new OptimizationFailure("could not optimize construtor: " + new String(property), e);
        }
    }

    @Override
    public Class getEgressType() {
        return this.returnType;
    }

    private void dumpAdvancedDebugging() {
        if (this.buildLog == null) {
            return;
        }
        System.out.println("JIT Compiler Dump for: <<" + (this.expr == null ? null : new String(this.expr)) + ">>\n-------------------------------\n");
        System.out.println(this.buildLog.toString());
        System.out.println("\n<END OF DUMP>\n");
        if (MVEL.isFileDebugging()) {
            try {
                FileWriter writer = ParseTools.getDebugFileWriter();
                writer.write(this.buildLog.toString());
                writer.flush();
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private Object propHandlerByteCode(String property, Object ctx, Class handler) {
        PropertyHandler ph = PropertyHandlerFactory.getPropertyHandler(handler);
        if (ph instanceof ProducesBytecode) {
            assert (this.debug("<<3rd-Party Code Generation>>"));
            ((ProducesBytecode)((Object)ph)).produceBytecodeGet(this.mv, property, this.variableFactory);
            return ph.getProperty(property, ctx, this.variableFactory);
        }
        throw new RuntimeException("unable to compileShared: custom accessor does not support producing bytecode: " + ph.getClass().getName());
    }

    private void propHandlerByteCodePut(String property, Object ctx, Class handler, Object value) {
        PropertyHandler ph = PropertyHandlerFactory.getPropertyHandler(handler);
        if (ph instanceof ProducesBytecode) {
            assert (this.debug("<<3rd-Party Code Generation>>"));
        } else {
            throw new RuntimeException("unable to compileShared: custom accessor does not support producing bytecode: " + ph.getClass().getName());
        }
        ((ProducesBytecode)((Object)ph)).produceBytecodePut(this.mv, property, this.variableFactory);
        ph.setProperty(property, ctx, this.variableFactory, value);
    }

    private void writeOutNullHandler(Member member, int type) {
        assert (this.debug("DUP"));
        this.mv.visitInsn(89);
        Label j = new Label();
        assert (this.debug("IFNONNULL : jump"));
        this.mv.visitJumpInsn(199, j);
        assert (this.debug("POP"));
        this.mv.visitInsn(87);
        assert (this.debug("ALOAD 0"));
        this.mv.visitVarInsn(25, 0);
        if (type == 0) {
            this.propNull = true;
            assert (this.debug("GETFIELD 'nullPropertyHandler'"));
            this.mv.visitFieldInsn(180, this.className, "nullPropertyHandler", "L" + NAMESPACE + "integration/PropertyHandler;");
        } else {
            this.methNull = true;
            assert (this.debug("GETFIELD 'nullMethodHandler'"));
            this.mv.visitFieldInsn(180, this.className, "nullMethodHandler", "L" + NAMESPACE + "integration/PropertyHandler;");
        }
        assert (this.debug("LDC '" + member.getName() + "'"));
        this.mv.visitLdcInsn(member.getName());
        assert (this.debug("ALOAD 1"));
        this.mv.visitVarInsn(25, 1);
        assert (this.debug("ALOAD 3"));
        this.mv.visitVarInsn(25, 3);
        assert (this.debug("INVOKEINTERFACE PropertyHandler.getProperty"));
        this.mv.visitMethodInsn(185, NAMESPACE + "integration/PropertyHandler", "getProperty", "(Ljava/lang/String;Ljava/lang/Object;L" + NAMESPACE + "integration/VariableResolverFactory;)Ljava/lang/Object;");
        assert (this.debug("LABEL:jump"));
        this.mv.visitLabel(j);
    }

    @Override
    public boolean isLiteralOnly() {
        return this.literal;
    }

    static {
        String javaVersion = PropertyTools.getJavaVersion();
        OPCODES_VERSION = javaVersion.startsWith("1.4") ? 48 : (javaVersion.startsWith("1.5") ? 49 : 50);
        String defaultNameSapce = System.getProperty("mvel2.namespace");
        NAMESPACE = defaultNameSapce == null ? "net/william278/velocitab/libraries/mvel2/" : defaultNameSapce;
        String jitListImpl = System.getProperty("mvel2.jit.list_impl");
        LIST_IMPL = jitListImpl == null ? NAMESPACE + "util/FastList" : jitListImpl;
        EMPTYARG = new Object[0];
        EMPTYCLS = new Class[0];
    }

    private static class ContextClassLoader
    extends ClassLoader {
        ContextClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        Class<?> defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }
    }
}

