/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.toilet.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.william278.velocitab.libraries.annotations.NotNull;

public final class FileReaderUtil {
    private static final String LINE_DELIMITER = "\n";

    @NotNull
    public static String readLargeFile(@NotNull Path file, int numLines) throws IOException {
        AtomicInteger offset = new AtomicInteger();
        String[] lines = new String[numLines];
        try (Stream<String> stream = Files.lines(file);){
            stream.forEach(line -> {
                lines[offset.getAndIncrement() % numLines] = line;
            });
            String string = IntStream.range(offset.get() < numLines ? 0 : offset.get() - numLines, offset.get()).mapToObj(idx -> lines[idx % numLines]).collect(Collectors.joining(LINE_DELIMITER));
            return string;
        }
    }
}

