/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;

public class DebugSystem {
    private static final ConcurrentLinkedQueue<LogEntry> logs = new ConcurrentLinkedQueue();
    private static final int MAX_LOGS = 10000;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final int REMOVE_HOURS = 6;

    public static void log(@NotNull DebugLevel level, @NotNull String message) {
        logs.add(new LogEntry(Thread.currentThread().getName(), level, message));
        if (logs.size() > 10000) {
            logs.poll();
        }
    }

    public static void log(@NotNull DebugLevel level, @NotNull String message, Object ... args) {
        logs.add(new LogEntry(Thread.currentThread().getName(), level, DebugSystem.formatMessage(message, args)));
        if (logs.size() > 10000) {
            logs.poll();
        }
    }

    @NotNull
    private static String formatMessage(@NotNull String message, Object ... args) {
        StringBuilder formattedMessage = new StringBuilder();
        int argIndex = 0;
        for (int i = 0; i < message.length(); ++i) {
            if (message.charAt(i) == '{' && i + 1 < message.length() && message.charAt(i + 1) == '}') {
                formattedMessage.append(argIndex < args.length ? args[argIndex++] : "{}");
                ++i;
                continue;
            }
            formattedMessage.append(message.charAt(i));
        }
        return formattedMessage.toString();
    }

    @NotNull
    public static String getLogsAsString() {
        StringBuilder logBuilder = new StringBuilder();
        for (LogEntry entry : logs) {
            logBuilder.append(entry.format()).append("\n");
        }
        return logBuilder.toString();
    }

    private static void removeLogsOlderThan() {
        long cutoffTime = System.currentTimeMillis() - 21600000L;
        Iterator<LogEntry> iterator = logs.iterator();
        while (iterator.hasNext()) {
            LogEntry entry = iterator.next();
            if (entry.timestamp >= cutoffTime) break;
            iterator.remove();
        }
    }

    public static void initializeTask(@NotNull Velocitab plugin) {
        plugin.getServer().getScheduler().buildTask((Object)plugin, DebugSystem::removeLogsOlderThan).delay(6L, TimeUnit.HOURS).repeat(6L, TimeUnit.HOURS).schedule();
    }

    private static class LogEntry {
        final long timestamp = System.currentTimeMillis();
        final String threadName;
        final DebugLevel level;
        final String message;

        LogEntry(@NotNull String threadName, @NotNull DebugLevel level, @NotNull String message) {
            this.threadName = threadName;
            this.level = level;
            this.message = message;
        }

        @NotNull
        public String format() {
            return "[" + DATE_FORMAT.format(new Date(this.timestamp)) + "] [" + this.threadName + "/" + String.valueOf((Object)this.level) + "]: " + this.message;
        }
    }

    public static enum DebugLevel {
        INFO,
        WARNING,
        ERROR,
        DEBUG;

    }
}

