/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.mvel2.ast;

import net.william278.velocitab.libraries.mvel2.MVEL;
import net.william278.velocitab.libraries.mvel2.ParserContext;
import net.william278.velocitab.libraries.mvel2.ast.ASTNode;
import net.william278.velocitab.libraries.mvel2.ast.Assignment;
import net.william278.velocitab.libraries.mvel2.ast.Proto;
import net.william278.velocitab.libraries.mvel2.compiler.ExecutableStatement;
import net.william278.velocitab.libraries.mvel2.integration.VariableResolverFactory;
import net.william278.velocitab.libraries.mvel2.util.ParseTools;

public class ProtoVarNode
extends ASTNode
implements Assignment {
    private String name;
    private ExecutableStatement statement;

    public ProtoVarNode(char[] expr, int start, int offset, int fields, Proto type, ParserContext pCtx) {
        super(pCtx);
        this.egressType = Proto.ProtoInstance.class;
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        this.fields = fields;
        this.expr = expr;
        int assignStart = ParseTools.find(expr, start, offset, '=');
        if (assignStart != -1) {
            this.name = ParseTools.createStringTrimmed(expr, 0, assignStart);
            ParseTools.checkNameSafety(this.name);
            if (((fields |= 0x80) & 0x10) != 0) {
                this.statement = (ExecutableStatement)ParseTools.subCompileExpression(expr, assignStart + 1, offset, pCtx);
            }
        } else {
            this.name = new String(expr, start, offset);
            ParseTools.checkNameSafety(this.name);
        }
        if ((fields & 0x10) != 0) {
            pCtx.addVariable(this.name, this.egressType, true);
        }
    }

    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.statement == null) {
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.expr, this.start, this.offset, this.pCtx);
        }
        ctx = this.statement.getValue(ctx, thisValue, factory);
        factory.createVariable(this.name, ctx, this.egressType);
        return ctx;
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ctx = MVEL.eval(this.expr, this.start, this.offset, thisValue, factory);
        factory.createVariable(this.name, ctx, this.egressType);
        return ctx;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAssignmentVar() {
        return this.name;
    }

    @Override
    public char[] getExpression() {
        return this.expr;
    }

    @Override
    public boolean isNewDeclaration() {
        return true;
    }

    @Override
    public void setValueStatement(ExecutableStatement stmt) {
        this.statement = stmt;
    }
}

