/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.placeholder;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.annotations.Nullable;
import net.william278.velocitab.libraries.expiringmap.ExpiringMap;
import net.william278.velocitab.libraries.mvel2.MVEL;
import net.william278.velocitab.player.TabPlayer;

public class ConditionManager {
    private static final String VELOCITAB_REL_CONDITION = "velocitab_rel_condition:";
    private static final String VELOCITAB_CONDITION = "velocitab_condition:";
    private static final String VELOCITAB_REL_PLACEHOLDER_PERM = "velocitab_rel_perm:";
    private static final String VELOCITAB_REL_WHO_IS_SEEING = "velocitab_rel_who-is-seeing";
    private static final String VELOCITAB_REL_VANISH = "velocitab_rel_vanish";
    private final Velocitab plugin;
    private final Pattern targetPlaceholderPattern;
    private final Pattern miniEscapeEndTags;
    private final Map<String, Object> cachedExpressions;
    private static final Map<String, String> REPLACE_CHARS = Map.of("?dp?", ":");

    public ConditionManager(@NotNull Velocitab plugin) {
        this.plugin = plugin;
        this.targetPlaceholderPattern = Pattern.compile("%target_(\\w+)?%");
        this.miniEscapeEndTags = Pattern.compile("</(\\w+)>");
        this.cachedExpressions = ExpiringMap.builder().expiration(5L, TimeUnit.MINUTES).build();
    }

    @NotNull
    public String checkConditions(@NotNull TabPlayer target, @NotNull String argument) {
        List<String> parameters = this.collectParameters(argument);
        if (parameters.isEmpty()) {
            this.plugin.getLogger().warn("Empty condition");
            return "";
        }
        String condition = parameters.get(0);
        if (parameters.size() < 3) {
            this.plugin.getLogger().warn("Invalid condition: Missing true/false values for condition: {}. Parameters: {}", (Object)condition, parameters);
            return "";
        }
        condition = this.plugin.getPlaceholderManager().applyPlaceholders(target, condition);
        String falseValue = this.processFalseValue(parameters.get(2));
        String expression = this.buildExpression(condition);
        return this.evaluateAndFormatCondition(expression, target, parameters.get(1), falseValue);
    }

    @NotNull
    private List<String> collectParameters(@NotNull String argument) {
        for (Map.Entry<String, String> entry : REPLACE_CHARS.entrySet()) {
            argument = argument.replace(entry.getKey(), entry.getValue());
        }
        return Arrays.stream(argument.split(":")).map(s -> s.replace("''", "\"")).toList();
    }

    @NotNull
    private String processFalseValue(@NotNull String falseValue) {
        String tag;
        Matcher matcher = this.miniEscapeEndTags.matcher(falseValue);
        if (matcher.find() && falseValue.startsWith("</" + (tag = matcher.group(1)) + ">")) {
            falseValue = falseValue.substring(tag.length() + 3);
        }
        return falseValue;
    }

    @NotNull
    private String buildExpression(@NotNull String condition) {
        return condition.replace("and", "&&").replace("or", "||").replace("AND", "&&").replace("OR", "||");
    }

    @NotNull
    private String evaluateAndFormatCondition(@NotNull String expression, @NotNull TabPlayer target, @NotNull String trueValue, @NotNull String falseValue) {
        String targetString = this.parseTargetPlaceholders(expression, target).trim();
        try {
            Object result = this.evaluateExpression(targetString);
            if (result instanceof Boolean) {
                boolean boolResult = (Boolean)result;
                return boolResult ? trueValue : falseValue;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warn("Failed to evaluate condition: {} error: {}", (Object)expression, (Object)e.getMessage());
        }
        return "";
    }

    @NotNull
    private Object evaluateExpression(@NotNull String expression) {
        return this.cachedExpressions.computeIfAbsent(expression, MVEL::eval);
    }

    @NotNull
    private String parseTargetPlaceholders(@NotNull String input, @NotNull TabPlayer target) {
        return this.targetPlaceholderPattern.matcher(input).replaceAll(match -> {
            String placeholder = match.group(1);
            if (placeholder == null) {
                return "";
            }
            String text = "%" + placeholder + "%";
            Optional<String> placeholderValue = this.plugin.getPlaceholderManager().getCachedPlaceholderValue(text, target.getPlayer().getUniqueId());
            return placeholderValue.orElse(text);
        });
    }

    public String handleVelocitabPlaceholders(@NotNull String text, @NotNull TabPlayer player, @Nullable TabPlayer viewer) {
        if (viewer == null) {
            return this.handleConditionPlaceholders(text, player);
        }
        return this.handleRelPlaceholders(text, player, viewer);
    }

    @NotNull
    private String handleRelPlaceholders(@NotNull String text, @NotNull TabPlayer player, @NotNull TabPlayer viewer) {
        switch (text) {
            case "velocitab_rel_who-is-seeing": {
                viewer.getPlayer().getUsername();
                break;
            }
            case "velocitab_rel_vanish": {
                if (this.plugin.getVanishManager().isVanished(viewer.getPlayer().getUsername())) {
                    return "true";
                }
                return "false";
            }
        }
        if (text.length() < VELOCITAB_REL_CONDITION.length()) {
            return text;
        }
        if (text.startsWith(VELOCITAB_REL_CONDITION)) {
            return this.checkConditions(player, text.substring(VELOCITAB_REL_CONDITION.length()));
        }
        if (text.startsWith(VELOCITAB_REL_PLACEHOLDER_PERM)) {
            String cleaned = text.substring(VELOCITAB_REL_PLACEHOLDER_PERM.length());
            int firstSeparator = cleaned.indexOf(58);
            if (firstSeparator == -1) {
                return "";
            }
            String permission = cleaned.substring(0, firstSeparator);
            String trueValue = cleaned.substring(firstSeparator + 1);
            return viewer.getPlayer().hasPermission(permission) ? trueValue : "";
        }
        return text;
    }

    @NotNull
    private String handleConditionPlaceholders(@NotNull String text, @NotNull TabPlayer player) {
        if (text.startsWith(VELOCITAB_CONDITION)) {
            return this.checkConditions(player, text.substring(VELOCITAB_CONDITION.length()));
        }
        return text;
    }
}

