/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.tab;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.player.TabListEntry;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.tab.PlayerTabList;

public class VanishTabList {
    private final Velocitab plugin;
    private final PlayerTabList tabList;

    public void vanishPlayer(@NotNull TabPlayer tabPlayer) {
        this.tabList.getPlayers().values().forEach(p -> {
            if (p.getPlayer().equals(tabPlayer.getPlayer())) {
                return;
            }
            if (!this.plugin.getVanishManager().canSee(p.getPlayer().getUsername(), tabPlayer.getPlayer().getUsername())) {
                p.getPlayer().getTabList().removeEntry(tabPlayer.getPlayer().getUniqueId());
            }
        });
    }

    public void unVanishPlayer(@NotNull TabPlayer tabPlayer) {
        UUID uuid = tabPlayer.getPlayer().getUniqueId();
        this.tabList.getPlayers().values().forEach(p -> {
            if (p.getPlayer().equals(tabPlayer.getPlayer())) {
                return;
            }
            if (!p.getPlayer().getTabList().containsEntry(uuid)) {
                this.tabList.createEntry(tabPlayer, p.getPlayer().getTabList(), (TabPlayer)p);
            } else {
                this.tabList.calculateAndSetDisplayName(tabPlayer, (TabPlayer)p);
            }
        });
    }

    public void recalculateVanishForPlayer(@NotNull TabPlayer tabPlayer) {
        Player player = tabPlayer.getPlayer();
        this.plugin.getServer().getAllPlayers().forEach(p -> {
            boolean canSee;
            if (p.equals(player)) {
                return;
            }
            Optional<TabPlayer> targetOptional = this.tabList.getTabPlayer((Player)p);
            if (targetOptional.isEmpty()) {
                return;
            }
            TabPlayer target = targetOptional.get();
            String serverName = target.getServerName();
            if (tabPlayer.getGroup().onlyListPlayersInSameServer() && !tabPlayer.getServerName().equals(serverName)) {
                return;
            }
            if (!p.isActive() || !target.isLoaded()) {
                return;
            }
            boolean bl = canSee = !this.plugin.getVanishManager().isVanished(p.getUsername()) || this.plugin.getVanishManager().canSee(player.getUsername(), p.getUsername());
            if (!canSee) {
                player.getTabList().removeEntry(p.getUniqueId());
                this.plugin.getScoreboardManager().recalculateVanishForPlayer(tabPlayer, target, false);
            } else if (!player.getTabList().containsEntry(p.getUniqueId())) {
                TabListEntry tabListEntry = this.tabList.createEntry(target, player.getTabList(), tabPlayer);
                player.getTabList().addEntry(tabListEntry);
                this.plugin.getScoreboardManager().recalculateVanishForPlayer(tabPlayer, target, true);
            }
        });
    }

    @Generated
    public VanishTabList(Velocitab plugin, PlayerTabList tabList) {
        this.plugin = plugin;
        this.tabList = tabList;
    }
}

