/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.mvel2.compiler;

import java.io.Serializable;
import net.william278.velocitab.libraries.mvel2.MVELRuntime;
import net.william278.velocitab.libraries.mvel2.ParserConfiguration;
import net.william278.velocitab.libraries.mvel2.ast.ASTNode;
import net.william278.velocitab.libraries.mvel2.ast.TypeCast;
import net.william278.velocitab.libraries.mvel2.compiler.ExecutableStatement;
import net.william278.velocitab.libraries.mvel2.integration.VariableResolverFactory;
import net.william278.velocitab.libraries.mvel2.optimizers.OptimizerFactory;
import net.william278.velocitab.libraries.mvel2.util.ASTLinkedList;

public class CompiledExpression
implements Serializable,
ExecutableStatement {
    private final ASTNode firstNode;
    private Class knownEgressType;
    private Class knownIngressType;
    private boolean convertableIngressEgress;
    private boolean optimized = false;
    private final boolean literalOnly;
    private final String sourceName;
    private final ParserConfiguration parserConfiguration;

    public CompiledExpression(ASTLinkedList astMap, String sourceName, Class egressType, ParserConfiguration parserConfiguration, boolean literalOnly) {
        this.firstNode = astMap.firstNode();
        this.sourceName = sourceName;
        this.knownEgressType = astMap.isSingleNode() ? astMap.firstNonSymbol().getEgressType() : egressType;
        this.literalOnly = literalOnly;
        this.parserConfiguration = parserConfiguration;
    }

    public ASTNode getFirstNode() {
        return this.firstNode;
    }

    public boolean isSingleNode() {
        return this.firstNode != null && this.firstNode.nextASTNode == null;
    }

    @Override
    public Class getKnownEgressType() {
        return this.knownEgressType;
    }

    @Override
    public void setKnownEgressType(Class knownEgressType) {
        this.knownEgressType = knownEgressType;
    }

    @Override
    public Class getKnownIngressType() {
        return this.knownIngressType;
    }

    @Override
    public void setKnownIngressType(Class knownIngressType) {
        this.knownIngressType = knownIngressType;
    }

    @Override
    public boolean isConvertableIngressEgress() {
        return this.convertableIngressEgress;
    }

    @Override
    public void computeTypeConversionRule() {
        if (this.knownIngressType != null && this.knownEgressType != null) {
            this.convertableIngressEgress = this.knownIngressType.isAssignableFrom(this.knownEgressType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        if (!this.optimized) {
            this.setupOptimizers();
            try {
                Object object = this.getValue(ctx, variableFactory);
                return object;
            }
            finally {
                OptimizerFactory.clearThreadAccessorOptimizer();
            }
        }
        return this.getValue(ctx, variableFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(Object staticContext, VariableResolverFactory factory) {
        if (!this.optimized) {
            this.setupOptimizers();
            try {
                Object object = this.getValue(staticContext, factory);
                return object;
            }
            finally {
                OptimizerFactory.clearThreadAccessorOptimizer();
            }
        }
        return this.getDirectValue(staticContext, factory);
    }

    public Object getDirectValue(Object staticContext, VariableResolverFactory factory) {
        return MVELRuntime.execute(false, this, staticContext, this.parserConfiguration.getVariableFactory(factory));
    }

    private void setupOptimizers() {
        this.optimized = true;
    }

    @Override
    public boolean intOptimized() {
        return false;
    }

    public ParserConfiguration getParserConfiguration() {
        return this.parserConfiguration;
    }

    public boolean isImportInjectionRequired() {
        return this.parserConfiguration.hasImports();
    }

    @Override
    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        return null;
    }

    @Override
    public boolean isLiteralOnly() {
        return this.literalOnly;
    }

    @Override
    public boolean isEmptyStatement() {
        return this.firstNode == null;
    }

    @Override
    public boolean isExplicitCast() {
        return this.firstNode != null && this.firstNode instanceof TypeCast;
    }

    public String toString() {
        StringBuilder appender = new StringBuilder();
        ASTNode node = this.firstNode;
        while (node != null) {
            appender.append(node).append(";\n");
            node = node.nextASTNode;
        }
        return appender.toString();
    }
}

